# -*- coding: utf-8 -*-

import shutil
import sys
sys.path.append("/opt/cdnfly/master/")
import subprocess
import daemon
import paramiko
reload(sys) 
sys.setdefaultencoding('utf8')
import json
import traceback
from conf.config import VERSION_NAME
from view.util import find_gunicorn_port

log_file = "/tmp/master_transfer.log"

class log(object):
    def __init__(self, arg):
        super(log, self).__init__()
        self.arg = arg
    
    @staticmethod
    def error(info):
        print info
        if not info.endswith("\n"):
            info += "\n"        
        with open(log_file,"a") as fp:
            fp.write(u"[ERROR] " + info)

    @staticmethod
    def info(info):
        print info
        if not info.endswith("\n"):
            info += "\n"        
        with open(log_file,"a") as fp:
            fp.write(u"[INFO] " + info)

    @staticmethod
    def warning(info):
        print info
        if not info.endswith("\n"):
            info += "\n"
        with open(log_file,"a") as fp:
            fp.write(u"[WARNING] " + info)



def main(info):
    # 清空日志
    with open(log_file,"w") as fp:
        fp.write("[INFO] 开始迁移.\n")

    ssh_ip = info['ssh_ip']
    ssh_user = info['ssh_user']
    ssh_pass = info['ssh_pass']
    ssh_port = info['ssh_port']
    es_dir = info['es_dir']
    with_bt = info['with_bt']

    # 验证是否是root权限的用户
    log.info("验证是否是root权限用户")
    ssh = paramiko.SSHClient()
    ssh.set_missing_host_key_policy(paramiko.AutoAddPolicy())
    ssh.connect(hostname=ssh_ip, username=ssh_user, password=info['ssh_pass'], port=int(ssh_port),timeout=30)

    sudo_cmd = ""
    stdin, stdout, stderr = ssh.exec_command("id -u")
    if stdout.read().strip() == "0":
        log.info("是root权限用户")

    else:
        sudo_cmd = "echo {ssh_pass} | sudo -SE ".format(ssh_pass=ssh_pass)
        log.info("非root权限用户，使用sudo执行命令")
    
    master_port = find_gunicorn_port()

    # 安装主控程序
    log.info("开始安装主控程序...")
    download_cmd = "curl -m 5 https://agent.3amcdn.online/master/master.sh -o /tmp/master.sh || curl -m 5 https://agent.3amcdn.online/master/master.sh -o /tmp/master.sh && cd /tmp/ && chmod +x master.sh && "
    cmd =  download_cmd + " {sudo_cmd} /tmp/master.sh --ver {version_name}  --es-dir {es_dir} --master-port {master_port} ".format(version_name=VERSION_NAME, sudo_cmd=sudo_cmd,es_dir=es_dir, master_port=master_port)
    mysql_ip = "localhost"
    mysql_db = "cdn"
    mysql_user = "root"
    mysql_pass = "@cdnflypass"

    if with_bt:
        log.info("安装在宝塔环境下.")
        mysql_ip = info['mysql_ip']
        mysql_db = info['mysql_db']
        mysql_user = info['mysql_user']
        mysql_pass = info['mysql_pass']
        cmd = download_cmd + " {sudo_cmd} /tmp/master.sh --ver {version_name}  --es-dir {es_dir} --master-port {master_port} --no-mysql --mysql-ip {mysql_ip} --mysql-db {mysql_db} --mysql-user {mysql_user} --mysql-pass {mysql_pass} --with-bt".format(version_name=VERSION_NAME, sudo_cmd=sudo_cmd, es_dir=es_dir, mysql_ip=mysql_ip, mysql_db=mysql_db, mysql_user=mysql_user,mysql_pass=mysql_pass, master_port=master_port)

    stdin, stdout, stderr = ssh.exec_command(cmd)
    # 实时输出标准输出流
    while True:
        line = stdout.readline()
        if not line:
            break

        log.info(line.strip())

    # 实时输出标准错误流
    while True:
        line = stderr.readline()
        if not line:
            break

        log.info(line.strip())

    channel = stdout.channel
    status = channel.recv_exit_status()
    if status != 0:
        log.error("安装主控程序出错,退出.")
        return
    
    ssh.close()

    log.info("安装主控程序完成.")

    # 传输/opt/cdnfly/master/conf/config.py和/opt/cdnfly/master/panel到新主控
    log.info("开始传输配置文件及UI文件...")

    # 如果是安装在宝塔环境，替换config.py里的mysql连接信息
    shutil.copyfile("/opt/cdnfly/master/conf/config.py","/tmp/config.py")
    
    subprocess.check_output(''' sed -i 's#MYSQL_IP.*#MYSQL_IP="{mysql_ip}"#' /tmp/config.py '''.format(mysql_ip=mysql_ip),shell=True)
    subprocess.check_output(''' sed -i 's#MYSQL_USER.*#MYSQL_USER="{mysql_user}"#' /tmp/config.py '''.format(mysql_user=mysql_user),shell=True)
    subprocess.check_output(''' sed -i 's#MYSQL_PASS.*#MYSQL_PASS="{mysql_pass}"#' /tmp/config.py '''.format(mysql_pass=mysql_pass),shell=True)
    subprocess.check_output(''' sed -i 's#MYSQL_DB.*#MYSQL_DB="{mysql_db}"#' /tmp/config.py '''.format(mysql_db=mysql_db),shell=True)

    ssh.connect(hostname=info['ssh_ip'], username=info['ssh_user'], password=info['ssh_pass'], port=int(info['ssh_port']),timeout=10)
    sftp = ssh.open_sftp()
    # 传输config.py
    sftp.put('/tmp/config.py', '/tmp/config.py')

    # 打包panel及传输
    subprocess.check_output("cd /opt/cdnfly/master && tar czf panel.tar.gz panel",shell=True)
    sftp.put('/opt/cdnfly/master/panel.tar.gz', '/tmp/panel.tar.gz')

    # 解压
    stdin, stdout, stderr = ssh.exec_command("cd /opt/cdnfly/master && {sudo_cmd} tar xf /tmp/panel.tar.gz && {sudo_cmd} \cp /tmp/config.py  /opt/cdnfly/master/conf/config.py && rm -f /tmp/panel.tar.gz && rm -f /tmp/config.py".format(sudo_cmd=sudo_cmd))
    log.info(stdout.read())
    log.info(stderr.read())

    channel = stdout.channel
    status = channel.recv_exit_status()
    if status != 0:
        log.error("解压出错,退出.")
        return
    
    sftp.close()
    ssh.close()
    log.info("传输完成.")

    # 初始化es
    log.info("开始初始化elasticsearch...")
    ssh.connect(hostname=info['ssh_ip'], username=info['ssh_user'], password=info['ssh_pass'], port=int(info['ssh_port']),timeout=10)
    download_cmd = "curl -m 5 https://agent.3amcdn.online/cdnfly/int_es.sh -o /tmp/int_es.sh || curl -m 5 https://agent.3amcdn.online/cdnfly/int_es.sh -o /tmp/int_es.sh && cd /tmp/ && chmod +x int_es.sh && "
    cmd = download_cmd + "{sudo_cmd} /tmp/int_es.sh {es_dir}".format(sudo_cmd=sudo_cmd, es_dir=es_dir)
    stdin, stdout, stderr = ssh.exec_command(cmd)
    # 实时输出标准输出流
    while True:
        line = stdout.readline()
        if not line:
            break

        log.info(line.strip())

    # 实时输出标准错误流
    while True:
        line = stderr.readline()
        if not line:
            break

        log.info(line.strip())

    channel = stdout.channel
    status = channel.recv_exit_status()
    if status != 0:
        log.error("初始化es出错,退出.")
        return
    
    ssh.close()
    log.info("初始化elasticsearch完成.")

    # 备份旧主控数据库(后台执行脚本)
    cmd = "curl -m 5 http://agent.3amcdn.online/cdnfly/backup_master.sh -o /tmp/backup_master.sh || curl -m 5 https://agent.3amcdn.online/cdnfly/backup_master.sh -o /tmp/backup_master.sh && cd /tmp/ && chmod +x backup_master.sh && ./backup_master.sh"
    log.info("开始备份数据库...")
    try:
        ret = subprocess.check_output(cmd,shell=True)
        log.info(ret)

    except subprocess.CalledProcessError as e:
        log.error(e.output)
        return
    
    log.info("备份数据库完成.")

    # 传到新主控
    log.info("开始传送备份到新主控...")
    ssh.connect(hostname=info['ssh_ip'], username=info['ssh_user'], password=info['ssh_pass'], port=int(info['ssh_port']),timeout=10)
    sftp = ssh.open_sftp()
    sftp.put('/root/cdn.sql.gz', '/tmp/cdn.sql.gz')
    sftp.close()
    log.info("传送数据库备份到新主控完成.")
    
    log.info("开始恢复备份到新主控...")
    # 连接远程恢复备份（后台执行脚本）
    cmd = "{sudo_cmd} \cp /tmp/cdn.sql.gz /root/cdn.sql.gz && (curl -m 5 http://agent.3amcdn.online/cdnfly/restore_master.sh -o /tmp/restore_master.sh || curl -m 5 http://agent.3amcdn.online/cdnfly/restore_master.sh -o /tmp/restore_master.sh) && cd /tmp/ &&  chmod +x restore_master.sh && {sudo_cmd} /tmp/restore_master.sh && rm -f /tmp/cdn.sql.gz ".format(sudo_cmd=sudo_cmd)
    stdin, stdout, stderr = ssh.exec_command(cmd)
    # 实时输出标准输出流
    while True:
        line = stdout.readline()
        if not line:
            break

        log.info(line.strip())

    # 实时输出标准错误流
    while True:
        line = stderr.readline()
        if not line:
            break

        log.info(line.strip())
        
    channel = stdout.channel
    status = channel.recv_exit_status()
    if status != 0:
        log.error("恢复备份出错.")
        return

    ssh.close()
    log.info("恢复备份完成.")
    log.info("完成主控迁移.")
    log.info("请按照文档继续之后的操作.")

if __name__ == '__main__':
    info = json.loads(sys.argv[1])
    if len(sys.argv) == 3:
        if sys.argv[2] == "daemon":
            with daemon.DaemonContext():
                try:
                    main(info)
                except Exception as e:
                    msg = traceback.format_exc()
                    log.error(msg)
                    sys.exit(1)

    else:    
        try:
            main(info)
        except Exception as e:
            msg = traceback.format_exc()
            log.error(msg)
            sys.exit(1)
