#!/bin/bash 

if [[ ! -d /opt/cdnfly-50507-bak ]];then
    echo "未发现cdnfly-50507-bak目录"
    exit 1
fi

# 恢复cdnfly
rm -rf /opt/cdnfly 
\cp -a /opt/cdnfly-50507-bak /opt/cdnfly 

# es
eval `grep LOG_IP /opt/cdnfly/master/conf/config.py`
eval `grep LOG_PWD /opt/cdnfly/master/conf/config.py`

curl -u elastic:$LOG_PWD -X PUT "$LOG_IP:9200/_ingest/pipeline/nginx_access_pipeline?pretty" -H 'Content-Type: application/json' -d'
{
  "description" : "nginx access pipeline",
  "processors" : [
      {
        "dissect": {
          "field": "message",
          "ignore_failure": true,
          "pattern" : "%{nid}\t%{uid}\t%{upid}\t%{site_id}\t%{time}\t%{addr}\t%{method}\t%{scheme}\t%{host}\t%{server_port}\t%{req_uri}\t%{protocol}\t%{status}\t%{bytes_sent}\t%{referer}\t%{user_agent}\t%{content_type}\t%{up_resp_time}\t%{cache_status}\t%{up_recv}\t%{country}\t%{province}\t%{city}"
         }
      },
      {
          "remove": {
            "field": "message"
          }      
      },
      {
        "script": { 
          "lang":   "painless",
          "ignore_failure": true,
          "source": "if (ctx[\u0027scheme\u0027] == \"http\") {ctx[\u0027bytes_sent\u0027] = Integer.parseInt(ctx[\u0027bytes_sent\u0027]) + 300} else { ctx[\u0027bytes_sent\u0027] = Integer.parseInt(ctx[\u0027bytes_sent\u0027]) + 5300 }  "
        }

      }             
  ],
    "on_failure" : [
    {
      "set" : {
        "field" : "_index",
        "value" : "failed-{{ _index }}"
      }
    }
  ]  
}
'

curl -u elastic:$LOG_PWD  -X PUT "$LOG_IP:9200/_template/http_access_template" -H 'Content-Type: application/json' -d'
{
  "mappings": {
    "properties": {
      "nid":    { "type": "keyword" },  
      "uid":    { "type": "keyword" },  
      "upid":    { "type": "keyword" },  
      "site_id":    { "type": "keyword" }, 
      "time":   { "type": "date"  ,"format":"dd/MMM/yyyy:HH:mm:ss Z"},
      "addr":  { "type": "keyword"  }, 
      "method":  { "type": "text" , "index":false }, 
      "scheme":  { "type": "keyword"  }, 
      "host":  { "type": "keyword"  }, 
      "server_port":  { "type": "keyword"  }, 
      "req_uri":  { "type": "keyword"  }, 
      "protocol":  { "type": "text" , "index":false }, 
      "status":  { "type": "keyword"  }, 
      "bytes_sent":  { "type": "integer"  }, 
      "referer":  { "type": "keyword"  }, 
      "user_agent":  { "type": "text" , "index":false }, 
      "content_type":  { "type": "text" , "index":false }, 
      "up_resp_time":  { "type": "float" , "index":false,"ignore_malformed": true }, 
      "cache_status":  { "type": "keyword"  }, 
      "up_recv":  { "type": "integer", "index":false,"ignore_malformed": true  },
      "country":  { "type": "keyword"  }, 
      "province":  { "type": "keyword" }, 
      "city":  { "type": "text" , "index":false }
    }
  },  
  "index_patterns": ["http_access-*"], 
  "settings": {
    "number_of_shards": 1,
    "number_of_replicas": 0,
    "index.lifecycle.name": "access_log_policy", 
    "index.lifecycle.rollover_alias": "http_access"
  }
}
'

# 数据库
cat > /tmp/_db.py <<'EOF'
# -*- coding: utf-8 -*-

import sys
sys.path.append("/opt/cdnfly/master/")
from model.db import Db
from view.util import is_ip, is_ipv6, get_md5,escape_re_str,is_empty
from conf.config import ALLOW_HOSTS
from jinja2 import Template
import pymysql
import json
reload(sys) 
import os
import tarfile
import base64
sys.setdefaultencoding('utf8')

conn = Db()
try:
    # site的proxy_connect_timeout
    if conn.fetchone("SELECT column_name FROM information_schema.columns WHERE table_name = 'site' AND column_name = 'proxy_connect_timeout' "):
        conn.execute("alter table site drop proxy_connect_timeout")
        conn.commit()


    # 错误页
    if conn.fetchone("SELECT column_name FROM information_schema.columns WHERE table_name = 'site' AND column_name = 'page_403' "):
        conn.execute("alter table site drop page_403 ")
        conn.commit()

    if conn.fetchone("SELECT column_name FROM information_schema.columns WHERE table_name = 'site' AND column_name = 'page_500' "):
        conn.execute("alter table site drop page_500 ")
        conn.commit()

    if conn.fetchone("SELECT column_name FROM information_schema.columns WHERE table_name = 'site' AND column_name = 'page_502' "):
        conn.execute("alter table site drop page_502")
        conn.commit()

    if conn.fetchone("SELECT column_name FROM information_schema.columns WHERE table_name = 'site' AND column_name = 'page_504' "):
        conn.execute("alter table site drop page_504")
        conn.commit()


    if not conn.fetchone("SELECT column_name FROM information_schema.columns WHERE table_name = 'site' AND column_name = 'page_50x' "):
        conn.execute("alter table site add page_50x text after page_404")
        conn.commit()

    
    # 四层区域屏蔽
    if conn.fetchone("SELECT column_name FROM information_schema.columns WHERE table_name = 'stream' AND column_name = 'block_region' "):
        conn.execute("alter table stream drop block_region")
        conn.commit()

    # 套餐中的http3
    if conn.fetchone("SELECT column_name FROM information_schema.columns WHERE table_name = 'package' AND column_name = 'http3' "):
        conn.execute("alter table package drop http3")
        conn.commit()

    if conn.fetchone("SELECT column_name FROM information_schema.columns WHERE table_name = 'user_package' AND column_name = 'http3' "):
        conn.execute("alter table user_package drop http3")
        conn.commit()

    conn.execute("update site set page_50x='' where page_50x is null ")
    conn.execute("update stream set version=version+1;")
    conn.execute("update site set version=version+1;")
    conn.commit()


except:
    conn.rollback()
    raise

finally:
    conn.close()
EOF

/opt/venv/bin/python /tmp/_db.py

rm -f /tmp/master_upgrade_*.done 

# 恢复site_conf_cache
eval `grep MYSQL_PASS /opt/cdnfly/master/conf/config.py`
eval `grep MYSQL_IP /opt/cdnfly/master/conf/config.py`
eval `grep MYSQL_PORT /opt/cdnfly/master/conf/config.py`
eval `grep MYSQL_DB /opt/cdnfly/master/conf/config.py`
eval `grep MYSQL_USER /opt/cdnfly/master/conf/config.py`
mysql -h$MYSQL_IP -u$MYSQL_USER -p$MYSQL_PASS -P$MYSQL_PORT $MYSQL_DB < /opt/site_conf_cache.sql

supervisorctl -c /opt/cdnfly/master/conf/supervisord.conf reload
echo "恢复完成!"