#!/bin/bash -x

export PATH="/opt/venv/bin:/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:/snap/bin"

if [[ ! -f /tmp/task_last_execute.time ]]; then
    exit 0
fi

# master停止时，不再监控
if [[ `supervisorctl -c /opt/cdnfly/master/conf/supervisord.conf status master | grep RUNNING` == "" ]];then
    echo "master is stop,exit"
    exit 0
fi

last_time=`cat /tmp/task_last_execute.time`
now_time=`date +%s`

num=$((now_time - last_time))
abs_num=$((num < 0 ? -1 * num : num))

if [[ $abs_num -gt 300 ]]; then
    pass_time=2000

    if [[ -f /tmp/monitor_restart.time ]];then
        restart_time=`cat /tmp/monitor_restart.time`
        pass_time=$((now_time - restart_time))
    fi

    # 半小时最多重启一次
    if [[ $pass_time -gt 1800 ]]; then
        supervisorctl -c /opt/cdnfly/master/conf/supervisord.conf status | grep -vE "master" | awk '{print $1}' | xargs supervisorctl -c /opt/cdnfly/master/conf/supervisord.conf  restart 
        echo $now_time > /tmp/monitor_restart.time
    fi
    
fi
