server {
    set $areacode "";
    set $isp "";
    set $asnumber "";
    set $backend_server_port "";
    set $backend_host "";
    set $upgrade_header "";
    set $connection_header "";
    set $backend_protocol "http";

    {# 如果site表有监听80端口，那么就标记一下，以便让config_task不做处理 #}
    {% if site.http_80_site_listen %}
        # http_80_site_listen
    {% endif %}

    server_name localhost;

    {# http监听 #}
    {% if site.http_port %}
        {%- for p in site.http_port %}
            listen {{p}} reuseport;
            listen [::]:{{p}} reuseport;
        {%- endfor %}
    {% endif %}

    ssl_protocols                TLSv1 TLSv1.1 TLSv1.2 TLSv1.3;
    ssl_ciphers ECDHE-ECDSA-AES256-GCM-SHA384:ECDHE-RSA-AES256-GCM-SHA384:ECDHE-ECDSA-CHACHA20-POLY1305:ECDHE-RSA-CHACHA20-POLY1305:DHE-RSA-AES128-GCM-SHA256:DHE-RSA-AES256-GCM-SHA384;
    ssl_prefer_server_ciphers off;

    {# https监听 #}
    {% if site.https_port %}
        ssl_client_hello_by_lua_file "/opt/cdnfly/nginx/on_ssl_client_hello.lua";

        {%- for p in site.https_port %}
            listen {{p}} ssl reuseport;
            listen [::]:{{p}} ssl reuseport;

            listen {{p}} quic reuseport;
            listen [::]:{{p}} quic reuseport;

        {%- endfor %}

        {# 证书 #}
        ssl_certificate /opt/cdnfly/agent/conf/default.cert;
        ssl_certificate_key /opt/cdnfly/agent/conf/default.key;

        ssl_certificate_by_lua_file "/opt/cdnfly/nginx/on_ssl_certificate.lua";
        ssl_session_cache shared:SSL:10m;
    {% endif %}


    {# 旋转图片 #}
    location ~ /guard/__rotate_img__/ {
        internal;
        more_set_headers "Content-Type: image/png";
        rewrite /guard/__rotate_img__/(.*) /$1 break;
        root /opt/cdnfly/nginx/conf/rotate/;
    }

    {# 验证码图片 #}
    location ~ /guard/__captcha_img__/ {
        internal;
        more_set_headers "Content-Type: image/png";
        rewrite /guard/__captcha_img__/(.*) /$1 break;
        root /opt/cdnfly/nginx/conf/captcha/;
    }

    {# 点击图片 #}
    location ~ /guard/__click_img__/ {
        internal;
        more_set_headers "Content-Type: image/jpeg";
        rewrite /guard/__click_img__/(.*) /$1 break;
        root /opt/cdnfly/nginx/conf/click/;
    }

    {# 滑动图片 #}
    location ~ /guard/__slide_img__/ {
        internal;
        more_set_headers "Content-Type: image/png";
        rewrite /guard/__slide_img__/(.*) /$1 break;
        root /opt/cdnfly/nginx/conf/slide/;
    }

    {# 简单点击图片 #}
    location ~ /guard/__easy_click_img__/ {
        internal;
        more_set_headers "Content-Type: image/jpeg";
        rewrite /guard/__easy_click_img__/(.*) /$1 break;
        root /opt/cdnfly/nginx/conf/click-easy/;
    }

    {# 简单滑动图片 #}
    location ~ /guard/__easy_slide_img__/ {
        internal;
        more_set_headers "Content-Type: image/png";
        rewrite /guard/__easy_slide_img__/(.*) /$1 break;
        root /opt/cdnfly/nginx/conf/slide-easy/;
    }

    # server级别
    proxy_http_version 1.1;
    proxy_cache cache;
    
    location / {
        proxy_pass ${backend_protocol}://backend;
        
        # 设置host
        proxy_ssl_server_name on;
        proxy_ssl_name $backend_host;
        proxy_set_header Host $backend_host;

        # timeout
        proxy_connect_timeout 5s;
        proxy_read_timeout 10s;
        proxy_send_timeout 10s;

        # slice
        slice             1m;
        proxy_cache_valid 200 206 1d;
        proxy_set_header  Range $slice_range;

        # cache key
        proxy_cache_key $scheme://$host$uri;
        proxy_cache_key1 $scheme://$host$uri;
        proxy_cache_key2 $scheme://$host$request_uri;
        proxy_cache_key3 $scheme://$host$uri~$slice_range;
        proxy_cache_key4 $scheme://$host$request_uri~$slice_range;

        # 真实IP
        # proxy_set_header        X-Real-IP       $remote_addr;
        # proxy_set_header        X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header        X-Forwarded-Proto $thescheme;

        # gzip
        gzip on;
        gzip_types text/plain text/css text/xml text/javascript application/javascript application/x-javascript application/json;
        gzip_comp_level 3;

        # websocket
        proxy_set_header Upgrade $upgrade_header;
        proxy_set_header Connection $connection_header;

    }


}