daemon on;
error_log  {{config.logs_dir}}/error.log  error ;
pid logs/nginx.pid;
thread_pool default threads=32 max_queue=65536;

worker_processes  {{config.worker_processes}};
worker_cpu_affinity auto;
worker_rlimit_nofile {{config.worker_rlimit_nofile}};
worker_shutdown_timeout {{config.worker_shutdown_timeout}};
pcre_jit on;

events {
    accept_mutex off;
    use epoll;
    worker_connections  {{config.worker_connections}};
    worker_aio_requests 32;
}

http {
    open_file_cache max=5000 inactive=60s;
    autoindex off;
    
    # gzip
    gzip off;
    gzip_comp_level {{config.http.gzip_comp_level}};
    gzip_http_version {{config.http.gzip_http_version}};
    gzip_min_length {{config.http.gzip_min_length}};
    gzip_proxied off;
    gzip_vary {{config.http.gzip_vary}};

    # log
    log_format  access escape=json  '__NODE_ID__\t$uid\t$upid\t$site_id\t$time_local\t$remote_addr\t$request_method\t$scheme\t$server_name2\t$host\t$server_port\t$request_uri\t$server_protocol\t$status\t$bytes_sent_custom\t$http_referer\t$http_user_agent\t$sent_http_content_type\t$up_resp_time\t$cache_status\t$up_bytes_received\t$country\t$province\t$city\t$req_header\t$resp_header\t$req_body\t$backend_server_port\t$l1_cache_status\t$l2_cache_status\t$l2_ip'; 
    access_log {{config.logs_dir}}/access.log access buffer=32k flush=5s;

    map $upstream_response_time $up_resp_time {
        "" "0";
        default $upstream_response_time;
    }

    map $upstream_bytes_received $up_bytes_received {
        "" "0";
        default $upstream_bytes_received;
    }

    map $http_upgrade $connection_upgrade {
        default ""; 
        "websocket" "upgrade";
    }

    map $http_x_forwarded_proto $thescheme {
        default $scheme;
        https https;
    }

    geo $country {
        default "-";
    }

    geo $province {
        default "-";
    }

    geo $city {
        default "-";
    }

    geo $req_header {
        default "-";
    }

    geo $resp_header {
        default "-";
    }

    geo $req_body {
        default "";
    }

    geo $backend_server_port {
        default "-";
    }

    geo $bytes_sent_custom {
        default 0;
    }

    geo $cache_status {
        default "";
    }

    geo $l1_cache_status {
        default "";
    }

    geo $l2_cache_status {
        default "";
    }
    
    geo $l2_ip {
        default "";
    }

    map $areacode $geoip_country_code {
        default $areacode;
    }
    
    # proxy
    proxy_buffer_size 64k;
    proxy_buffers   32 32k;
    proxy_busy_buffers_size 128k;
    proxy_cache_lock on;

    proxy_cache_methods {{config.http.proxy_cache_methods}};
    proxy_cache_valid 301      1h;
    proxy_cache_valid any      1m;
    proxy_http_version {{config.http.proxy_http_version}};
    proxy_max_temp_file_size {{config.http.proxy_max_temp_file_size}};
    proxy_next_upstream {{config.http.proxy_next_upstream}}; 
    proxy_cache_path  {{config.http.proxy_cache_dir}} levels=1:2 keys_zone=cache:200M inactive=30d  max_size={{config.http.proxy_cache_max_size}} use_temp_path=off;

    {% if config.http.server_addr_outgoing == "1" %}
        map $server_addr $bind_address {
            127.0.0.1  "";  # 当server_addr是127.0.0.1时不设置bind地址
            default    $server_addr;  # 其他情况使用server_addr
        }
        proxy_bind $bind_address transparent;
    {% endif %}

    resolver 223.5.5.5 223.6.6.6 local=on;

    # other
    client_body_buffer_size {{config.http.client_body_buffer_size}}k;
    underscores_in_headers on;
    more_set_headers "Server: {{config.http.server}}";
    client_max_body_size {{config.http.client_max_body_size}};
    default_type {{config.http.default_type}};
    keepalive_requests {{config.http.keepalive_requests}};
    keepalive_timeout {{config.http.keepalive_timeout}};
    log_not_found {{config.http.log_not_found}};
    server_names_hash_max_size {{config.http.server_names_hash_max_size}};
    server_names_hash_bucket_size {{config.http.server_names_hash_bucket_size}};
    server_tokens {{config.http.server_tokens}};
    large_client_header_buffers {{config.http.large_client_header_buffers}};

    # ssl
    ssl_ciphers ECDHE-RSA-AES128-GCM-SHA256:ECDHE:ECDH:AES:HIGH:!NULL:!aNULL:!MD5:!ADH:!RC4:!DH:!DHE;
    ssl_prefer_server_ciphers on;

    # cc
    lua_socket_log_errors off;
    lua_worker_thread_vm_pool_size 10;
    lua_package_path "/opt/cdnfly/nginx/lib/?.lua;/opt/cdnfly/nginx/lib/?/init.lua;;";
    lua_package_cpath "/opt/cdnfly/nginx/lib/?.so;;";
    lua_shared_dict guard 150m;
    lua_shared_dict dict_captcha 60m;
    lua_shared_dict log 50m;
    lua_shared_dict white 50m;
    lua_shared_dict black 50m;
    lua_shared_dict healthcheck 100m;
    lua_shared_dict cert 300m;
    init_by_lua_file "/opt/cdnfly/nginx/on_init.lua";
    init_worker_by_lua_file "/opt/cdnfly/nginx/on_init_worker.lua";
    access_by_lua_file "/opt/cdnfly/nginx/on_access.lua";
    header_filter_by_lua_file "/opt/cdnfly/nginx/on_header_filter.lua";
    body_filter_by_lua_file "/opt/cdnfly/nginx/on_body_filter.lua";
    log_by_lua_file  "/opt/cdnfly/nginx/on_log.lua";

    upstream backend {
        server 1.2.3.4:5;
        balancer_by_lua_file  "/opt/cdnfly/nginx/on_balancer.lua";
        keepalive 500;
        keepalive_timeout 50s;
    }

    server {
        merge_slashes off;
        set $rule_name 6;
        set $areacode "";
        set $uid 0;
        set $upid 0;
        set $site_id 0;
        set $server_name2 000.com;
        listen unix:/var/run/nginx.sock;
        location /nginx-status {
            stub_status on;
        }

        access_log off;
    }

    server {
        merge_slashes off;
        set $rule_name 6;
        set $areacode "";
        set $uid 0;
        set $upid 0;
        set $site_id 0;
        set $server_name2 000.com;

        access_by_lua_block {;}
        header_filter_by_lua_block {;}
        body_filter_by_lua_block {;}
        log_by_lua_block  {;}


        listen unix:/var/run/nginx-events.sock;

        location / {
            content_by_lua_block {
                 _G.ev:run()
            }
        }

        access_log off;
    }
        
    include listen_80.conf;
    include listen_other.conf;
}

stream {
    log_format basic '__NODE_ID__\t$uid\t$upid\t$server_port/$protocol\t$remote_addr\t$time_local\t$status\t$bytes_sent\t$bytes_received\t$session_time';
    access_log {{config.logs_dir}}/stream.log basic;
    limit_conn_zone $binary_remote_addr zone=addr:100m;
    proxy_connect_timeout {{config.stream.proxy_connect_timeout}};
    proxy_timeout {{config.stream.proxy_timeout}};

    lua_add_variable $uid;
    lua_add_variable $upid;

    # cc
    lua_socket_log_errors off;
    lua_package_path "/opt/cdnfly/nginx/lib/?.lua;;";
    lua_package_cpath "/opt/cdnfly/nginx/lib/?.so;;";
    lua_shared_dict stream 150m;
    init_by_lua_file "/opt/cdnfly/nginx/stream_on_init.lua";
    init_worker_by_lua_file "/opt/cdnfly/nginx/stream_on_init_worker.lua";
    preread_by_lua_file "/opt/cdnfly/nginx/stream_on_preread.lua";

    upstream stream_backend {
        server 1.2.3.4:5;
        balancer_by_lua_file "/opt/cdnfly/nginx/stream_on_balancer.lua";
    }

    resolver 223.5.5.5 223.6.6.6 local=on;

    server {
        listen unix:/var/run/stream-nginx.sock;
        preread_by_lua_block {return}
        content_by_lua_file "/opt/cdnfly/nginx/stream_on_default_content.lua";
    }

    include stream_listen.conf;
}


