#!/usr/bin/bash -x

# huaweicloud_access_key_id
# huaweicloud_serect_access_key

iam_api="https://iam.myhuaweicloud.com"
dns_api="https://dns.ap-southeast-1.myhuaweicloud.com" # Should work

########  Public functions #####################

# Usage: add  _acme-challenge.www.domain.com   "XKrxpRBosdIKFzxW_CT3KLZNf6q0HG9i01zxXp5CPBs"
# Used to add txt record
#
# Ref: https://support.huaweicloud.com/intl/zh-cn/api-dns/zh-cn_topic_0132421999.html
#

dns_huaweicloud2_add() {
  fulldomain=$1
  txtvalue=$2

  huaweicloud_access_key_id="${huaweicloud_access_key_id:-$(_readaccountconf_mutable huaweicloud_access_key_id)}"
  huaweicloud_serect_access_key="${huaweicloud_serect_access_key:-$(_readaccountconf_mutable huaweicloud_serect_access_key)}"

  # Check information
  if [ -z "${huaweicloud_access_key_id}" ] || [ -z "${huaweicloud_serect_access_key}" ]; then
    _err "Not enough information provided to dns_huaweicloud!"
    return 1
  fi

  _debug "Adding Record"
  cd /opt/cdnfly/master/tasks/dnsapi
  ret=`/opt/venv/bin/python -c "import huaweicloud;huaweicloud.add_record_acme(\"${huaweicloud_access_key_id}\",\"${huaweicloud_serect_access_key}\",\"${fulldomain}\",\"${txtvalue}\" )"`
  if [[ $ret != "ok" ]];then
    _err "$ret"
    return 1
  fi

  # Do saving work if all succeeded
  _saveaccountconf_mutable huaweicloud_access_key_id "${huaweicloud_access_key_id}"
  _saveaccountconf_mutable huaweicloud_serect_access_key "${huaweicloud_serect_access_key}"
  return 0
}

# Usage: fulldomain txtvalue
# Used to remove the txt record after validation
#
# Ref: https://support.huaweicloud.com/intl/zh-cn/api-dns/dns_api_64005.html
#

dns_huaweicloud2_rm() {
  fulldomain=$1
  txtvalue=$2

  huaweicloud_access_key_id="${huaweicloud_access_key_id:-$(_readaccountconf_mutable huaweicloud_access_key_id)}"
  huaweicloud_serect_access_key="${huaweicloud_serect_access_key:-$(_readaccountconf_mutable huaweicloud_serect_access_key)}"

  # Check information
  if [ -z "${huaweicloud_access_key_id}" ] || [ -z "${huaweicloud_serect_access_key}" ] ; then
    _err "Not enough information provided to dns_huaweicloud!"
    return 1
  fi



  _debug "Removing Record"
  cd /opt/cdnfly/master/tasks/dnsapi
  ret=`/opt/venv/bin/python -c "import huaweicloud;huaweicloud.rm_record_acme(\"${huaweicloud_access_key_id}\",\"${huaweicloud_serect_access_key}\",\"${fulldomain}\" )"`
  if [[ $ret != "ok" ]];then
    _err "$ret"
    return 1
  fi

  return 0
}




