#!/bin/bash

# Dns.com Domain api
#
#dns_com_key="1234"
#
#dns_com_secret="sADDsdasdgdsf"

REST_API="https://www.51dns.com/api"

########  Public functions #####################

#Usage: add  _acme-challenge.www.domain.com   "XKrxpRBosdIKFzxW_CT3KLZNf6q0HG9i01zxXp5CPBs"
dns_com_add() {
  fulldomain=$1
  txtvalue=$2

  dns_com_key="${dns_com_key:-$(_readaccountconf_mutable dns_com_key)}"
  dns_com_secret="${dns_com_secret:-$(_readaccountconf_mutable dns_com_secret)}"
  if [ -z "$dns_com_key" ] || [ -z "$dns_com_secret" ]; then
    dns_com_key=""
    dns_com_secret=""
    _err "You don't specify dns.com api key and key id yet."
    _err "Please create you key and try again."
    return 1
  fi

  #save the api key and email to the account conf file.
  _saveaccountconf_mutable dns_com_key "$dns_com_key"
  _saveaccountconf_mutable dns_com_secret "$dns_com_secret"

  _debug "First detect the root zone"
  if ! _get_root "$fulldomain"; then
    _err "invalid domain"
    return 1
  fi

  add_record "$_domain" "$_sub_domain" "$txtvalue"

}

#fulldomain txtvalue
dns_com_rm() {
  fulldomain=$1
  txtvalue=$2

  dns_com_key="${dns_com_key:-$(_readaccountconf_mutable dns_com_key)}"
  dns_com_secret="${dns_com_secret:-$(_readaccountconf_mutable dns_com_secret)}"

  _debug "First detect the root zone"
  if ! _get_root "$fulldomain"; then
    _err "invalid domain"
    return 1
  fi

  timestamp="$(date +%s)"
  apiKey=$dns_com_key

  if ! _rest POST "record/list/" "apiKey=$apiKey&domainID=$_domain_id&host=$_sub_domain&timestamp=$timestamp"; then
    _err "Record.Lis error."
    return 1
  fi

  if _contains "$response" 'No records'; then
    _info "Don't need to remove."
    return 0
  fi

  for record_id in `echo "$response" | grep -oE "recordID\":([0-9])*" | tr -d 'recordID":'`;do
    _debug record_id "$record_id"
    if [ -z "$record_id" ]; then
      _err "Can not get record id."
      return 1
    fi

    if ! _rest POST "record/remove/" "apiKey=$apiKey&domainID=$_domain_id&recordID=$record_id&timestamp=$timestamp"; then
        _err "Record.Remove error."
        return 1
    fi

    _contains "$response" '"code":0'

  done

}

#add the txt record.
#usage: root  sub  txtvalue
add_record() {
  root=$1
  sub=$2
  txtvalue=$3
  fulldomain="$sub.$root"

  _info "Adding record"

  timestamp="$(date +%s)"
  apiKey=$dns_com_key

  if ! _rest POST "record/create/" "TTL=600&apiKey=$apiKey&domainID=$_domain_id&host=$sub&timestamp=$timestamp&type=TXT&value=$txtvalue"; then
    return 1
  fi

  _contains "$response" '"code":0' || _contains "$response" "解析记录已存在"
}

####################  Private functions below ##################################
#_acme-challenge.www.domain.com
#returns
# _sub_domain=_acme-challenge.www
# _domain=domain.com
# _domain_id=sdjkglgdfewsdfg
_get_root() {
  domain=$1
  i=2
  p=1
  while true; do
    h=$(printf "%s" "$domain" | cut -d . -f $i-100)
    if [ -z "$h" ]; then
      #not valid
      return 1
    fi

    timestamp="$(date +%s)"
    apiKey=$dns_com_key
    if ! _rest POST "domain/getsingle/" "apiKey=$apiKey&domainID=$h&timestamp=$timestamp"; then
      return 1
    fi

    if _contains "$response" '"code":0'; then
      _domain_id=$(printf "%s\n" "$response" | _egrep_o "\"domainID\":[^,]*," | cut -d : -f 2 | tr -d ,)
      _debug _domain_id "$_domain_id"
      if [ "$_domain_id" ]; then
        _sub_domain=$(printf "%s" "$domain" | cut -d . -f 1-$p)
        _debug _sub_domain "$_sub_domain"
        _domain="$h"
        _debug _domain "$_domain"
        return 0
      fi
      return 1
    fi
    p="$i"
    i=$(_math "$i" + 1)
  done
  return 1
}

#Usage: method  URI  data
_rest() {
  m="$1"
  ep="$2"
  data="$3"
  _debug "$ep"
  url="$REST_API/$ep"

  _debug url "$url"

  echo "${data}${dns_com_secret}"

  hash=$(echo -n "${data}${dns_com_secret}" | md5sum | cut -d ' ' -f 1)
  
  IFS='&' read -ra PAIRS <<< "$data"

  json_data="{"
  for pair in "${PAIRS[@]}"; do
      IFS='=' read -ra KV <<< "$pair"
      if [[ "${KV[1]}" =~ ^[0-9]+$ ]];then
        json_data+="\"${KV[0]}\":${KV[1]},"
      else
        json_data+="\"${KV[0]}\":\"${KV[1]}\","
      fi
  done

  json_data+="\"hash\":\"${hash}\""
  json_data+="}"

  if [ "$m" = "GET" ]; then
    response="$(_get "$url" | tr -d '\r')"
  else
    _debug2 data "$data"
    response="$(_post "$json_data" "$url" "" "POST" "application/json" | tr -d '\r')"
  fi

  if [ "$?" != "0" ]; then
    _err "error $ep"
    return 1
  fi
  _debug2 response "$response"
  return 0
}
