use cdn;

CREATE TABLE `node_traffic_log` (
    id BIGINT AUTO_INCREMENT PRIMARY KEY,
    node_id VARCHAR(10) NOT NULL,
    interface VARCHAR(50) NOT NULL,
    bytes_sent BIGINT NOT NULL,
    bytes_received BIGINT NOT NULL,
    create_at DATETIME NOT NULL,
    index node_id_ix(node_id),
    index create_at_idx(create_at),
    index interface_idx(interface),
    index idx_node_time_iface (node_id, create_at, interface)
);

create table `l2_config` (
    `id` int(11) not null auto_increment,
    `region_id` int(11),
    `name` varchar(255),
    `des` varchar(255),
    `mode` varchar(10),
    `balance_way` varchar(10),
    `create_at` datetime,
    primary KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `l2_node` (
    `id` int(11) not null auto_increment,
    `region_id` int(11),
    `node_id` int(11),
    `l2_config_id` int(11),
    `l2_cond_id` int(11),
    `weight` int(11),
    `sort` int(11),
    `enable` boolean,
    primary KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `l2_cond` (
    `id` int(11) not null auto_increment,
    `name` varchar(255),
    `des` varchar(255),
    `data` text,
    `create_at` datetime,
    primary KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


create table `history_domain` (
    `domain` varchar(255),
    `uid` int(11),
    `ip` varchar(255),
    `backend_http_port` int(11),
    `backend_https_port` int(11),
    `backend_protocol` varchar(20),
    `backend_host` varchar(255),
    `create_at` datetime,
    index uid_idx(`uid`),
    index create_at_idx(`create_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `black_ip` (
    `site_id` int(11),
    `ip` varchar(40),
    `filter` varchar(255),
    `uid` int(11),
    `exp` int(11),
    `create_at` int(11),
    `position` varchar(100),
    `auto_unlock` boolean,
    index site_id_idx(`site_id`),
    index ip_idx(`ip`),
    index uid_idx(`uid`),
    index exp_idx(`exp`),
    index create_at_idx(`create_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `domain` (
    `id` int(11) not null auto_increment,
    `site_id` int(11),
    `domain` varchar(255),
    `record_id` varchar(255),
    `task_id` bigint,
    `create_at` datetime,
    primary KEY `id` (`id`),
    index site_id_idx(`site_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `coupon_history` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `des` varchar(255) DEFAULT NULL,
  `coupon_id` int(11) DEFAULT NULL,
  `code` varchar(30) DEFAULT NULL,
  `uid` int(11) DEFAULT NULL,
  `package_id` int(11) DEFAULT NULL,
  `user_package_id` int(11) DEFAULT NULL,
  `package_name` varchar(255) DEFAULT NULL,
  `orgin_price` int(11) DEFAULT NULL,
  `real_price` int(11) DEFAULT NULL,
  `coupon_type` varchar(10) DEFAULT NULL,
  `coupon_price_gt` int(11) DEFAULT NULL,
  `discount_value` double(10,2) DEFAULT NULL,
  `price_value` int(11) DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `code_idx` (`code`),
  KEY `coupon_id_idx` (`coupon_id`),
  KEY `uid_id_idx` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `coupon` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `des` varchar(255) DEFAULT NULL,
  `code` varchar(30) DEFAULT NULL,
  `coupon_type` varchar(10) DEFAULT NULL,
  `price_gt` int(11) DEFAULT NULL,
  `discount_value` double(10,2) DEFAULT NULL,
  `price_value` int(11) DEFAULT NULL,
  `max_times` int(11) DEFAULT NULL,
  `used_times` int(11) DEFAULT NULL,
  `package` varchar(255) DEFAULT NULL,
  `start_at` datetime DEFAULT NULL,
  `end_at` datetime DEFAULT NULL,
  `enable` tinyint(1) DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `code_idx` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `discount` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `des` varchar(255) DEFAULT NULL,
  `user_group` varchar(255) DEFAULT NULL,
  `cate` varchar(20),
  `package` varchar(255) DEFAULT NULL,
  `package_up` varchar(255),
  `dis_type` varchar(10) DEFAULT NULL,
  `discount_value` double(10,2) DEFAULT NULL,
  `month_price` bigint(20) DEFAULT NULL,
  `quarter_price` bigint(20) DEFAULT NULL,
  `year_price` bigint(20) DEFAULT NULL,
  `start_at` datetime DEFAULT NULL,
  `end_at` datetime DEFAULT NULL,
  `priority` int(11) DEFAULT '100',
  `enable` tinyint(1) DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `user_group` (
    `id` int(11) not null AUTO_INCREMENT,
    `name` varchar(255),
    `des` varchar(255),
    `create_at` datetime,
    primary KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `cname_domain` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `des` varchar(255) DEFAULT NULL,
  `domain` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `task` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `pid` bigint,
    `pry` int(11),
    `name` varchar(255),
    `type` varchar(255),
    `res` longtext,
    `data` longtext,
    `depend` text,
    `create_at` datetime,
    `start_at` datetime,
    `end_at` datetime,
    `ret` text,
    `enable` boolean,
    `state` varchar(255),
    `err_times` int(11) default 0,
    `retry_at` datetime,
    `progress` varchar(255),
    KEY `idx_pid` (`pid`),
    KEY `idx_type` (`type`),
    KEY `idx_create_at` (`create_at`),
    KEY `idx_enable` (`enable`),
    KEY `idx_state` (`state`),
    KEY `idx_pry` (`pry`),
    primary KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `site_conf_cache` (
    `site_id` int(11),
    `templ_md5` varchar(32),
    `version` int(11),
    `data` MEDIUMTEXT,
    KEY `idx_site_id` (`site_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `user` (
    `id` int(11) not null AUTO_INCREMENT,
    `email` varchar(255),
    `name` varchar(255),
    `des` varchar(255),
    `phone` varchar(255),
    `qq` varchar(255),
    `user_group` int(11),
    `cert_id` varchar(100),
    `cert_name` varchar(32),
    `cert_no` varchar(32),
    `cert_verified` boolean,
    `auth2_verified` boolean,
    `auth2_enable` boolean,
    `auth2_end_at` datetime,
    `auth2_expire_action` varchar(10),
    `company_name` varchar(50),
    `company_credit_code` varchar(50),
    `company_verified` boolean,
    `id_auth_way` varchar(32),
    `white_ip` varchar(255),
    `login_captcha` varchar(10),
    `balance` bigint default 0,
    `freeze` bigint default 0,
    `create_at` datetime,
    `password` varchar(255),
    `enable` boolean,
    `type` int(11),
    KEY `idx_name` (`name`),
    KEY `idx_email` (`email`),
    KEY `idx_enable` (`enable`),
    KEY `idx_type` (`type`),
    primary KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


create table `login_log` (
    `id` int(11) not null AUTO_INCREMENT,
    `uid` int(11),
    `ip` varchar(255),
    `ip_location` varchar(150),
    `create_at` datetime,
    `success` boolean,
    `post_content` text,
    primary KEY `id` (`id`),
    KEY `idx_ip` (`ip`),
    KEY `idx_success` (`success`),
    KEY `idx_create_at` (`create_at`),
    CONSTRAINT `user_ibfk_1` FOREIGN KEY (`uid`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `region` (
    `id` int(11) not null AUTO_INCREMENT,
    `name` varchar(255),
    `des` varchar(255),
    `l2_check_port` varchar(10),
    `sort` int(11),
    `create_at` datetime,
    `update_at` datetime,
    primary KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `node` (
    `id` int(11) not null AUTO_INCREMENT,
    `pid` int(11) not null,
    `region_id` int(11),
    `name` varchar(255),
    `des` varchar(255),
    `ip` varchar(255),
    `create_at` datetime,
    `update_at` datetime,
    `enable` boolean,
    `disable_by` varchar(20),
    `config_task` text,
    `check_on` boolean,
    `check_protocol` varchar(10),
    `check_timeout` float,
    `check_port` int(11),
    `check_host` varchar(255),
    `check_path` varchar(255),
    `check_node_group` varchar(255),
    `check_action` varchar(10),
    `bw_limit` varchar(50),
    `traffic_limit` varchar(255),
    `disable_time` varchar(100),
    `inbound` bigint,
    `outbound` bigint,
    `month_traffic` float,
    `ip_location` text,
    `type` varchar(10),
    `sid` varchar(50),
    `uuid` varchar(40) DEFAULT NULL,
    `sort` int(11),
    KEY `idx_enable` (`enable`),
    KEY `idx_ip` (`ip`),
    KEY `pid_idx` (`pid`),
    KEY `idx_uuid` (`uuid`),
    CONSTRAINT `region_ibfk_1` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`),
    primary KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `pending_node` (
    `id` int(11) not null AUTO_INCREMENT,
    `ip` varchar(255),
    `sid` varchar(50),
    `type` varchar(10),
    `create_at` datetime,
    `uuid` varchar(40) DEFAULT NULL,
    KEY `idx_ip` (`ip`),
    KEY `idx_uuid` (`uuid`),
    primary KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `node_monitor_log` (
  `create_at` datetime DEFAULT NULL,
  `type` varchar(10),
  `event_id` varchar(10) DEFAULT NULL,
  `ip` varchar(50) DEFAULT NULL,
  `success` varchar(2) DEFAULT NULL,
  `node_id` int(11) DEFAULT NULL,
  `group_id` int(11) DEFAULT NULL,
  KEY `idx_create_at` (`create_at`),
  KEY `idx_event_id` (`event_id`),
  KEY `idx_ip` (`ip`),
  KEY `idx_type` (`type`),
  KEY `idx_success` (`success`),
  KEY `idx_group_id` (`group_id`),
  KEY `idx_monitor_optimized` (`ip`, `type`, `success`, `create_at`, `event_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `node_group` (
    `id` int(11) not null AUTO_INCREMENT,
    `region_id` int(11),
    `cname_hostname` varchar(255),
    `v4_cname_hostname` varchar(255),
    `need_gen_v4` boolean,
    `name` varchar(255),
    `des` varchar(255),
    `backup_switch_type` varchar(20),
    `backup_switch_policy` varchar(80),
    `l2_config_id` int(11),
    `create_at` datetime,
    `update_at` datetime,
    `sort` int(11),
    CONSTRAINT `region_ibfk_2` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`),
    primary KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `line` (
    `id` int(11) not null AUTO_INCREMENT,
    `node_group_id` int(11),
    `node_id` int(11),
    `node_ip_id` int(11),
    `line_id` varchar(255),
    `line_name` varchar(255),    
    `weight` varchar(4),
    `create_at` datetime,
    `update_at` datetime,
    `record_id` varchar(255),
    `task_id` bigint,
    `v4_task_id` bigint,
    `enable` boolean,
    `is_backup` boolean,
    `enable_backup` boolean,
    `is_backup_default_line` boolean,
    `enable_backup_default_line` boolean,
    `switch_at` datetime,
    `disable_by` varchar(20),
    `sort` int(11),
    primary KEY `id` (`id`),
    CONSTRAINT `node_group_ibfk_3` FOREIGN KEY (`node_group_id`) REFERENCES `node_group` (`id`),
    CONSTRAINT `node_ibfk_1` FOREIGN KEY (`node_id`) REFERENCES `node` (`id`),
    CONSTRAINT `node_ibfk_3` FOREIGN KEY (`node_ip_id`) REFERENCES `node` (`id`),
    CONSTRAINT `task_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `task` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `op_log` (
    `id` int(11) not null AUTO_INCREMENT,
    `uid` int(11),
    `type` varchar(255),
    `action` varchar(255),
    `content` text,
    `diff` longtext,
    `ip` varchar(255),
    `ip_location` varchar(150),
    `create_at` datetime,
    `process` varchar(255),
    primary KEY `id` (`id`),
    KEY `idx_type` (`type`),
    KEY `idx_action` (`action`),
    KEY `idx_ip` (`ip`),
    KEY `idx_create_at` (`create_at`),
    KEY `idx_process` (`process`),
    CONSTRAINT `user_ibfk_2` FOREIGN KEY (`uid`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `dnsapi` (
    `id` int(11) not null AUTO_INCREMENT,
    `uid` int(11),
    `name` varchar(255),
    `des` varchar(255),    
    `type` varchar(255),
    `auth` varchar(255),
    primary KEY `id` (`id`),
    KEY `idx_type` (`type`),
    CONSTRAINT `user_ibfk_3` FOREIGN KEY (`uid`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `cert` (
    `id` int(11) not null AUTO_INCREMENT,
    `uid` int(11),
    `name` varchar(255),
    `des` varchar(255),       
    `type` varchar(255),
    `domain` text,
    `dnsapi` int(11),
    `cert` text,
    `key` text,
    `start_time` datetime,
    `expire_time` datetime,
    `auto_renew` boolean,
    `create_at` datetime,
    `update_at` datetime,
    `enable` boolean,
    `task_id` bigint,
    `issue_task_id` bigint,
    `version` int(11),
    KEY `idx_type` (`type`),
    KEY `idx_expire_time` (`expire_time`),
    KEY `idx_enable` (`enable`),
    primary KEY `id` (`id`),
    CONSTRAINT `user_ibfk_4` FOREIGN KEY (`uid`) REFERENCES `user` (`id`),
    CONSTRAINT `dnsapi_ibfk_1` FOREIGN KEY (`dnsapi`) REFERENCES `dnsapi` (`id`),
    CONSTRAINT `task_ibfk_3` FOREIGN KEY (`task_id`) REFERENCES `task` (`id`),
    CONSTRAINT `task_ibfk_4` FOREIGN KEY (`issue_task_id`) REFERENCES `task` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


create table `acl` (
    `id` int(11) not null AUTO_INCREMENT,
    `uid` int(11),
    `name` varchar(255),
    `des` varchar(255),       
    `default_action` varchar(255),
    `reject_code` varchar(10),
    `redirect_url` varchar(255),
    `data` MEDIUMTEXT,
    `create_at` datetime,
    `update_at` datetime,
    `enable` boolean,
    `task_id` bigint,
    `version` int(11),
    primary KEY `id` (`id`),
    KEY `idx_enable` (`enable`),
    CONSTRAINT `user_ibfk_5` FOREIGN KEY (`uid`) REFERENCES `user` (`id`),
    CONSTRAINT `task_ibfk_5` FOREIGN KEY (`task_id`) REFERENCES `task` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `cc_rule` (
    `id` int(11) not null AUTO_INCREMENT,
    `sort` int(11),
    `uid` int(11),
    `name` varchar(255),
    `des` varchar(255),       
    `data` text,
    `show_to` varchar(255),
    `create_at` datetime,
    `update_at` datetime,
    `internal` boolean,
    `enable` boolean,
    `is_show` boolean,
    `task_id` bigint,
    `version` int(11),
    primary KEY `id` (`id`),
    KEY `idx_internal` (`internal`),
    KEY `idx_enable` (`enable`),
    CONSTRAINT `user_ibfk_6` FOREIGN KEY (`uid`) REFERENCES `user` (`id`),
    CONSTRAINT `task_ibfk_8` FOREIGN KEY (`task_id`) REFERENCES `task` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `cc_match` (
    `id` int(11) not null AUTO_INCREMENT,
    `uid` int(11),
    `name` varchar(255),
    `des` varchar(255),       
    `data` MEDIUMTEXT,
    `create_at` datetime,
    `update_at` datetime,
    `internal` boolean,
    `enable` boolean,
    `task_id` bigint,    
    `version` int(11),
    primary KEY `id` (`id`),
    KEY `idx_enable` (`enable`),
    KEY `idx_internal` (`internal`),
    CONSTRAINT `user_ibfk_7` FOREIGN KEY (`uid`) REFERENCES `user` (`id`),
    CONSTRAINT `task_ibfk_6` FOREIGN KEY (`task_id`) REFERENCES `task` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `cc_filter` (
    `id` int(11) not null AUTO_INCREMENT,
    `uid` int(11),
    `name` varchar(255),
    `des` varchar(255),  
    `type` varchar(255),  
    `within_second` int(11),  
    `max_req` int(11),  
    `max_req_per_uri` int(11),  
    `extra` varchar(255),  
    `create_at` datetime,
    `update_at` datetime,
    `internal` boolean,
    `enable` boolean,
    `task_id` bigint,       
    `version` int(11),
    primary KEY `id` (`id`),
    KEY `idx_enable` (`enable`),
    KEY `idx_internal` (`internal`),
    CONSTRAINT `user_ibfk_8` FOREIGN KEY (`uid`) REFERENCES `user` (`id`),
    CONSTRAINT `task_ibfk_7` FOREIGN KEY (`task_id`) REFERENCES `task` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


create table `package` (
    `id` int(11) not null AUTO_INCREMENT,
    `name` varchar(255),
    `des` varchar(255),  
    `region_id` int(11),
    `node_group_id` int(11),
    `backup_node_group` int(11),
    `cname_domain` int(11),
    `cname_hostname2` varchar(255),
    `cname_mode` varchar(10),
    `traffic` int(11),
    `bandwidth` varchar(20),
    `connection` int(11),    
    `domain` int(11),  
    `main_domain` int(11),
    `http_port` int(11),  
    `stream_port` int(11),  
    `custom_cc_rule` boolean,
    `websocket` boolean,
    `http3` boolean,
    `l2_state` boolean,
    `cc_protect`  varchar(255),
    `ddos_protect`  varchar(255),
    `expire` datetime,
    `buy_num_limit` int(11),
    `backend_ip_limit` text,
    `id_verify` boolean,
    `before_exp_days_renew` int(11),
    `month_price` bigint,
    `quarter_price` bigint,
    `year_price` bigint,
    `create_at` datetime,
    `update_at` datetime,
    `sort` int(11),
    `owner` varchar(255),
    `enable` boolean,
    primary KEY `id` (`id`),
    KEY `idx_enable` (`enable`),
    CONSTRAINT `region_ibfk_3` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`),
    CONSTRAINT `node_group_2` FOREIGN KEY (`node_group_id`) REFERENCES `node_group` (`id`),
    CONSTRAINT `node_group_ibfk_4` FOREIGN KEY (`backup_node_group`) REFERENCES `node_group` (`id`),
    CONSTRAINT `package_ibfk_4` FOREIGN KEY (`cname_domain`) REFERENCES `cname_domain` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `package_group` (
    `id` int(11) not null AUTO_INCREMENT,
    `name` varchar(255),
    `des` varchar(255),
    `sort` int(11),
    `enable` boolean,
    `create_at` datetime,
    `update_at` datetime,
    primary KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


create table `merge_package_group` (
    `package_id` int(11),
    `package_group_id` int(11),
    CONSTRAINT `package_ibfk_1` FOREIGN KEY (`package_id`) REFERENCES `package` (`id`),
    CONSTRAINT `package_group_ibfk_1` FOREIGN KEY (`package_group_id`) REFERENCES `package_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `package_up` (
    `id` int(11) not null AUTO_INCREMENT,
    `name` varchar(255),
    `des` varchar(255),  
    `type` varchar(255),  
    `amount` int(11),
    `bind_package` varchar(255),
    `price` bigint,
    `create_at` datetime,
    `update_at` datetime,    
    `enable` boolean,
    KEY `idx_type` (`type`),
    KEY `idx_enable` (`enable`),
    primary KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `user_package` (
    `id` int(11) not null AUTO_INCREMENT,
    `uid` int(11),
    `name` varchar(255), 
    `package` int(11),
    `region_id` int(11),
    `node_group_id` int(11),
    `backup_node_group` int(11),
    `enable_backup_group` boolean,
    `cname_domain` int(11),
    `cname_hostname` varchar(255),
    `cname_mode` varchar(10),
    `record_id` varchar(255),
    `traffic` int(11) DEFAULT NULL,
    `bandwidth` varchar(20),
    `connection` int(11),
    `domain` int(11) DEFAULT NULL,
    `main_domain` int(11),
    `http_port` int(11) DEFAULT NULL,
    `stream_port` int(11) DEFAULT NULL,
    `custom_cc_rule` tinyint(1) DEFAULT NULL,
    `websocket` tinyint(1),
    `http3` boolean,
    `enable_ipv6` boolean,
    `month_price` bigint(20) DEFAULT NULL,
    `quarter_price` bigint(20) DEFAULT NULL,
    `year_price` bigint(20) DEFAULT NULL,
    `orgin_month_price` bigint(20),
    `orgin_quarter_price` bigint(20),
    `orgin_year_price` bigint(20),
    `create_at` datetime,
    `start_at` datetime,
    `end_at` datetime,    
    `task_id` bigint,
    primary KEY `id` (`id`),
    CONSTRAINT `user_ibfk_14` FOREIGN KEY (`uid`) REFERENCES `user` (`id`),
    CONSTRAINT `package_ibfk_3` FOREIGN KEY (`package`) REFERENCES `package` (`id`),
    CONSTRAINT `region_ibfk_6` foreign key(`region_id`) REFERENCES `region`(`id`),
    CONSTRAINT `node_group_ibfk_1` foreign key(`node_group_id`) REFERENCES `node_group`(`id`),
    CONSTRAINT `node_group_ibfk_5` FOREIGN KEY (`backup_node_group`) REFERENCES `node_group` (`id`),
    CONSTRAINT `task_ibfk_21` foreign key(`task_id`) REFERENCES `task`(`id`),
    CONSTRAINT `user_package_ibfk_4` FOREIGN KEY (`cname_domain`) REFERENCES `cname_domain` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `user_package_up` (
    `id` int(11) not null AUTO_INCREMENT,
    `uid` int(11),
    `package_up` int(11),
    `user_package` int(11),
    `amount` int(11),
    primary KEY `id` (`id`),
    CONSTRAINT `user_ibfk_15` FOREIGN KEY (`uid`) REFERENCES `user` (`id`),
    CONSTRAINT `package_up_ibfk_1` FOREIGN KEY (`package_up`) REFERENCES `package_up` (`id`),
    CONSTRAINT `user_package_ibfk_1` FOREIGN KEY (`user_package`) REFERENCES `user_package` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `config` (
    `name` varchar(50),
    `value` MEDIUMTEXT,  
    `type` varchar(30),  
    `scope_id` int(11),
    `scope_name` varchar(10),
    `create_at` datetime,
    `update_at` datetime,    
    `enable` boolean,
    `task_id` bigint,
    UNIQUE KEY `name` (`name`,`type`,`scope_id`,`scope_name`),
    KEY `idx_type` (`type`),
    KEY `idx_name` (`name`),
    KEY `idx_enable` (`enable`),
    CONSTRAINT `task_ibfk_14` FOREIGN KEY (`task_id`) REFERENCES `task` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `site` (
    `id` int(11) not null AUTO_INCREMENT,
    `uid` int(11),
    `user_package` int(11),
    `region_id` int(11),
    `node_group_id` int(11),
    `backup_node_group` int(11),
    `enable_backup_group` boolean,
    `cname_domain` int(11),
    `cname_mode` varchar(10),
    `cname_hostname` varchar(255),
    `domain` longtext,  
    `http_listen` text,  
    `https_listen` text,  
    `balance_way` varchar(255),  
    `backend` text,  
    `backend_protocol` varchar(8),
    `backend_https_port` varchar(5),
    `backend_http_port` varchar(5),
    `proxy_timeout` varchar(10),
    `proxy_connect_timeout` varchar(3),
    `backend_port_mapping` boolean,
    `condition_backend` text,
    `health_check` varchar(255),
    `ups_keepalive` boolean,
    `ups_keepalive_conn` int(3),
    `ups_keepalive_timeout` int(4),
    `proxy_http_version` varchar(3),
    `proxy_ssl_protocols` varchar(255),
    `backend_host` varchar(255),
    `range` boolean,
    `proxy_cache` text,  
    `cc_default_rule` int(11),
    `cc_switch` text,
    `extra_cc_rule` longtext,
    `block_proxy` boolean,
    `block_region` text,
    `black_ip` text,  
    `white_ip` text,  
    `spider_allow` varchar(255),
    `acl` int(11),
    `hotlink` text,
    `cors` text,
    `resp_header` text,  
    `req_header` text,  
    `page_403` text,
    `page_404` text,  
    `page_500` text,
    `page_502` text,
    `page_504` text,
    `url_rewrite` text,  
    `gzip_enable` boolean,
    `gzip_types` text,
    `websocket_enable` boolean,
    `acme_proxy_to_orgin` boolean,
    `post_size_limit` varchar(30),
    `recv_real_time` boolean,
    `send_real_time` boolean,
    `spider_to_sip` varchar(40),
    `is_default_server` boolean,
    `src_hostname` varchar(14),
    `dns_api` int(11),
    `cookie_domain` varchar(255),
    `block_time` varchar(10),
    `white_time` varchar(10),
    `log_req_header` boolean,
    `log_resp_header` boolean,
    `log_req_body` boolean,
    `log_req_body_max_size` int(11),
    `enable_ipv6` boolean,
    `l2_state` varchar(10),
    `l2_config_id` int(11),
    `create_at` datetime,
    `update_at` datetime,   
    `version` int(11),
    `enable` boolean,
    `task_id` bigint,
    `cname_task_id` bigint,
    `spider_task_id` bigint,
    `record_id` varchar(255),
    `state` varchar(255),
    primary KEY `id` (`id`),
    KEY `idx_enable` (`enable`),
    CONSTRAINT `user_ibfk_9` FOREIGN KEY (`uid`) REFERENCES `user` (`id`),
    CONSTRAINT `user_package_ibfk_3` FOREIGN KEY (`user_package`) REFERENCES `user_package` (`id`),
    CONSTRAINT `acl_ibfk_2` FOREIGN KEY (`acl`) REFERENCES `acl` (`id`),
    CONSTRAINT `task_ibfk_9` FOREIGN KEY (`task_id`) REFERENCES `task` (`id`),
    CONSTRAINT `region_ibfk_4` foreign key(`region_id`) REFERENCES `region`(`id`),
    CONSTRAINT `task_ibfk_19` foreign key(`cname_task_id`) REFERENCES `task`(`id`),
    CONSTRAINT `node_group_ibfk_6` FOREIGN KEY (`backup_node_group`) REFERENCES `node_group` (`id`),
    CONSTRAINT `node_group_ibfk_8` FOREIGN KEY (`node_group_id`) REFERENCES `node_group` (`id`),
    CONSTRAINT `site_ibfk_2` FOREIGN KEY (`cname_domain`) REFERENCES `cname_domain` (`id`),
    CONSTRAINT `task_ibfk_22` FOREIGN KEY (`spider_task_id`) REFERENCES `task`(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `stream` (
    `id` int(11) not null AUTO_INCREMENT,
    `uid` int(11),
    `user_package` int(11),
    `region_id` int(11),
    `node_group_id` int(11),
    `backup_node_group` int(11),
    `enable_backup_group` boolean,
    `cname_domain` int(11),
    `cname_mode` varchar(10),    
    `cname_hostname` varchar(255),
    `listen` text,  
    `balance_way` varchar(255),  
    `proxy_protocol` boolean,
    `backend_port` varchar(255),  
    `backend` text,  
    `conn_limit` varchar(255),
    `acl` text,  
    `block_region` text,
    `enable_ipv6` boolean,
    `des` varchar(255),
    `create_at` datetime,
    `update_at` datetime,   
    `version` int(11),
    `enable` boolean,
    `task_id` bigint,
    `cname_task_id` bigint,
    `record_id` varchar(255),
    `state` varchar(255),
    primary KEY `id` (`id`),
    KEY `idx_enable` (`enable`),
    CONSTRAINT `user_ibfk_12` FOREIGN KEY (`uid`) REFERENCES `user` (`id`),
    CONSTRAINT `user_package_ibfk_2` FOREIGN KEY (`user_package`) REFERENCES `user_package` (`id`),
    CONSTRAINT `task_ibfk_11` FOREIGN KEY (`task_id`) REFERENCES `task` (`id`),
    CONSTRAINT `region_ibfk_5` foreign key(`region_id`) REFERENCES `region`(`id`),
    CONSTRAINT `task_ibfk_20` foreign key(`cname_task_id`) REFERENCES `task`(`id`),
    CONSTRAINT `node_group_ibfk_7` FOREIGN KEY (`backup_node_group`) REFERENCES `node_group` (`id`),
    CONSTRAINT `node_group_ibfk_9` FOREIGN KEY (`node_group_id`) REFERENCES `node_group` (`id`),
    CONSTRAINT `stream_ibfk_2` FOREIGN KEY (`cname_domain`) REFERENCES `cname_domain` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `site_group` (
    `id` int(11) not null AUTO_INCREMENT,
    `uid` int(11),
    `name` varchar(255),
    `des` varchar(255),
    primary KEY `id` (`id`),
    CONSTRAINT `user_ibfk_11` FOREIGN KEY (`uid`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `merge_site_group` (
    `site_id` int(11) ,
    `group_id` int(11),
    CONSTRAINT `site_ibfk_1` FOREIGN KEY (`site_id`) REFERENCES `site` (`id`),
    CONSTRAINT `site_group_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `site_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


create table `stream_group` (
    `id` int(11) not null AUTO_INCREMENT,
    `uid` int(11),
    `name` varchar(255),
    `des` varchar(255),
    primary KEY `id` (`id`),
    CONSTRAINT `user_ibfk_13` FOREIGN KEY (`uid`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `merge_stream_group` (
    `stream_id` int(11) ,
    `group_id` int(11),
    CONSTRAINT `stream_ibfk_1` FOREIGN KEY (`stream_id`) REFERENCES `stream` (`id`),
    CONSTRAINT `stream_group_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `stream_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `order` (
    `id` int(11) not null AUTO_INCREMENT,
    `uid` int(11),
    `type` varchar(255),
    `des` varchar(255),
    `data` text,
    `create_at` datetime,
    `pay_at` datetime,
    `amount` bigint,
    `real_amount` bigint(20),
    `pay_type` varchar(20),
    `mch_order_no` varchar(40),
    `transaction_id` varchar(255),
    `state` varchar(255),
    primary KEY `id` (`id`),
    KEY `idx_type` (`type`),
    KEY `idx_state` (`state`),
    KEY `idx_mch_order_no` (`mch_order_no`),
    CONSTRAINT `user_ibfk_16` FOREIGN KEY (`uid`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `job` (
    `id` int(11) not null AUTO_INCREMENT,
    `uid` int(11),
    `type` varchar(255),
    `key1`varchar(255),
    `key2`varchar(255),
    `data` text,
    `create_at` datetime,
    `task_id` bigint,
    primary KEY `id` (`id`),
    KEY type_idx (type),
    KEY key1_idx (key1),
    KEY key2_idx (key2),
    CONSTRAINT `user_ibfk_17` FOREIGN KEY (`uid`) REFERENCES `user` (`id`),
    CONSTRAINT `task_ibfk_18` FOREIGN KEY (`task_id`) REFERENCES `task` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `tlock` (
    `name` varchar(30),
    primary KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table `res_count` (
    `id` bigint not null AUTO_INCREMENT,
    `time` datetime,
    `user_package` int(11),
    `uid` int(11),
    `cate` varchar(10),
    `type` varchar(15),
    `res` varchar(255),
    `value` bigint,
    KEY `idx_time` (`time`),
    KEY `idx_user_package` (`user_package`),
    KEY `idx_uid` (`uid`),
    KEY `idx_cate` (`cate`),
    KEY `idx_type` (`type`),
    KEY `idx_res` (`res`),
    key `idx_combined` (`time`, `uid`, `user_package`, `cate`, `type`, res(50)),
    primary KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

create table `res_count_package` (
    `id` bigint not null AUTO_INCREMENT,
    `time` datetime,
    `user_package` int(11),
    `uid` int(11),
    `cate` varchar(10),
    `type` varchar(15),
    `value` bigint,
    KEY `idx_time` (`time`),
    KEY `idx_user_package` (`user_package`),
    KEY `idx_uid` (`uid`),
    KEY `idx_cate` (`cate`),
    KEY `idx_type` (`type`),
    primary KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `captcha` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(50) DEFAULT NULL,
  `phone` varchar(15) DEFAULT NULL,
  `captcha` varchar(10) DEFAULT NULL,
  `img_code` varchar(10) DEFAULT NULL,
  `ip` varchar(50) DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_email` (`email`),
  KEY `idx_phone` (`phone`),
  KEY `idx_ip` (`ip`),
  KEY `idx_create_at` (`create_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


create table `api_key` (
    `id` int(11) not null AUTO_INCREMENT,
    `uid` int(11),
    `api_key` varchar(16),
    `api_secret` varchar(30),
    `api_ip` text,
    KEY `idx_api_key` (`api_key`),
    CONSTRAINT `user_ibfk_18` FOREIGN KEY (`uid`) REFERENCES `user` (`id`),
    primary KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


create table `message` (
    `id` bigint not null AUTO_INCREMENT,
    `type` varchar(20),
    `pub_user` int(11),
    `receive` int(11),
    `title` varchar(255),
    `content` text,
    `phone_content` text,
    `templ_id` varchar(30),
    `templ_para` varchar(255),
    `event_id` varchar(32),
    `user_package_id` int(11),
    `site_id` int(11),
    `is_show` boolean,
    `is_red` boolean,
    `is_bold` boolean,
    `is_external` boolean,
    `is_popup` boolean,
    `email_need_send` boolean,
    `phone_need_send` boolean,
    `email_is_sent` boolean,
    `phone_is_sent` boolean,
    `url` varchar(255),
    `sort` int(11),
    `create_at` datetime,
    `update_at` datetime,
    primary KEY `id` (`id`),
    KEY `type_idx` (`type`),
    KEY `receive_idx` (`receive`),
    KEY `is_show_idx` (`is_show`),
    KEY `create_at_idx` (`create_at`),
    KEY `user_package_id_idx` (`user_package_id`),
    KEY `site_id_idx` (`site_id`),
    index event_id_idx(event_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table message_read (
    `uid` int(11),
    `msg_id` bigint,
    `create_at` datetime,
    CONSTRAINT `message_ibfk_1` FOREIGN KEY (`msg_id`) REFERENCES `message` (`id`),
    CONSTRAINT `user_ibfk_10` FOREIGN KEY (`uid`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table message_sub (
    `uid` int(11),
    `msg_type` varchar(50),
    `phone` boolean,
    `email` boolean,
    CONSTRAINT `user_ibfk_19` FOREIGN KEY (`uid`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

create table message_send (
    `id` bigint not null AUTO_INCREMENT,
    `uid` int(11),
    `msg_id` int(11),
    `media` varchar(10),
    `failed_times` int(11),
    `state` varchar(10),
    `ret` text,
    `create_at` datetime,
    primary KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `ip_switch_log` (
  `id` bigint not null auto_increment,
  `create_at` datetime DEFAULT NULL,
  `type` varchar(30) DEFAULT NULL,
  `node_group_id` int(11),
  `node_id` int(11),
  `line_id` int(11),
  `ip` varchar(50) DEFAULT NULL,
  `action` varchar(20) DEFAULT NULL,
  `email_need_send` boolean,
  `email_is_sent` boolean,
  `email_fail_times` int(11),
  `email_ret` varchar(255),
  `email_time` datetime,
  `email_send_state` varchar(10),
  `phone_need_send` boolean,
  `phone_is_sent` boolean,
  `phone_fail_times` int(11),
  `phone_ret` varchar(255),
  `phone_time` datetime,
  `phone_send_state` varchar(10),
  `content` text,
  `templ_id` varchar(30),
  `templ_para` varchar(255),
  primary KEY `id` (`id`),
  KEY `idx_type` (`type`),
  KEY `idx_node_id` (`node_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


create table lets_account (
	`id` int(11) NOT NULL AUTO_INCREMENT,
	`enable` boolean,
	`invalid_date` datetime,
    `is_created` boolean,
    `create_failed_at` datetime,
	 PRIMARY KEY (`id`)

) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `user_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11),
  `name` varchar(50) DEFAULT NULL,
  `value` text,
  `type` varchar(30) DEFAULT NULL,
  `scope_id` int(11) DEFAULT NULL,
  `scope_name` varchar(10) DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  `update_at` datetime DEFAULT NULL,
  `enable` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_type` (`type`),
  KEY `idx_scope_id` (`scope_id`),
  KEY `idx_scope_name` (`scope_name`),
  KEY `idx_enable` (`enable`),
  CONSTRAINT `user_ibfk_20` FOREIGN KEY (`uid`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


create table acme_ip_log (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `ip` varchar(40),
    `create_at` int(11),
    primary KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

# resouce config

insert into  lets_account values (1,1,null,0,null);
insert into  lets_account values (2,1,null,0,null);
insert into  lets_account values (3,1,null,0,null);
insert into  lets_account values (4,1,null,0,null);
insert into  lets_account values (5,1,null,0,null);
insert into  lets_account values (6,1,null,0,null);
insert into  lets_account values (7,1,null,0,null);
insert into  lets_account values (8,1,null,0,null);
insert into  lets_account values (9,1,null,0,null);
insert into  lets_account values (10,1,null,0,null);
insert into  lets_account values (11,1,null,0,null);
insert into  lets_account values (12,1,null,0,null);
insert into  lets_account values (13,1,null,0,null);
insert into  lets_account values (14,1,null,0,null);
insert into  lets_account values (15,1,null,0,null);
insert into  lets_account values (16,1,null,0,null);
insert into  lets_account values (17,1,null,0,null);
insert into  lets_account values (18,1,null,0,null);
insert into  lets_account values (19,1,null,0,null);
insert into  lets_account values (20,1,null,0,null);
insert into  lets_account values (21,1,null,0,null);
insert into  lets_account values (22,1,null,0,null);
insert into  lets_account values (23,1,null,0,null);
insert into  lets_account values (24,1,null,0,null);
insert into  lets_account values (25,1,null,0,null);
insert into  lets_account values (26,1,null,0,null);
insert into  lets_account values (27,1,null,0,null);
insert into  lets_account values (28,1,null,0,null);
insert into  lets_account values (29,1,null,0,null);
insert into  lets_account values (30,1,null,0,null);
insert into  lets_account values (31,1,null,0,null);
insert into  lets_account values (32,1,null,0,null);
insert into  lets_account values (33,1,null,0,null);
insert into  lets_account values (34,1,null,0,null);
insert into  lets_account values (35,1,null,0,null);
insert into  lets_account values (36,1,null,0,null);
insert into  lets_account values (37,1,null,0,null);
insert into  lets_account values (38,1,null,0,null);
insert into  lets_account values (39,1,null,0,null);
insert into  lets_account values (40,1,null,0,null);
insert into  lets_account values (41,1,null,0,null);
insert into  lets_account values (42,1,null,0,null);
insert into  lets_account values (43,1,null,0,null);
insert into  lets_account values (44,1,null,0,null);
insert into  lets_account values (45,1,null,0,null);
insert into  lets_account values (46,1,null,0,null);
insert into  lets_account values (47,1,null,0,null);
insert into  lets_account values (48,1,null,0,null);
insert into  lets_account values (49,1,null,0,null);
insert into  lets_account values (50,1,null,0,null);


# site
insert into config values ('related-config-min-limit',1000,'site','0','global', now(),now(),1,null);
insert into config values ('related-config-max-times-limit',200,'site','0','global', now(),now(),1,null); 
insert into config values ('black-ip-limit',50,'site','0','global', now(),now(),1,null);  
insert into config values ('white-ip-limit',50,'site','0','global', now(),now(),1,null);
insert into config values ('max-domain-persite-limit',100,'site','0','global', now(),now(),1,null);
insert into config values ('listen-default-http-80',1,'site','0','global', now(),now(),1,null);
insert into config values ('clean_url',2000,'site','0','global', now(),now(),1,null);
insert into config values ('clean_dir',500,'site','0','global', now(),now(),1,null);
insert into config values ('pre_cache_url',2000,'site','0','global', now(),now(),1,null);
insert into config values ('pre_cache_timeout',120,'site','0','global', now(),now(),1,null);
insert into config values ('ip-unlock-max-limit',1000,'site','0','global', now(),now(),1,null);
insert into config values ('ip-unlock-max-per-limit',50,'site','0','global', now(),now(),1,null);
insert into config values ('cc-rule-max-limit',5,'site','0','global', now(),now(),1,null); 
insert into config values ('acl-max-limit',5,'site','0','global', now(),now(),1,null); 
insert into config values ('download-access-log-limit',10,'site','0','global', now(),now(),1,null);
insert into config values ('download-access-log-tmp-dir','/data/download-temp/','site','0','global', now(),now(),1,null);
insert into config values ('download-access-log-retain','12','site','0','global', now(),now(),1,null);

# stream
insert into config values ('custom-port-not-allow','80 443','stream','0','global', now(),now(),1,null);
insert into config values ('related-config-min-limit',1000,'stream','0','global', now(),now(),1,null);
insert into config values ('related-config-max-times-limit',200,'stream','0','global', now(),now(),1,null); 
insert into config values ('acl-max-limit',10,'stream','0','global', now(),now(),1,null); 

# 公共    
insert into config values ('custom-port-not-allow','22','site_stream','0','global', now(),now(),1,null);     
insert into config values ('custom-port-allow','1-65535','site_stream','0','global', now(),now(),1,null);


# nginx config
insert into config values ('nginx-config-file','{"logs_dir":"/usr/local/openresty/nginx/logs/", "worker_rlimit_nofile":51200,"worker_shutdown_timeout":"60s","worker_connections":51200,"worker_processes":"auto","http":{"client_body_buffer_size":"16", "proxy_request_buffering":"off", "server_addr_outgoing":"0", "large_client_header_buffers":"4 32k", "proxy_cache_dir":"/data/nginx/cache/", "proxy_cache_max_size":"1000g", "gzip_comp_level":1,"gzip_http_version":"1.0","gzip_min_length":"1k","gzip_vary":"on","proxy_buffering":"on","proxy_cache_methods":"GET HEAD","proxy_http_version":"1.0","proxy_max_temp_file_size":"1024m","proxy_next_upstream":"error timeout","proxy_connect_timeout":"60s","proxy_send_timeout":"60s","proxy_read_timeout":"60s","server":"nginx","client_max_body_size":"2g","default_type":"text/plain","keepalive_requests":100,"keepalive_timeout":"60s","log_not_found":"off","server_names_hash_max_size":512,"server_names_hash_bucket_size":128, "server_tokens":"off"},"stream":{"proxy_connect_timeout":"60s","proxy_timeout":"10m"}}','nginx_config','0','global', now(),now(),1,null);

# openresty config
set @rotate_html = '<!DOCTYPE html>\\n<html>\\n<head>\\n    <meta charset=\\"UTF-8\\">\\n    <meta name=\\"viewport\\" content=\\"width=device-width, initial-scale=1.0\\">\\n    <title>Security Verification</title>\\n    <style>\\n        body {\\n            background: #f5f6fa;\\n            display: flex;\\n            justify-content: center;\\n            align-items: center;\\n            min-height: 100vh;\\n            margin: 0;\\n            font-family: -apple-system, BlinkMacSystemFont, \\"Segoe UI\\", Roboto, Oxygen, Ubuntu, Cantarell, \\"Open Sans\\", \\"Helvetica Neue\\", sans-serif;\\n        }\\n\\n        .verification-modal {\\n            background: white;\\n            border-radius: 12px;\\n            padding: 20px;\\n            box-shadow: 0 10px 30px rgba(0,0,0,0.1);\\n        }\\n\\n        .modal-header {\\n            display: flex;\\n            justify-content: space-between;\\n            align-items: center;\\n            margin-bottom: 15px;\\n        }\\n\\n        .modal-title {\\n            font-size: 16px;\\n            color: #333;\\n            font-weight: 600;\\n        }\\n        \\n        .puzzle-container {\\n            width: 350px;\\n            position: relative;\\n            overflow: hidden;\\n            border-radius: 8px;\\n            margin-bottom: 15px;\\n        }\\n\\n        .puzzle-image {\\n            margin: 0 auto;\\n            width: 340px;\\n            height: 250px;\\n            background-size: 680px 250px;\\n            background-position: left;\\n            position: relative;\\n            will-change: transform;\\n            transform: rotate(0deg);\\n            border-radius: 2%;\\n        }\\n\\n        .puzzle-overlay {\\n            position: absolute;\\n            top: 0;\\n            left: 5px;\\n            width: 340px;\\n            height: 250px;\\n            background-size: 680px 250px;\\n            background-position: right;\\n            transform: rotate(0deg);\\n            border-radius: 2%;\\n            mix-blend-mode: multiply;\\n        }\\n\\n        .slider {\\n            width: 100%;\\n            height: 40px;\\n            background: #f0f2f5;\\n            position: relative;\\n            border-radius: 20px;\\n            box-shadow: inset 0 1px 3px rgba(0,0,0,0.1);\\n        }\\n\\n        .slider-handle {\\n            width: 50px;\\n            height: 40px;\\n            background: linear-gradient(135deg, #4285f4, #3367d6);\\n            position: absolute;\\n            left: 0px;\\n            top: -1px;\\n            cursor: pointer;\\n            border-radius: 20px;\\n            display: flex;\\n            align-items: center;\\n            justify-content: center;\\n            color: white;\\n            font-size: 18px;\\n            box-shadow: 0 2px 10px rgba(66,133,244,0.3);\\n            will-change: transform, left;\\n        }\\n\\n        .slider-handle:hover {\\n            background: linear-gradient(135deg, #5295f4, #4377e6);\\n            box-shadow: 0 4px 15px rgba(66,133,244,0.4);\\n        }\\n\\n        .slider-text {\\n            width: 100%;\\n            height: 100%;\\n            display: flex;\\n            align-items: center;\\n            justify-content: center;\\n            color: #666;\\n            font-size: 14px;\\n            user-select: none;\\n        }\\n\\n        .success .slider-handle {\\n            background: linear-gradient(135deg, #4CAF50, #45a049);\\n            box-shadow: 0 2px 10px rgba(76,175,80,0.3);\\n        }\\n\\n        @keyframes success-pulse {\\n            0% { transform: scale(1); }\\n            50% { transform: scale(1.05); }\\n            100% { transform: scale(1); }\\n        }\\n\\n        .success .slider-handle {\\n            animation: success-pulse 0.5s ease;\\n        }\\n\\n        @keyframes glow {\\n            from {\\n                box-shadow: 0 0 5px rgba(255, 255, 255, 0.3);\\n            }\\n            to {\\n                box-shadow: 0 0 10px rgba(255, 255, 255, 0.5);\\n            }\\n        }\\n    </style>\\n</head>\\n<body>\\n    <div class=\\"verification-modal\\">\\n        <div class=\\"modal-header\\">\\n            <span class=\\"modal-title\\" data-i18n=\\"securityVerification\\">Security Verification</span>\\n        </div>\\n        <div class=\\"puzzle-container\\">\\n            <div class=\\"puzzle-image\\"></div>\\n            <div class=\\"puzzle-overlay\\"></div>\\n        </div>\\n        <div class=\\"slider\\">\\n            <div class=\\"slider-text\\" data-i18n=\\"slideToComplete\\">Slide to rotate the image to normal</div>\\n            <div class=\\"slider-handle\\">\\n                <svg width=\\"16\\" height=\\"16\\" viewBox=\\"0 0 24 24\\" fill=\\"none\\" stroke=\\"currentColor\\" stroke-width=\\"2\\">\\n                    <path d=\\"M9 18l6-6-6-6\\"/>\\n                </svg>\\n            </div>\\n        </div>\\n    </div>\\n    <script>\\n        document.addEventListener(\\"DOMContentLoaded\\", function() {\\n            const translations = {\\n                \\"en\\": {\\n                    securityVerification: \\"Security Verification\\",\\n                    slideToComplete: \\"Slide to rotate the image to normal\\"\\n                },\\n                \\"zh\\": {\\n                    securityVerification: \\"安全验证\\",\\n                    slideToComplete: \\"滑动旋转图片回正\\"\\n                }\\n            };\\n\\n            function setLanguage() {\\n                const userLang = navigator.language || navigator.userLanguage;\\n                const lang = userLang.startsWith(\\"zh\\") ? \\"zh\\" : \\"en\\";\\n                \\n                document.querySelectorAll(\\"[data-i18n]\\").forEach(element => {\\n                    const key = element.getAttribute(\\"data-i18n\\");\\n                    element.textContent = translations[lang][key];\\n                });\\n                \\n                document.documentElement.lang = lang;\\n                document.title = translations[lang].securityVerification;\\n            }\\n\\n            setLanguage();\\n        });\\n    </script>\\n    <script type=\\"text/javascript\\" src=\\"/_guard/rotate.js\\"></script>\\n</body>\\n</html>';
set @delay_jump_html = '<!DOCTYPE html>\\n<html>\\n<head>\\n    <meta charset=\\"UTF-8\\">\\n    <meta name=\\"viewport\\" content=\\"width=device-width, initial-scale=1.0\\">\\n    <title>Security Check</title>\\n    <style>\\n        * {\\n            box-sizing: border-box;\\n            margin: 0;\\n            padding: 0;\\n        }\\n\\n        body {\\n            font-family: -apple-system, BlinkMacSystemFont, \\"Segoe UI\\", Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;\\n            display: flex;\\n            justify-content: center;\\n            align-items: center;\\n            min-height: 100vh;\\n            background: #f5f6fa;\\n            margin: 0;\\n        }\\n\\n        .container {\\n            background: white;\\n            padding: 40px;\\n            border-radius: 20px;\\n            box-shadow: 0 10px 20px rgba(0,0,0,0.1);\\n            text-align: center;\\n            width: 90%;\\n            max-width: 400px;\\n            display: flex;\\n            flex-direction: column;\\n            align-items: center;\\n        }\\n\\n        h2 {\\n            color: #333;\\n            margin-bottom: 40px;\\n            font-size: 1.8em;\\n            font-weight: 500;\\n        }\\n\\n        .progress-container {\\n            position: relative;\\n            width: 200px;\\n            height: 200px;\\n            display: flex;\\n            justify-content: center;\\n            align-items: center;\\n            margin: 20px 0;\\n        }\\n\\n        .progress-circle {\\n            position: absolute;\\n            width: 100%;\\n            height: 100%;\\n        }\\n\\n        .progress-circle circle {\\n            fill: none;\\n            stroke-width: 8;\\n            stroke-linecap: round;\\n            transform: rotate(-90deg);\\n            transform-origin: center;\\n        }\\n\\n        .progress-circle circle.bg {\\n            stroke: #f0f0f0;\\n        }\\n\\n        .progress-circle circle.progress {\\n            stroke: #4285f4;\\n            transition: stroke-dashoffset 0.1s linear;\\n        }\\n\\n        .countdown {\\n            font-size: 4em;\\n            font-weight: 500;\\n            color: #333;\\n            position: absolute;\\n        }\\n\\n        .status {\\n            margin-top: 30px;\\n            color: #666;\\n            font-size: 1em;\\n            display: flex;\\n            align-items: center;\\n            justify-content: center;\\n            gap: 8px;\\n        }\\n\\n        @keyframes spin {\\n            100% { transform: rotate(360deg); }\\n        }\\n\\n        .loading-icon {\\n            width: 16px;\\n            height: 16px;\\n            border: 2px solid #f3f3f3;\\n            border-top: 2px solid #4285f4;\\n            border-radius: 50%;\\n            display: inline-block;\\n            animation: spin 1s linear infinite;\\n        }\\n    </style>\\n</head>\\n<body>\\n    <div class=\\"container\\">\\n        <h2>Security Check</h2>\\n        <p id=\\"err\\"></p>\\n        <div class=\\"progress-container\\">\\n            <svg class=\\"progress-circle\\" viewBox=\\"0 0 200 200\\">\\n                <circle class=\\"bg\\" cx=\\"100\\" cy=\\"100\\" r=\\"90\\" stroke-dasharray=\\"565.487\\" stroke-dashoffset=\\"0\\"></circle>\\n                <circle class=\\"progress\\" cx=\\"100\\" cy=\\"100\\" r=\\"90\\" stroke-dasharray=\\"565.487\\" stroke-dashoffset=\\"565.487\\"></circle>\\n            </svg>\\n            <div class=\\"countdown\\">5</div>\\n        </div>\\n        <div class=\\"status\\">\\n            <span class=\\"loading-icon\\"></span>\\n            <span class=\\"status-text\\">Checking browser environment...</span>\\n        </div>\\n    </div>\\n\\n    <!-- 用户可以自定义的翻译内容 -->\\n    <script>\\n        const translations = {\\n            en: {\\n                title: \\"Security Check\\",\\n                messages: [\\n                    \\"Checking browser environment...\\",\\n                    \\"Verifying request legitimacy...\\",\\n                    \\"Loading security components...\\",\\n                    \\"Almost done...\\",\\n                    \\"Verification complete, redirecting...\\"\\n                ]\\n            },\\n            zh: {\\n                title: \\"安全检查中\\",\\n                messages: [\\n                    \\"正在检查浏览器环境...\\",\\n                    \\"正在验证请求合法性...\\",\\n                    \\"正在加载安全组件...\\",\\n                    \\"即将完成验证...\\",\\n                    \\"验证通过，正在跳转...\\"\\n                ]\\n            }\\n        };\\n\\n        // 获取浏览器语言并确定使用的语言\\n        function getLanguage() {\\n            const browserLang = navigator.language || navigator.userLanguage;\\n            return browserLang.toLowerCase().startsWith(\\"zh\\") ? \\"zh\\" : \\"en\\";\\n        }\\n\\n        const currentLang = getLanguage();\\n        window.text = translations[currentLang];\\n\\n    </script>\\n    <script type=\\"text/javascript\\" src=\\"/_guard/delay_jump.js\\"></script>\\n</body>\\n</html>';
set @slider_html = '<!DOCTYPE html>\\n<html>\\n<head>\\n    <meta charset=\\"UTF-8\\">\\n    <meta name=\\"viewport\\" content=\\"width=device-width, initial-scale=1.0\\">\\n    <title>Security Verification</title>\\n    <style>\\n        body {\\n            background: #f5f6fa;\\n            display: flex;\\n            justify-content: center;\\n            align-items: center;\\n            min-height: 100vh;\\n            margin: 0;\\n            font-family: -apple-system, BlinkMacSystemFont, \\"Segoe UI\\", Roboto, Oxygen, Ubuntu, Cantarell, \\"Open Sans\\", \\"Helvetica Neue\\", sans-serif;\\n        }\\n\\n        .verification-modal {\\n            background: white;\\n            border-radius: 12px;\\n            padding: 20px;\\n            box-shadow: 0 10px 30px rgba(0,0,0,0.1);\\n        }\\n\\n        .modal-header {\\n            display: flex;\\n            justify-content: space-between;\\n            align-items: center;\\n            margin-bottom: 15px;\\n        }\\n\\n        .modal-title {\\n            font-size: 16px;\\n            color: #333;\\n            font-weight: 600;\\n        }\\n        \\n        .puzzle-container {\\n            width: 100%;\\n            position: relative;\\n            background: #f8f9fa;\\n            overflow: hidden;\\n            border-radius: 8px;\\n            margin-bottom: 15px;\\n        }\\n\\n        .puzzle-image {\\n            width: 340px;\\n            height: 200px;\\n            background-size: auto;\\n            background-position: left;\\n            position: relative;\\n        }\\n\\n        .puzzle-piece {\\n            width: 80px;\\n            height: 80px;\\n            position: absolute;\\n            left: 20px;\\n            top: 100px;\\n            background-size: auto;\\n            background-position: -350px;\\n        }\\n\\n        .slider {\\n            width: 100%;\\n            height: 40px;\\n            background: #f0f2f5;\\n            position: relative;\\n            border-radius: 20px;\\n            box-shadow: inset 0 1px 3px rgba(0,0,0,0.1);\\n        }\\n\\n        .slider-handle {\\n            width: 50px;\\n            height: 40px;\\n            background: linear-gradient(135deg, #4285f4, #3367d6);\\n            position: absolute;\\n            left: 0px;\\n            top: -1px;\\n            cursor: pointer;\\n            border-radius: 20px;\\n            display: flex;\\n            align-items: center;\\n            justify-content: center;\\n            color: white;\\n            font-size: 18px;\\n            box-shadow: 0 2px 10px rgba(66,133,244,0.3);\\n            transition: all 0.3s ease;\\n        }\\n\\n        .slider-handle:hover {\\n            background: linear-gradient(135deg, #5295f4, #4377e6);\\n            box-shadow: 0 4px 15px rgba(66,133,244,0.4);\\n        }\\n\\n        .slider-text {\\n            width: 100%;\\n            height: 100%;\\n            display: flex;\\n            align-items: center;\\n            justify-content: center;\\n            color: #666;\\n            font-size: 14px;\\n            user-select: none;\\n        }\\n\\n        .success .slider-handle {\\n            background: linear-gradient(135deg, #4CAF50, #45a049);\\n            box-shadow: 0 2px 10px rgba(76,175,80,0.3);\\n        }\\n\\n        @keyframes success-pulse {\\n            0% { transform: scale(1); }\\n            50% { transform: scale(1.05); }\\n            100% { transform: scale(1); }\\n        }\\n\\n        .success .slider-handle {\\n            animation: success-pulse 0.5s ease;\\n        }\\n\\n        @keyframes glow {\\n            from {\\n                box-shadow: 0 0 5px rgba(255, 255, 255, 0.3);\\n            }\\n            to {\\n                box-shadow: 0 0 10px rgba(255, 255, 255, 0.5);\\n            }\\n        }\\n    </style>\\n</head>\\n<body>\\n    <div class=\\"verification-modal\\">\\n        <div class=\\"modal-header\\">\\n            <span class=\\"modal-title\\" data-i18n=\\"securityVerification\\">Security Verification</span>\\n        </div>\\n        <div class=\\"puzzle-container\\">\\n            <div class=\\"puzzle-image\\">\\n                <div class=\\"puzzle-piece\\"></div>\\n            </div>\\n        </div>\\n        <div class=\\"slider\\">\\n            <div class=\\"slider-text\\" data-i18n=\\"slideToComplete\\">Slide to complete the puzzle</div>\\n            <div class=\\"slider-handle\\">\\n                <svg width=\\"16\\" height=\\"16\\" viewBox=\\"0 0 24 24\\" fill=\\"none\\" stroke=\\"currentColor\\" stroke-width=\\"2\\">\\n                    <path d=\\"M9 18l6-6-6-6\\"/>\\n                </svg>\\n            </div>\\n        </div>\\n    </div>\\n    <script>\\n        document.addEventListener(\\"DOMContentLoaded\\", function() {\\n            const translations = {\\n                \\"en\\": {\\n                    securityVerification: \\"Security Verification\\",\\n                    slideToComplete: \\"Slide to complete the puzzle\\"\\n                },\\n                \\"zh\\": {\\n                    securityVerification: \\"安全验证\\",\\n                    slideToComplete: \\"向右滑动完成拼图\\"\\n                }\\n            };\\n\\n            function setLanguage() {\\n                const userLang = navigator.language || navigator.userLanguage;\\n                const lang = userLang.startsWith(\\"zh\\") ? \\"zh\\" : \\"en\\";\\n                \\n                document.querySelectorAll(\\"[data-i18n]\\").forEach(element => {\\n                    const key = element.getAttribute(\\"data-i18n\\");\\n                    element.textContent = translations[lang][key];\\n                });\\n                \\n                document.documentElement.lang = lang;\\n                document.title = translations[lang].securityVerification;\\n            }\\n\\n            setLanguage();\\n        });\\n    </script>\\n    <script type=\\"text/javascript\\" src=\\"/_guard/slide.js\\"></script>\\n</body>\\n</html>';
set @captcha_html = '<!DOCTYPE html>\\n<html>\\n<head>\\n    <meta charset=\\"UTF-8\\">\\n    <meta name=\\"viewport\\" content=\\"width=device-width, initial-scale=1.0\\">\\n    <title></title>\\n    <style>\\n        * {\\n            box-sizing: border-box;\\n            margin: 0;\\n            padding: 0;\\n        }\\n\\n        body {\\n            font-family: \\"Segoe UI\\", Tahoma, Geneva, Verdana, sans-serif;\\n            display: flex;\\n            justify-content: center;\\n            align-items: center;\\n            min-height: 100vh;\\n            background: #f5f6fa;\\n            padding: 20px;\\n        }\\n\\n        .container {\\n            background: white;\\n            padding: 30px;\\n            border-radius: 20px;\\n            box-shadow: 0 10px 20px rgba(0,0,0,0.1);\\n            text-align: center;\\n            max-width: 400px;\\n            width: 100%;\\n            transition: transform 0.3s ease;\\n            display: flex;\\n            flex-direction: column;\\n            gap: 20px;\\n        }\\n\\n        h2 {\\n            color: #333;\\n            font-size: 1.8em;\\n            font-weight: 600;\\n            margin: 0;\\n        }\\n\\n        .subtitle {\\n            color: #666;\\n            font-size: 0.9em;\\n            margin-top: -15px;\\n        }\\n\\n        .image-container {\\n            position: relative;\\n            width: 100%;\\n        }\\n\\n        .captcha-image {\\n            width: 100%;\\n            height: auto;\\n            border-radius: 8px;\\n            box-shadow: 0 2px 10px rgba(0,0,0,0.05);\\n        }\\n\\n        .refresh-icon {\\n            position: absolute;\\n            top: 10px;\\n            right: 10px;\\n            background: rgba(255, 255, 255, 0.9);\\n            border-radius: 50%;\\n            width: 32px;\\n            height: 32px;\\n            display: flex;\\n            align-items: center;\\n            justify-content: center;\\n            cursor: pointer;\\n            transition: transform 0.3s ease;\\n            border: none;\\n            box-shadow: 0 2px 5px rgba(0,0,0,0.1);\\n        }\\n\\n        .refresh-icon:hover {\\n            transform: rotate(30deg);\\n        }\\n\\n        .verification-area {\\n            display: flex;\\n            gap: 10px;\\n            width: 100%;\\n        }\\n\\n        input {\\n            flex: 1;\\n            min-width: 0; /* 防止flex子项溢出 */\\n            padding: 12px 15px;\\n            font-size: 16px;\\n            border: 2px solid #e0e0e0;\\n            border-radius: 10px;\\n            outline: none;\\n            transition: all 0.3s ease;\\n            text-align: center;\\n        }\\n\\n\\n        input:focus {\\n            border-color: #4285f4;\\n            box-shadow: 0 0 0 3px rgba(66,133,244,0.1);\\n        }\\n\\n        .submit-btn {\\n            flex-shrink: 0; /* 防止按钮被压缩 */\\n            background: linear-gradient(135deg, #4285f4, #3367d6);\\n            color: white;\\n            padding: 12px 25px;\\n            border: none;\\n            border-radius: 10px;\\n            font-size: 16px;\\n            cursor: pointer;\\n            transition: all 0.3s ease;\\n            font-weight: 500;\\n            white-space: nowrap;\\n        }\\n\\n\\n        .submit-btn:hover {\\n            transform: translateY(-2px);\\n            box-shadow: 0 5px 15px rgba(0,0,0,0.1);\\n        }\\n\\n        .submit-btn:active {\\n            transform: translateY(0);\\n        }\\n\\n        @keyframes shake {\\n            0%, 100% { transform: translateX(0); }\\n            25% { transform: translateX(-5px); }\\n            75% { transform: translateX(5px); }\\n        }\\n\\n        .shake {\\n            animation: shake 0.5s ease-in-out;\\n        }\\n    </style>\\n</head>\\n<body>\\n    <div class=\\"container\\">\\n        <h2></h2>\\n      <p id=\\"err\\"></p>\\n        <div class=\\"image-container\\">\\n            <img id=\\"captcha\\" class=\\"captcha-image\\" alt=\\"\\">\\n            <button class=\\"refresh-icon\\" onclick=\\"refreshCaptcha()\\">\\n                <svg width=\\"16\\" height=\\"16\\" viewBox=\\"0 0 16 16\\" fill=\\"#666\\">\\n                    <path d=\\"M13.65 2.35A8 8 0 1 0 14.85 12h-2.17a6 6 0 1 1-1.03-7.76L9 7h7V0l-2.35 2.35z\\"/>\\n                </svg>\\n            </button>\\n        </div>\\n        <div class=\\"verification-area\\">\\n            <input type=\\"text\\" id=\\"answer\\" autocomplete=\\"off\\">\\n            <button class=\\"submit-btn\\"></button>\\n        </div>\\n    </div>\\n    <script type=\\"text/javascript\\" src=\\"/_guard/captcha.js\\"></script>\\n    <script>\\n        const translations = {\\n            en: {\\n                title: \\"Security Verification\\",\\n                placeholder: \\"Enter result\\",\\n                submit: \\"Submit\\",\\n                newProblem: \\"New Problem\\",\\n                altText: \\"Math Problem\\"\\n            },\\n            zh: {\\n                title: \\"安全验证\\",\\n                placeholder: \\"输入计算结果\\",\\n                submit: \\"提交答案\\",\\n                newProblem: \\"换一题\\",\\n                altText: \\"算术题\\"\\n            }\\n        };\\n\\n        function detectLanguage() {\\n            const userLang = navigator.language || navigator.userLanguage;\\n            return userLang.startsWith(\\"zh\\") ? \\"zh\\" : \\"en\\";\\n        }\\n\\n        const currentLang = detectLanguage();\\n\\n        function updateUI() {\\n            const texts = translations[currentLang];\\n            document.title = texts.title;\\n            document.querySelector(\\"h2\\").textContent = texts.title;\\n            document.getElementById(\\"answer\\").placeholder = texts.placeholder;\\n            document.querySelector(\\".submit-btn\\").textContent = texts.submit;\\n            document.querySelector(\\".refresh-icon\\").title = texts.newProblem;\\n            document.getElementById(\\"captcha\\").alt = texts.altText;\\n            document.documentElement.lang = currentLang;\\n        }\\n\\n        function refreshCaptcha() {\\n            const img = document.getElementById(\\"captcha\\");\\n            const timestamp = new Date().getTime();\\n            img.src = `/_guard/captcha.png?t=${timestamp}&lang=${currentLang}`;\\n            document.getElementById(\\"answer\\").focus();\\n        }\\n\\n        window.onload = function() {\\n            updateUI();\\n            refreshCaptcha();\\n            document.getElementById(\\"answer\\").focus();\\n        };\\n    </script>\\n</body>\\n</html>'; 
set @click_html = '<!DOCTYPE html>\\n<html>\\n<head>\\n    <meta charset=\\"UTF-8\\">\\n    <meta name=\\"viewport\\" content=\\"width=device-width, initial-scale=1.0\\">\\n    <title id=\\"pageTitle\\">Security Verification</title>\\n    <style>\\n        body, html {\\n            height: 100%;\\n            margin: 0;\\n            display: flex;\\n            justify-content: center;\\n            align-items: center;\\n            background-color: #f4f4f4;\\n        }\\n\\n        .content {\\n            width: 340px;\\n            text-align: center;\\n            background-color: white;\\n            padding: 20px;\\n            box-shadow: 0 4px 8px rgba(0,0,0,0.1);\\n            border-radius: 10px;\\n            position: relative;\\n        }\\n\\n        .img-container {\\n            position: relative;\\n            width: 100%;\\n            margin-bottom: 10px;\\n        }\\n\\n        img {\\n            max-width: 100%;\\n            height: auto;\\n            display: block;\\n        }\\n\\n        p {\\n            margin: 10px 0;\\n            font-size: 18px;\\n            color: black;\\n            text-align: left;\\n        }\\n\\n        p.small-text {\\n            font-size: 16px;\\n            color: gray;\\n        }\\n\\n        .marker {\\n            position: absolute;\\n            background-color: #007dfa;\\n            border: 2px solid white;\\n            border-radius: 50%;\\n            padding: 5px;\\n            color: white;\\n            font-size: 12px;\\n            font-weight: bold;\\n            user-select: none;\\n            box-shadow: 0px 0px 3px rgba(0,0,0,0.3);\\n            width: 10px;\\n            height: 10px;\\n            display: flex;\\n            justify-content: center;\\n            align-items: center;\\n            transform: translate(-50%, -50%);\\n            z-index: 100;\\n        }\\n\\n        .clickableImg {\\n            width: 340px;\\n            background-size: auto;\\n            background-position: top;\\n            position: relative;\\n        }\\n\\n        .word {\\n            width: 120px;\\n            height: 40px;\\n            background-size: auto;\\n            background-position: bottom;\\n            position: relative;\\n        }\\n\\n        #instruction {\\n            display: flex;\\n            align-items: center;\\n        }\\n\\n    </style>\\n</head>\\n<body>\\n<div class=\\"content\\">\\n    <p class=\\"small-text\\" id=\\"headerText\\">Security Verification</p>\\n    <div id=\\"instruction\\">Please click in sequence: <div class=\\"word\\"></div></div>\\n    <div class=\\"img-container\\">\\n        <div class=\\"clickableImg\\">\\n    </div>\\n</div>\\n<script>\\n    // Language translations\\n    const translations = {\\n        \\"en\\": {\\n            title: \\"Security Verification\\",\\n            header: \\"Security Verification\\",\\n            instruction: \\"Please click in sequence: \\"\\n        },\\n        \\"zh\\": {\\n            title: \\"安全验证\\",\\n            header: \\"安全验证\\",\\n            instruction: \\"请依次点击：\\"\\n        }\\n    };\\n\\n    // Default language is English\\n    let currentLang = \\"en\\";\\n\\n    // Get browser language\\n    const userLang = navigator.language || navigator.userLanguage;\\n    if (userLang.toLowerCase().startsWith(\\"zh\\")) {\\n        currentLang = \\"zh\\";\\n    }\\n\\n    // Apply translations\\n    const texts = translations[currentLang];\\n    document.getElementById(\\"pageTitle\\").textContent = texts.title;\\n    document.getElementById(\\"headerText\\").textContent = texts.header;\\n    document.getElementById(\\"instruction\\").innerHTML = texts.instruction + \\"<div class=word></div>\\";\\n</script>\\n<script type=\\"text/javascript\\" src=\\"/_guard/click.js\\"></script>\\n\\n</body>\\n</html>';
set @easy_click_html = '<!DOCTYPE html>\\n<html>\\n<head>\\n    <meta charset=\\"UTF-8\\">\\n    <meta name=\\"viewport\\" content=\\"width=device-width, initial-scale=1.0\\">\\n    <title id=\\"pageTitle\\">Security Verification</title>\\n    <style>\\n        body, html {\\n            height: 100%;\\n            margin: 0;\\n            display: flex;\\n            justify-content: center;\\n            align-items: center;\\n            background-color: #f4f4f4;\\n        }\\n\\n        .content {\\n            width: 340px;\\n            text-align: center;\\n            background-color: white;\\n            padding: 20px;\\n            box-shadow: 0 4px 8px rgba(0,0,0,0.1);\\n            border-radius: 10px;\\n            position: relative;\\n        }\\n\\n        .img-container {\\n            position: relative;\\n            width: 100%;\\n            margin-bottom: 10px;\\n        }\\n\\n        img {\\n            max-width: 100%;\\n            height: auto;\\n            display: block;\\n        }\\n\\n        p {\\n            margin: 10px 0;\\n            font-size: 18px;\\n            color: black;\\n            text-align: left;\\n        }\\n\\n        p.small-text {\\n            font-size: 16px;\\n            color: gray;\\n        }\\n\\n        .marker {\\n            position: absolute;\\n            background-color: #007dfa;\\n            border: 2px solid white;\\n            border-radius: 50%;\\n            padding: 5px;\\n            color: white;\\n            font-size: 12px;\\n            font-weight: bold;\\n            user-select: none;\\n            box-shadow: 0px 0px 3px rgba(0,0,0,0.3);\\n            width: 10px;\\n            height: 10px;\\n            display: flex;\\n            justify-content: center;\\n            align-items: center;\\n            transform: translate(-50%, -50%);\\n            z-index: 100;\\n        }\\n\\n        .clickableImg {\\n            width: 340px;\\n            background-size: auto;\\n            background-position: top;\\n            position: relative;\\n        }\\n\\n        .word {\\n            width: 120px;\\n            height: 40px;\\n            background-size: auto;\\n            background-position: bottom;\\n            position: relative;\\n        }\\n\\n        #instruction {\\n            display: flex;\\n            align-items: center;\\n        }\\n\\n    </style>\\n</head>\\n<body>\\n<div class=\\"content\\">\\n    <p class=\\"small-text\\" id=\\"headerText\\">Security Verification</p>\\n    <div id=\\"instruction\\">Please click in sequence: <div class=\\"word\\"></div></div>\\n    <div class=\\"img-container\\">\\n        <div class=\\"clickableImg\\">\\n    </div>\\n</div>\\n<script>\\n    // Language translations\\n    const translations = {\\n        \\"en\\": {\\n            title: \\"Security Verification\\",\\n            header: \\"Security Verification\\",\\n            instruction: \\"Please click in sequence: \\"\\n        },\\n        \\"zh\\": {\\n            title: \\"安全验证\\",\\n            header: \\"安全验证\\",\\n            instruction: \\"请依次点击：\\"\\n        }\\n    };\\n\\n    // Default language is English\\n    let currentLang = \\"en\\";\\n\\n    // Get browser language\\n    const userLang = navigator.language || navigator.userLanguage;\\n    if (userLang.toLowerCase().startsWith(\\"zh\\")) {\\n        currentLang = \\"zh\\";\\n    }\\n\\n    // Apply translations\\n    const texts = translations[currentLang];\\n    document.getElementById(\\"pageTitle\\").textContent = texts.title;\\n    document.getElementById(\\"headerText\\").textContent = texts.header;\\n    document.getElementById(\\"instruction\\").innerHTML = texts.instruction + \\"<div class=word></div>\\";\\n</script>\\n<script type=\\"text/javascript\\" src=\\"/_guard/easy_click.js\\"></script>\\n\\n</body>\\n</html>';
set @easy_slider_html = '<!DOCTYPE html>\\n<html>\\n<head>\\n    <meta charset=\\"UTF-8\\">\\n    <meta name=\\"viewport\\" content=\\"width=device-width, initial-scale=1.0\\">\\n    <title>Security Verification</title>\\n    <style>\\n        body {\\n            background: #f5f6fa;\\n            display: flex;\\n            justify-content: center;\\n            align-items: center;\\n            min-height: 100vh;\\n            margin: 0;\\n            font-family: -apple-system, BlinkMacSystemFont, \\"Segoe UI\\", Roboto, Oxygen, Ubuntu, Cantarell, \\"Open Sans\\", \\"Helvetica Neue\\", sans-serif;\\n        }\\n\\n        .verification-modal {\\n            background: white;\\n            border-radius: 12px;\\n            padding: 20px;\\n            box-shadow: 0 10px 30px rgba(0,0,0,0.1);\\n        }\\n\\n        .modal-header {\\n            display: flex;\\n            justify-content: space-between;\\n            align-items: center;\\n            margin-bottom: 15px;\\n        }\\n\\n        .modal-title {\\n            font-size: 16px;\\n            color: #333;\\n            font-weight: 600;\\n        }\\n        \\n        .puzzle-container {\\n            width: 100%;\\n            position: relative;\\n            background: #f8f9fa;\\n            overflow: hidden;\\n            border-radius: 8px;\\n            margin-bottom: 15px;\\n        }\\n\\n        .puzzle-image {\\n            width: 340px;\\n            height: 200px;\\n            background-size: auto;\\n            background-position: left;\\n            position: relative;\\n        }\\n\\n        .puzzle-piece {\\n            width: 54px;\\n            height: 54px;\\n            position: absolute;\\n            left: 20px;\\n            top: 100px;\\n            background-size: auto;\\n            background-position: -345px;\\n        }\\n\\n        .slider {\\n            width: 100%;\\n            height: 40px;\\n            background: #f0f2f5;\\n            position: relative;\\n            border-radius: 20px;\\n            box-shadow: inset 0 1px 3px rgba(0,0,0,0.1);\\n        }\\n\\n        .slider-handle {\\n            width: 50px;\\n            height: 40px;\\n            background: linear-gradient(135deg, #4285f4, #3367d6);\\n            position: absolute;\\n            left: 20px;\\n            top: -1px;\\n            cursor: pointer;\\n            border-radius: 20px;\\n            display: flex;\\n            align-items: center;\\n            justify-content: center;\\n            color: white;\\n            font-size: 18px;\\n            box-shadow: 0 2px 10px rgba(66,133,244,0.3);\\n            transition: all 0.3s ease;\\n        }\\n\\n        .slider-handle:hover {\\n            background: linear-gradient(135deg, #5295f4, #4377e6);\\n            box-shadow: 0 4px 15px rgba(66,133,244,0.4);\\n        }\\n\\n        .slider-text {\\n            width: 100%;\\n            height: 100%;\\n            display: flex;\\n            align-items: center;\\n            justify-content: center;\\n            color: #666;\\n            font-size: 14px;\\n            user-select: none;\\n        }\\n\\n        .success .slider-handle {\\n            background: linear-gradient(135deg, #4CAF50, #45a049);\\n            box-shadow: 0 2px 10px rgba(76,175,80,0.3);\\n        }\\n\\n        @keyframes success-pulse {\\n            0% { transform: scale(1); }\\n            50% { transform: scale(1.05); }\\n            100% { transform: scale(1); }\\n        }\\n\\n        .success .slider-handle {\\n            animation: success-pulse 0.5s ease;\\n        }\\n\\n        @keyframes glow {\\n            from {\\n                box-shadow: 0 0 5px rgba(255, 255, 255, 0.3);\\n            }\\n            to {\\n                box-shadow: 0 0 10px rgba(255, 255, 255, 0.5);\\n            }\\n        }\\n    </style>\\n</head>\\n<body>\\n    <div class=\\"verification-modal\\">\\n        <div class=\\"modal-header\\">\\n            <span class=\\"modal-title\\" data-i18n=\\"securityVerification\\">Security Verification</span>\\n        </div>\\n        <div class=\\"puzzle-container\\">\\n            <div class=\\"puzzle-image\\">\\n                <div class=\\"puzzle-piece\\"></div>\\n            </div>\\n        </div>\\n        <div class=\\"slider\\">\\n            <div class=\\"slider-text\\" data-i18n=\\"slideToComplete\\">Slide to complete the puzzle</div>\\n            <div class=\\"slider-handle\\">\\n                <svg width=\\"16\\" height=\\"16\\" viewBox=\\"0 0 24 24\\" fill=\\"none\\" stroke=\\"currentColor\\" stroke-width=\\"2\\">\\n                    <path d=\\"M9 18l6-6-6-6\\"/>\\n                </svg>\\n            </div>\\n        </div>\\n    </div>\\n    \\n    <script>\\n        document.addEventListener(\\"DOMContentLoaded\\", function() {\\n            const translations = {\\n                \\"en\\": {\\n                    securityVerification: \\"Security Verification\\",\\n                    slideToComplete: \\"Slide to complete the puzzle\\"\\n                },\\n                \\"zh\\": {\\n                    securityVerification: \\"安全验证\\",\\n                    slideToComplete: \\"向右滑动完成拼图\\"\\n                }\\n            };\\n\\n            function setLanguage() {\\n                const userLang = navigator.language || navigator.userLanguage;\\n                const lang = userLang.startsWith(\\"zh\\") ? \\"zh\\" : \\"en\\";\\n                \\n                document.querySelectorAll(\\"[data-i18n]\\").forEach(element => {\\n                    const key = element.getAttribute(\\"data-i18n\\");\\n                    element.textContent = translations[lang][key];\\n                });\\n                \\n                document.documentElement.lang = lang;\\n                document.title = translations[lang].securityVerification;\\n            }\\n\\n            setLanguage();\\n        });\\n    </script>\\n    <script type=\\"text/javascript\\" src=\\"/_guard/easy_slide.js\\"></script>\\n</body>\\n</html>';
insert into config values ('openresty-config',concat('{"block_page_num_limit":200, "block_page_not_counted":1, "force_default_page_cc":"0","auto_default_page_cc_qps":100, "well_known_auto_protect_count":600,"well_known_protect_expire":0, "acme_ip":[], "internal_qps":50,"internal_res_block_time":3600,"internal_rule":[{"period":"120","reqs":"20"},{"period":"","reqs":""},{"period":"","reqs":""}], "at_hour":"3", "default_block_way":"ipset","ipset_auto_enable":0,"site_block_qps":"200", "cc_img_url_type":"system","cc_img_url":"","cc_img_url_interval":"25", "auto_delete_access_log": 0,  "tmp_white_total_limit":400, "tmp_white_per_limit": 50, "resolver":"223.5.5.5 223.6.6.6", "ssl_handshake_limit":1, "icmp_drop":"0", "default_page_refuse":"0", "default_page_rule":"10003", "cc_enable":true,"custom_white":"","custom_black":"", "key":"__OPENRESTY_KEY__","auto_switch":{"enable":false, "qps_50x":10,"qps_total":500,"rule":"2","seconds":300}, "log":{"port":514,"host":"127.0.0.1","log_level":"info","debug_ip":"127.0.0.1"}, "easy_click_html":"',@easy_click_html,'", "easy_slider_html":"',@easy_slider_html,'", "rotate_html":"',@rotate_html,'", "delay_jump_html":"',@delay_jump_html,'", "slider_html":"',@slider_html,'","captcha_html":"',@captcha_html,'","click_html":"',@click_html,'","block_time":3600,"white_time":21600,"spider_ip":{"40.77.195": 1, "40.77.194": 1, "40.77.191": 1, "40.77.190": 1, "40.77.193": 1, "40.77.192": 1, "34.154.114.150": 1, "154.12.224.26": 1, "220.243.189": 1, "220.243.188": 1, "40.77.168": 1, "40.77.169": 1, "40.77.160": 1, "123.183.224": 1, "40.77.162": 1, "40.77.163": 1, "40.77.164": 1, "40.77.165": 1, "40.77.166": 1, "40.77.167": 1, "66.249.64": 1, "66.249.65": 1, "20.36.108": 1, "61.135.169.19": 1, "217.156.87.14": 1, "34.151.74.145": 1, "34.151.74.144": 1, "34.151.74.147": 1, "34.151.74.146": 1, "157.55.50": 1, "40.77.248": 1, "34.151.74.149": 1, "34.151.74.148": 1, "40.90.149": 1, "40.90.148": 1, "40.90.147": 1, "40.90.146": 1, "40.90.145": 1, "40.90.144": 1, "34.151.74.150": 1, "65.55.230.252": 1, "51.4.84": 1, "65.55.230.250": 1, "40.77.223": 1, "40.77.222": 1, "40.77.221": 1, "40.77.220": 1, "34.96.162.50": 1, "34.96.162.51": 1, "34.96.162.52": 1, "34.96.162.53": 1, "34.96.162.54": 1, "34.64.82": 1, "13.67.10": 1, "218.30.103": 1, "23.103.64": 1, "65.54.164": 1, "207.68.185.33": 1, "40.77.161": 1, "199.30.28": 1, "106.11.157": 1, "106.11.156": 1, "106.11.155": 1, "106.11.154": 1, "106.11.153": 1, "106.11.152": 1, "207.46.13": 1, "193.234.60.18": 1, "34.175.160.70": 1, "106.11.159": 1, "106.11.158": 1, "34.88.194.12": 1, "154.53.40.2": 1, "109.238.6.49": 1, "109.238.6.46": 1, "61.135.158.81": 1, "220.243.136": 1, "220.243.135": 1, "40.79.186": 1, "217.156.87.5": 1, "110.249.201": 1, "110.249.202": 1, "131.253.46.111": 1, "106.120.188.69": 1, "40.90.11": 1, "42.120.236": 1, "34.165.18.180": 1, "34.165.18.181": 1, "34.165.18.182": 1, "42.236.48": 1, "42.159.48": 1, "199.30.30": 1, "199.30.31": 1, "202.89.235": 1, "111.206.221": 1, "42.120.161": 1, "104.44.93": 1, "104.44.92": 1, "104.44.91": 1, "64.4.22": 1, "36.110.147.71": 1, "36.110.147.70": 1, "157.55.154": 1, "42.236.46": 1, "34.80.50.84": 1, "157.56.93": 1, "34.89.198.82": 1, "34.80.50.83": 1, "34.89.198.80": 1, "34.89.198.81": 1, "123.125.125.179": 1, "42.236.49": 1, "34.89.198.84": 1, "34.89.198.85": 1, "42.236.99": 1, "65.55.189": 1, "199.188.107.107": 1, "34.126.178.101": 1, "34.126.178.100": 1, "34.126.178.103": 1, "103.25.156": 1, "34.126.178.105": 1, "34.126.178.104": 1, "34.126.178.106": 1, "157.56.71": 1, "61.135.169.52": 1, "61.135.169.53": 1, "178.20.236": 1, "61.135.168": 1, "113.24.225": 1, "65.55.230.225": 1, "40.77.186": 1, "40.77.187": 1, "40.77.184": 1, "40.77.185": 1, "40.77.182": 1, "40.77.183": 1, "40.77.180": 1, "40.77.181": 1, "40.77.188": 1, "40.77.189": 1, "42.236.101": 1, "42.236.102": 1, "42.236.103": 1, "20.74.197": 1, "35.247.243.246": 1, "35.247.243.244": 1, "35.247.243.245": 1, "35.247.243.242": 1, "35.247.243.243": 1, "35.247.243.240": 1, "35.247.243.241": 1, "20.15.133": 1, "106.38.241": 1, "207.46.126": 1, "34.100.182.102": 1, "34.100.182.103": 1, "34.100.182.100": 1, "34.100.182.101": 1, "65.52.109": 1, "34.100.182.104": 1, "34.100.182.105": 1, "131.253.46.223": 1, "157.56.2": 1, "157.56.3": 1, "157.56.0": 1, "157.56.1": 1, "20.43.120": 1, "34.118.254.12": 1, "34.118.254.13": 1, "34.118.254.10": 1, "34.118.254.11": 1, "34.118.254.14": 1, "40.90.150": 1, "40.90.151": 1, "40.90.152": 1, "40.90.153": 1, "40.90.154": 1, "40.90.155": 1, "40.90.156": 1, "40.90.157": 1, "40.90.158": 1, "34.101.50.150": 1, "42.120.234": 1, "42.120.235": 1, "111.221.28": 1, "61.135.165.19": 1, "49.7.116": 1, "49.7.117": 1, "40.90.8": 1, "207.68.176.142": 1, "207.68.176.141": 1, "34.96.162.49": 1, "118.184.177": 1, "66.249.79": 1, "66.249.78": 1, "66.249.71": 1, "66.249.70": 1, "66.249.73": 1, "66.249.72": 1, "66.249.75": 1, "66.249.74": 1, "66.249.77": 1, "66.249.76": 1, "191.232.136.48": 1, "220.181.32": 1, "34.175.160.64": 1, "34.175.160.65": 1, "60.8.123": 1, "180.76.15": 1, "191.232.136.172": 1, "34.175.160.68": 1, "34.175.160.69": 1, "43.231.99": 1, "207.68.146.215": 1, "61.135.159": 1, "131.253.46.125": 1, "131.253.46.126": 1, "34.175.160.66": 1, "65.54.247": 1, "34.175.160.67": 1, "40.66.1": 1, "180.153.232": 1, "40.66.4": 1, "34.118.66.14": 1, "34.118.66.12": 1, "34.118.66.13": 1, "34.118.66.10": 1, "34.118.66.11": 1, "51.5.84": 1, "40.77.173": 1, "40.77.172": 1, "40.77.171": 1, "40.77.209": 1, "40.77.208": 1, "42.159.176": 1, "34.165.18.177": 1, "34.165.18.176": 1, "34.155.98.38": 1, "220.181.108": 1, "34.89.198.83": 1, "34.155.98.34": 1, "34.155.98.35": 1, "34.155.98.36": 1, "34.155.98.37": 1, "34.165.18.179": 1, "34.165.18.178": 1, "34.155.98.32": 1, "34.155.98.33": 1, "103.255.141": 1, "34.89.198.86": 1, "154.12.224.161": 1, "157.55.39": 1, "191.232.136.86": 1, "65.55.230.253": 1, "180.76.5": 1, "36.110.147.68": 1, "36.110.147.69": 1, "193.234.60.17": 1, "111.206.198": 1, "36.110.147.64": 1, "36.110.147.65": 1, "36.110.147.66": 1, "36.110.147.67": 1, "34.126.178.102": 1, "42.120.160": 1, "192.178.5": 1, "34.80.50.85": 1, "123.126.113": 1, "131.253.36": 1, "34.80.50.82": 1, "34.80.50.81": 1, "131.253.35": 1, "123.125.125.184": 1, "131.253.38": 1, "123.125.125.181": 1, "123.125.125.182": 1, "40.79.131": 1, "61.135.169.20": 1, "61.135.165.20": 1, "65.55.107": 1, "131.253.46.221": 1, "131.253.46.224": 1, "191.232.136.216": 1, "34.152.50.69": 1, "49.7.21": 1, "49.7.20": 1, "180.153.234": 1, "180.153.236": 1, "207.68.146.222": 1, "207.68.146.221": 1, "111.225.148": 1, "111.225.149": 1, "65.55.219": 1, "65.55.218": 1, "65.55.213": 1, "65.55.212": 1, "65.55.211": 1, "65.55.210": 1, "65.55.217": 1, "65.55.216": 1, "65.55.215": 1, "65.55.214": 1, "34.152.50.68": 1, "199.30.17": 1, "34.152.50.64": 1, "34.152.50.65": 1, "34.152.50.66": 1, "34.152.50.67": 1, "203.208.60": 1, "199.30.19": 1, "123.125.66": 1, "34.96.162.48": 1, "199.30.26": 1, "34.147.110.148": 1, "34.147.110.149": 1, "34.147.110.144": 1, "34.147.110.145": 1, "34.147.110.146": 1, "34.147.110.147": 1, "191.233.204": 1, "40.77.252": 1, "40.77.253": 1, "40.77.250": 1, "40.77.251": 1, "180.149.133": 1, "40.77.254": 1, "40.77.255": 1, "34.101.50.148": 1, "34.101.50.149": 1, "34.101.50.146": 1, "34.101.50.147": 1, "34.146.150.150": 1, "34.101.50.145": 1, "111.221.31": 1, "180.163.220": 1, "34.176.130.20": 1, "34.176.130.21": 1, "34.176.130.22": 1, "13.66.144": 1, "34.65.242.118": 1, "66.249.68": 1, "66.249.69": 1, "124.166.232": 1, "34.118.66.1": 1, "116.179.37": 1, "106.120.173": 1, "34.65.242.113": 1, "34.65.242.112": 1, "34.65.242.115": 1, "34.65.242.114": 1, "34.65.242.117": 1, "34.65.242.116": 1, "65.55.146": 1, "123.125.125.151": 1, "61.135.189": 1, "60.8.151": 1, "42.236.16": 1, "51.105.67": 1, "64.68.88": 1, "42.236.15": 1, "42.236.14": 1, "207.68.155": 1, "13.66.139": 1, "66.249.66": 1, "65.52.110": 1, "34.154.114.148": 1, "34.154.114.149": 1, "34.154.114.144": 1, "34.154.114.145": 1, "34.154.114.146": 1, "34.154.114.147": 1, "42.156.255": 1, "42.156.254": 1, "61.135.186": 1, "40.77.177": 1, "40.77.176": 1, "40.77.175": 1, "40.77.174": 1, "123.125.186.10": 1, "123.125.186.11": 1, "123.125.186.12": 1, "40.77.170": 1, "40.77.179": 1, "40.77.178": 1, "40.77.216": 1, "40.77.217": 1, "40.77.214": 1, "40.77.215": 1, "40.77.212": 1, "40.77.213": 1, "40.77.210": 1, "40.77.211": 1, "40.77.218": 1, "40.77.219": 1, "34.88.194.0": 1, "34.88.194.1": 1, "61.49.160.21": 1, "61.49.160.20": 1, "42.236.50": 1, "194.32.107.227": 1, "194.32.107.226": 1, "154.53.40.69": 1, "154.53.40.63": 1, "42.236.17": 1, "157.55.21": 1, "157.55.22": 1, "157.55.23": 1, "42.236.13": 1, "42.236.12": 1, "42.236.10": 1, "65.55.25": 1, "104.44.253": 1, "207.68.185.56": 1, "34.176.130.19": 1, "34.176.130.18": 1, "34.176.130.17": 1, "34.176.130.16": 1, "123.126.68": 1, "131.253.47.190": 1, "207.46.199": 1, "131.253.25": 1, "131.253.24": 1, "131.253.27": 1, "131.253.26": 1, "34.118.254.0": 1, "34.118.254.1": 1, "157.55.2": 1, "157.55.7": 1, "42.156.138": 1, "42.156.139": 1, "52.167.144": 1, "42.156.137": 1, "34.101.50.144": 1, "40.73.148": 1, "157.55.103": 1, "58.250.125": 1, "157.55.106": 1, "157.55.107": 1, "207.46.12.79": 1, "207.46.12.78": 1, "207.46.12.75": 1, "207.46.12.74": 1, "207.46.12.77": 1, "207.46.12.76": 1, "207.46.12.73": 1, "207.46.12.72": 1, "154.53.40.3": 1, "34.88.194.13": 1, "34.88.194.10": 1, "34.88.194.11": 1, "34.88.194.14": 1, "34.80.50.86": 1, "20.79.107": 1, "65.55.208": 1, "65.55.209": 1, "34.152.50.70": 1, "106.120.188.72": 1, "106.120.188.73": 1, "106.120.188.70": 1, "106.120.188.71": 1, "106.120.188.76": 1, "106.120.188.74": 1, "106.120.188.75": 1, "61.135.165.52": 1, "123.125.71": 1, "61.135.165.53": 1, "123.125.109": 1, "34.89.10.86": 1, "34.89.10.84": 1, "34.89.10.85": 1, "34.89.10.82": 1, "34.89.10.83": 1, "34.89.10.80": 1, "34.89.10.81": 1, "34.147.110.150": 1, "34.146.150.149": 1, "34.146.150.148": 1, "34.146.150.145": 1, "34.146.150.144": 1, "34.146.150.147": 1, "34.146.150.146": 1, "220.181.124": 1, "220.181.125": 1, "104.47.224": 1, "199.30.29": 1, "13.71.172": 1, "199.30.23": 1, "199.30.22": 1, "199.30.21": 1, "199.30.20": 1, "199.30.27": 1, "61.49.160.19": 1, "199.30.25": 1, "199.30.24": 1, "207.68.176.163": 1, "207.68.176.164": 1, "157.55.10": 1, "157.55.13": 1, "157.55.12": 1, "199.30.18": 1, "111.202.101": 1, "111.202.100": 1, "111.202.103": 1, "34.80.50.80": 1, "65.55.54": 1, "34.100.182.106": 1, "123.126.50": 1, "42.236.53": 1, "42.236.52": 1, "42.236.51": 1, "131.253.47.148": 1, "42.236.55": 1, "42.236.54": 1, "131.253.47.147": 1, "199.188.107.110": 1, "64.68.92": 1, "64.68.91": 1, "64.68.90": 1, "13.69.66": 1, "61.135.158.72": 1, "116.179.32": 1, "109.238.6.19": 1, "34.118.66.0": 1, "42.156.136": 1},"built_in_white":["45.33.99.204","139.162.76.111","192.46.226.104","45.79.81.228","49.7.135.3","119.96.229.174","129.28.14.61","111.13.102.10","183.232.11.38","125.39.179.198","211.90.241.52","112.91.140.167"]}'),'openresty_config','0','global', now(),now(),1,null);

# error page
set @p400 = '\\n<!DOCTYPE html>\\n<!--[if lt IE 7]> <html class=\\"no-js ie6 oldie\\" lang=\\"en-US\\"> <![endif]-->\\n<!--[if IE 7]>    <html class=\\"no-js ie7 oldie\\" lang=\\"en-US\\"> <![endif]-->\\n<!--[if IE 8]>    <html class=\\"no-js ie8 oldie\\" lang=\\"en-US\\"> <![endif]-->\\n<!--[if gt IE 8]><!--> <html class=\\"no-js\\" lang=\\"en-US\\"> <!--<![endif]-->\\n<head>\\n<title>请求无效</title>\\n<meta charset=\\"UTF-8\\" />\\n<meta http-equiv=\\"Content-Type\\" content=\\"text/html; charset=UTF-8\\" />\\n<meta http-equiv=\\"X-UA-Compatible\\" content=\\"IE=Edge,chrome=1\\" />\\n<meta name=\\"robots\\" content=\\"noindex, nofollow\\" />\\n<meta name=\\"viewport\\" content=\\"width=device-width,initial-scale=1\\" />\\n<style>\\n*, body, html {\\n    margin: 0;\\n    padding: 0;\\n}\\n\\nbody, html {\\n    --text-opacity: 1;\\n    color: #404040;\\n    color: rgba(64,64,64,var(--text-opacity));\\n    -webkit-font-smoothing: antialiased;\\n    -moz-osx-font-smoothing: grayscale;\\n    font-family: system-ui,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica Neue,Arial,Noto Sans,sans-serif,Apple Color Emoji,Segoe UI Emoji,Segoe UI Symbol,Noto Color Emoji;\\n    font-size: 16px;\\n}\\n* {\\n    box-sizing: border-box;\\n}\\nhtml[Attributes Style] {\\n    -webkit-locale: \\"en-US\\";\\n}\\n.p-0 {\\n    padding: 0;\\n}\\n\\n\\n.w-240 {\\n    width: 60rem;\\n}\\n\\n.antialiased {\\n    -webkit-font-smoothing: antialiased;\\n    -moz-osx-font-smoothing: grayscale;\\n}\\n.pt-10 {\\n    padding-top: 2.5rem;\\n}\\n.mb-15 {\\n    margin-bottom: 3.75rem;\\n}\\n.mx-auto {\\n    margin-left: auto;\\n    margin-right: auto;\\n}\\n\\n.text-black-dark {\\n    --text-opacity: 1;\\n    color: #404040;\\n    color: rgba(64,64,64,var(--text-opacity));\\n}\\n\\n.mr-2 {\\n    margin-right: .5rem;\\n}\\n.leading-tight {\\n    line-height: 1.25;\\n}\\n.text-60 {\\n    font-size: 60px;\\n}\\n.font-light {\\n    font-weight: 300;\\n}\\n.inline-block {\\n    display: inline-block;\\n}\\n\\n.text-15 {\\n    font-size: 15px;\\n}\\n.font-mono {\\n    font-family: monaco,courier,monospace;\\n}\\n.text-gray-600 {\\n    --text-opacity: 1;\\n    color: #999;\\n    color: rgba(153,153,153,var(--text-opacity));\\n}\\n.leading-1\\\\.3 {\\n    line-height: 1.3;\\n}\\n.text-3xl {\\n    font-size: 1.875rem;\\n}\\n\\n.mb-8 {\\n    margin-bottom: 2rem;\\n}\\n\\n.w-1\\\\/2 {\\n    width: 50%;\\n}\\n\\n.mt-6 {\\n    margin-top: 1.5rem;\\n}\\n\\n.mb-4 {\\n    margin-bottom: 1rem;\\n}\\n\\n\\n.font-normal {\\n    font-weight: 400;\\n}\\n\\n#what-happened-section p {\\n    font-size: 15px;\\n    line-height: 1.5;\\n}\\n\\n</style>\\n\\n</head>\\n<body>\\n  <div id=\\"cf-wrapper\\">\\n    <div id=\\"cf-error-details\\" class=\\"p-0\\">\\n      <header class=\\"mx-auto pt-10 lg:pt-6 lg:px-8 w-240 lg:w-full mb-15 antialiased\\">\\n         <h1 class=\\"inline-block md:block mr-2 md:mb-2 font-light text-60 md:text-3xl text-black-dark leading-tight\\">\\n           <span data-translate=\\"error\\">Error</span>\\n           <span>400</span>\\n         </h1>\\n         <span class=\\"inline-block md:block heading-ray-id font-mono text-15 lg:text-sm lg:leading-relaxed\\">您的IP: {client_ip} &bull;</span>\\n         <span class=\\"inline-block md:block heading-ray-id font-mono text-15 lg:text-sm lg:leading-relaxed\\">节点IP: {node_ip}</span>\\n        <h2 class=\\"text-gray-600 leading-1.3 text-3xl lg:text-2xl font-light\\">当前请求无效</h2>\\n      </header>\\n\\n      <section class=\\"w-240 lg:w-full mx-auto mb-8 lg:px-8\\">\\n          <div id=\\"what-happened-section\\" class=\\"w-1/2 md:w-full\\">\\n            <h2 class=\\"text-3xl leading-tight font-normal mb-4 text-black-dark antialiased\\" data-translate=\\"what_happened\\">什么问题?</h2>\\n            <p>您的请求无效</p>\\n            \\n          </div>\\n\\n          \\n          <div id=\\"resolution-copy-section\\" class=\\"w-1/2 mt-6 text-15 leading-normal\\">\\n            <h2 class=\\"text-3xl leading-tight font-normal mb-4 text-black-dark antialiased\\" data-translate=\\"what_can_i_do\\">如何解决?</h2>\\n            <p>可以联系网站管理员咨询原因</p>\\n          </div>\\n          \\n      </section>\\n\\n      <div class=\\"cf-error-footer cf-wrapper w-240 lg:w-full py-10 sm:py-4 sm:px-8 mx-auto text-center sm:text-left border-solid border-0 border-t border-gray-300\\">\\n\\n</div><!-- /.error-footer -->\\n\\n\\n    </div><!-- /#cf-error-details -->\\n  </div><!-- /#cf-wrapper -->\\n\\n\\n</body>\\n</html>\\n\\n';

set @p403 = '\\n<!DOCTYPE html>\\n<!--[if lt IE 7]> <html class=\\"no-js ie6 oldie\\" lang=\\"en-US\\"> <![endif]-->\\n<!--[if IE 7]>    <html class=\\"no-js ie7 oldie\\" lang=\\"en-US\\"> <![endif]-->\\n<!--[if IE 8]>    <html class=\\"no-js ie8 oldie\\" lang=\\"en-US\\"> <![endif]-->\\n<!--[if gt IE 8]><!--> <html class=\\"no-js\\" lang=\\"en-US\\"> <!--<![endif]-->\\n<head>\\n<title>请求被禁止访问</title>\\n<meta charset=\\"UTF-8\\" />\\n<meta http-equiv=\\"Content-Type\\" content=\\"text/html; charset=UTF-8\\" />\\n<meta http-equiv=\\"X-UA-Compatible\\" content=\\"IE=Edge,chrome=1\\" />\\n<meta name=\\"robots\\" content=\\"noindex, nofollow\\" />\\n<meta name=\\"viewport\\" content=\\"width=device-width,initial-scale=1\\" />\\n<style>\\n*, body, html {\\n    margin: 0;\\n    padding: 0;\\n}\\n\\nbody, html {\\n    --text-opacity: 1;\\n    color: #404040;\\n    color: rgba(64,64,64,var(--text-opacity));\\n    -webkit-font-smoothing: antialiased;\\n    -moz-osx-font-smoothing: grayscale;\\n    font-family: system-ui,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica Neue,Arial,Noto Sans,sans-serif,Apple Color Emoji,Segoe UI Emoji,Segoe UI Symbol,Noto Color Emoji;\\n    font-size: 16px;\\n}\\n* {\\n    box-sizing: border-box;\\n}\\nhtml[Attributes Style] {\\n    -webkit-locale: \\"en-US\\";\\n}\\n.p-0 {\\n    padding: 0;\\n}\\n\\n\\n.w-240 {\\n    width: 60rem;\\n}\\n\\n.antialiased {\\n    -webkit-font-smoothing: antialiased;\\n    -moz-osx-font-smoothing: grayscale;\\n}\\n.pt-10 {\\n    padding-top: 2.5rem;\\n}\\n.mb-15 {\\n    margin-bottom: 3.75rem;\\n}\\n.mx-auto {\\n    margin-left: auto;\\n    margin-right: auto;\\n}\\n\\n.text-black-dark {\\n    --text-opacity: 1;\\n    color: #404040;\\n    color: rgba(64,64,64,var(--text-opacity));\\n}\\n\\n.mr-2 {\\n    margin-right: .5rem;\\n}\\n.leading-tight {\\n    line-height: 1.25;\\n}\\n.text-60 {\\n    font-size: 60px;\\n}\\n.font-light {\\n    font-weight: 300;\\n}\\n.inline-block {\\n    display: inline-block;\\n}\\n\\n.text-15 {\\n    font-size: 15px;\\n}\\n.font-mono {\\n    font-family: monaco,courier,monospace;\\n}\\n.text-gray-600 {\\n    --text-opacity: 1;\\n    color: #999;\\n    color: rgba(153,153,153,var(--text-opacity));\\n}\\n.leading-1\\\\.3 {\\n    line-height: 1.3;\\n}\\n.text-3xl {\\n    font-size: 1.875rem;\\n}\\n\\n.mb-8 {\\n    margin-bottom: 2rem;\\n}\\n\\n.w-1\\\\/2 {\\n    width: 50%;\\n}\\n\\n.mt-6 {\\n    margin-top: 1.5rem;\\n}\\n\\n.mb-4 {\\n    margin-bottom: 1rem;\\n}\\n\\n\\n.font-normal {\\n    font-weight: 400;\\n}\\n\\n#what-happened-section p {\\n    font-size: 15px;\\n    line-height: 1.5;\\n}\\n\\n</style>\\n\\n</head>\\n<body>\\n  <div id=\\"cf-wrapper\\">\\n    <div id=\\"cf-error-details\\" class=\\"p-0\\">\\n      <header class=\\"mx-auto pt-10 lg:pt-6 lg:px-8 w-240 lg:w-full mb-15 antialiased\\">\\n         <h1 class=\\"inline-block md:block mr-2 md:mb-2 font-light text-60 md:text-3xl text-black-dark leading-tight\\">\\n           <span data-translate=\\"error\\">Error</span>\\n           <span>403</span>\\n         </h1>\\n         <span class=\\"inline-block md:block heading-ray-id font-mono text-15 lg:text-sm lg:leading-relaxed\\">您的IP: {client_ip} &bull;</span>\\n         <span class=\\"inline-block md:block heading-ray-id font-mono text-15 lg:text-sm lg:leading-relaxed\\">节点IP: {node_ip}</span>\\n        <h2 class=\\"text-gray-600 leading-1.3 text-3xl lg:text-2xl font-light\\">当前请求已被禁止访问</h2>\\n      </header>\\n\\n      <section class=\\"w-240 lg:w-full mx-auto mb-8 lg:px-8\\">\\n          <div id=\\"what-happened-section\\" class=\\"w-1/2 md:w-full\\">\\n            <h2 class=\\"text-3xl leading-tight font-normal mb-4 text-black-dark antialiased\\" data-translate=\\"what_happened\\">什么问题?</h2>\\n            <p>您的请求被网站管理员禁止访问</p>\\n            \\n          </div>\\n\\n          \\n          <div id=\\"resolution-copy-section\\" class=\\"w-1/2 mt-6 text-15 leading-normal\\">\\n            <h2 class=\\"text-3xl leading-tight font-normal mb-4 text-black-dark antialiased\\" data-translate=\\"what_can_i_do\\">如何解决?</h2>\\n            <p>可以联系网站管理员咨询原因</p>\\n          </div>\\n          \\n      </section>\\n\\n      <div class=\\"cf-error-footer cf-wrapper w-240 lg:w-full py-10 sm:py-4 sm:px-8 mx-auto text-center sm:text-left border-solid border-0 border-t border-gray-300\\">\\n\\n</div><!-- /.error-footer -->\\n\\n\\n    </div><!-- /#cf-error-details -->\\n  </div><!-- /#cf-wrapper -->\\n\\n\\n</body>\\n</html>\\n\\n';

set @p456 = '<!DOCTYPE html>\\n<html>\\n<head>\\n    <meta charset=\\"UTF-8\\">\\n    <meta name=\\"viewport\\" content=\\"width=device-width, initial-scale=1.0\\">\\n    <title>Access Blocked</title>\\n    <style>\\n        body {\\n            margin: 0;\\n            height: 100vh;\\n            display: flex;\\n            align-items: center;\\n            justify-content: center;\\n            background-color: #f5f5f5;\\n            font-family: system-ui, -apple-system, sans-serif;\\n        }\\n        \\n        .container {\\n            text-align: center;\\n            background: white;\\n            padding: 2rem;\\n            border-radius: 8px;\\n            box-shadow: 0 2px 4px rgba(0,0,0,0.1);\\n            max-width: 90%;\\n            width: 500px;\\n        }\\n        \\n        .icon {\\n            font-size: 4rem;\\n            color: #dc2626;\\n            margin-bottom: 1rem;\\n        }\\n        \\n        h1 {\\n            color: #1f2937;\\n            margin-bottom: 1rem;\\n            font-size: 1.5rem;\\n        }\\n        \\n        .ip {\\n            background: #f3f4f6;\\n            padding: 0.5rem 1rem;\\n            border-radius: 4px;\\n            font-family: monospace;\\n            margin: 1rem 0;\\n            display: inline-block;\\n        }\\n        \\n        p {\\n            color: #4b5563;\\n            line-height: 1.6;\\n            margin: 0.5rem 0;\\n        }\\n    </style>\\n</head>\\n<body>\\n    <div class=\\"container\\">\\n        <div class=\\"icon\\">⚠️</div>\\n        <h1 id=\\"title\\"></h1>\\n        <p id=\\"blacklist-notice\\"></p>\\n        <div class=\\"ip\\">{client_ip}</div>\\n        <p id=\\"detail-message\\"></p>\\n    </div>\\n\\n    <script>\\n        const translations = {\\n            en: {\\n                title: \\"Access Blocked\\",\\n                blacklistNotice: \\"Your IP address has been blacklisted\\",\\n                detailMessage: \\"Your access request has been denied due to suspicious activity.\\"\\n            },\\n            zh: {\\n                title: \\"访问已被阻止\\",\\n                blacklistNotice: \\"您的 IP 地址已被列入黑名单\\",\\n                detailMessage: \\"由于检测到可疑活动，您的访问请求已被系统拒绝。\\"\\n            }\\n        };\\n\\n        // 获取浏览器语言\\n        function getBrowserLanguage() {\\n            const language = navigator.language || navigator.userLanguage;\\n            // 简单处理中文和英文，其他语言默认使用英文\\n            return language.toLowerCase().startsWith(\\"zh\\") ? \\"zh\\" : \\"en\\";\\n        }\\n\\n        // 更新页面内容\\n        function updateContent(lang) {\\n            const content = translations[lang];\\n            document.getElementById(\\"title\\").textContent = content.title;\\n            document.getElementById(\\"blacklist-notice\\").textContent = content.blacklistNotice;\\n            document.getElementById(\\"detail-message\\").textContent = content.detailMessage;\\n            document.documentElement.lang = lang;\\n            document.title = content.title;\\n        }\\n\\n        // 初始化页面\\n        updateContent(getBrowserLanguage());\\n    </script>\\n</body>\\n</html>';
set @p502 = '\\n<!DOCTYPE html>\\n<!--[if lt IE 7]> <html class=\\"no-js ie6 oldie\\" lang=\\"en-US\\"> <![endif]-->\\n<!--[if IE 7]>    <html class=\\"no-js ie7 oldie\\" lang=\\"en-US\\"> <![endif]-->\\n<!--[if IE 8]>    <html class=\\"no-js ie8 oldie\\" lang=\\"en-US\\"> <![endif]-->\\n<!--[if gt IE 8]><!--> <html class=\\"no-js\\" lang=\\"en-US\\"> <!--<![endif]-->\\n<head>\\n<title>网站请求出错</title>\\n<meta charset=\\"UTF-8\\" />\\n<meta http-equiv=\\"Content-Type\\" content=\\"text/html; charset=UTF-8\\" />\\n<meta http-equiv=\\"X-UA-Compatible\\" content=\\"IE=Edge,chrome=1\\" />\\n<meta name=\\"robots\\" content=\\"noindex, nofollow\\" />\\n<meta name=\\"viewport\\" content=\\"width=device-width,initial-scale=1\\" />\\n<style>\\n*, body, html {\\n    margin: 0;\\n    padding: 0;\\n}\\n\\nbody, html {\\n    --text-opacity: 1;\\n    color: #404040;\\n    color: rgba(64,64,64,var(--text-opacity));\\n    -webkit-font-smoothing: antialiased;\\n    -moz-osx-font-smoothing: grayscale;\\n    font-family: system-ui,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica Neue,Arial,Noto Sans,sans-serif,Apple Color Emoji,Segoe UI Emoji,Segoe UI Symbol,Noto Color Emoji;\\n    font-size: 16px;\\n}\\n* {\\n    box-sizing: border-box;\\n}\\nhtml[Attributes Style] {\\n    -webkit-locale: \\"en-US\\";\\n}\\n.p-0 {\\n    padding: 0;\\n}\\n\\n\\n.w-240 {\\n    width: 60rem;\\n}\\n\\n.antialiased {\\n    -webkit-font-smoothing: antialiased;\\n    -moz-osx-font-smoothing: grayscale;\\n}\\n.pt-10 {\\n    padding-top: 2.5rem;\\n}\\n.mb-15 {\\n    margin-bottom: 3.75rem;\\n}\\n.mx-auto {\\n    margin-left: auto;\\n    margin-right: auto;\\n}\\n\\n.text-black-dark {\\n    --text-opacity: 1;\\n    color: #404040;\\n    color: rgba(64,64,64,var(--text-opacity));\\n}\\n\\n.mr-2 {\\n    margin-right: .5rem;\\n}\\n.leading-tight {\\n    line-height: 1.25;\\n}\\n.text-60 {\\n    font-size: 60px;\\n}\\n.font-light {\\n    font-weight: 300;\\n}\\n.inline-block {\\n    display: inline-block;\\n}\\n\\n.text-15 {\\n    font-size: 15px;\\n}\\n.font-mono {\\n    font-family: monaco,courier,monospace;\\n}\\n.text-gray-600 {\\n    --text-opacity: 1;\\n    color: #999;\\n    color: rgba(153,153,153,var(--text-opacity));\\n}\\n.leading-1\\\\.3 {\\n    line-height: 1.3;\\n}\\n.text-3xl {\\n    font-size: 1.875rem;\\n}\\n\\n.mb-8 {\\n    margin-bottom: 2rem;\\n}\\n\\n.w-1\\\\/2 {\\n    width: 50%;\\n}\\n\\n.mt-6 {\\n    margin-top: 1.5rem;\\n}\\n\\n.mb-4 {\\n    margin-bottom: 1rem;\\n}\\n\\n\\n.font-normal {\\n    font-weight: 400;\\n}\\n\\n#what-happened-section p {\\n    font-size: 15px;\\n    line-height: 1.5;\\n}\\n\\n</style>\\n\\n</head>\\n<body>\\n  <div id=\\"cf-wrapper\\">\\n    <div id=\\"cf-error-details\\" class=\\"p-0\\">\\n      <header class=\\"mx-auto pt-10 lg:pt-6 lg:px-8 w-240 lg:w-full mb-15 antialiased\\">\\n         <h1 class=\\"inline-block md:block mr-2 md:mb-2 font-light text-60 md:text-3xl text-black-dark leading-tight\\">\\n           <span data-translate=\\"error\\">Error</span>\\n           <span>502</span>\\n         </h1>\\n         <span class=\\"inline-block md:block heading-ray-id font-mono text-15 lg:text-sm lg:leading-relaxed\\">您的IP: {client_ip} &bull;</span>\\n         <span class=\\"inline-block md:block heading-ray-id font-mono text-15 lg:text-sm lg:leading-relaxed\\">节点IP: {node_ip}</span>\\n        <h2 class=\\"text-gray-600 leading-1.3 text-3xl lg:text-2xl font-light\\">回源请求被中断</h2>\\n      </header>\\n\\n      <section class=\\"w-240 lg:w-full mx-auto mb-8 lg:px-8\\">\\n          <div id=\\"what-happened-section\\" class=\\"w-1/2 md:w-full\\">\\n            <h2 class=\\"text-3xl leading-tight font-normal mb-4 text-black-dark antialiased\\" data-translate=\\"what_happened\\">什么问题?</h2>\\n            <p>CDN节点请求源服务器时，请求被源服务器防火墙中断。</p>\\n            \\n          </div>\\n\\n          \\n          <div id=\\"resolution-copy-section\\" class=\\"w-1/2 mt-6 text-15 leading-normal\\">\\n            <h2 class=\\"text-3xl leading-tight font-normal mb-4 text-black-dark antialiased\\" data-translate=\\"what_can_i_do\\">如何解决?</h2>\\n            <p>如果您是网站用户，请稍候重试，或者联系管理员。</p>\\n            <p>如果您是网站管理员，请检查您的源服务器防火墙是否拉黑了CDN的节点，检查CDN网站配置的回源协议和回源端口是否正确。</p>\\n          </div>\\n          \\n      </section>\\n\\n      <div class=\\"cf-error-footer cf-wrapper w-240 lg:w-full py-10 sm:py-4 sm:px-8 mx-auto text-center sm:text-left border-solid border-0 border-t border-gray-300\\">\\n\\n</div><!-- /.error-footer -->\\n\\n\\n    </div><!-- /#cf-error-details -->\\n  </div><!-- /#cf-wrapper -->\\n\\n\\n</body>\\n</html>\\n\\n';

set @p504 = '\\n<!DOCTYPE html>\\n<!--[if lt IE 7]> <html class=\\"no-js ie6 oldie\\" lang=\\"en-US\\"> <![endif]-->\\n<!--[if IE 7]>    <html class=\\"no-js ie7 oldie\\" lang=\\"en-US\\"> <![endif]-->\\n<!--[if IE 8]>    <html class=\\"no-js ie8 oldie\\" lang=\\"en-US\\"> <![endif]-->\\n<!--[if gt IE 8]><!--> <html class=\\"no-js\\" lang=\\"en-US\\"> <!--<![endif]-->\\n<head>\\n<title>网站请求超时</title>\\n<meta charset=\\"UTF-8\\" />\\n<meta http-equiv=\\"Content-Type\\" content=\\"text/html; charset=UTF-8\\" />\\n<meta http-equiv=\\"X-UA-Compatible\\" content=\\"IE=Edge,chrome=1\\" />\\n<meta name=\\"robots\\" content=\\"noindex, nofollow\\" />\\n<meta name=\\"viewport\\" content=\\"width=device-width,initial-scale=1\\" />\\n<style>\\n*, body, html {\\n    margin: 0;\\n    padding: 0;\\n}\\n\\nbody, html {\\n    --text-opacity: 1;\\n    color: #404040;\\n    color: rgba(64,64,64,var(--text-opacity));\\n    -webkit-font-smoothing: antialiased;\\n    -moz-osx-font-smoothing: grayscale;\\n    font-family: system-ui,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica Neue,Arial,Noto Sans,sans-serif,Apple Color Emoji,Segoe UI Emoji,Segoe UI Symbol,Noto Color Emoji;\\n    font-size: 16px;\\n}\\n* {\\n    box-sizing: border-box;\\n}\\nhtml[Attributes Style] {\\n    -webkit-locale: \\"en-US\\";\\n}\\n.p-0 {\\n    padding: 0;\\n}\\n\\n\\n.w-240 {\\n    width: 60rem;\\n}\\n\\n.antialiased {\\n    -webkit-font-smoothing: antialiased;\\n    -moz-osx-font-smoothing: grayscale;\\n}\\n.pt-10 {\\n    padding-top: 2.5rem;\\n}\\n.mb-15 {\\n    margin-bottom: 3.75rem;\\n}\\n.mx-auto {\\n    margin-left: auto;\\n    margin-right: auto;\\n}\\n\\n.text-black-dark {\\n    --text-opacity: 1;\\n    color: #404040;\\n    color: rgba(64,64,64,var(--text-opacity));\\n}\\n\\n.mr-2 {\\n    margin-right: .5rem;\\n}\\n.leading-tight {\\n    line-height: 1.25;\\n}\\n.text-60 {\\n    font-size: 60px;\\n}\\n.font-light {\\n    font-weight: 300;\\n}\\n.inline-block {\\n    display: inline-block;\\n}\\n\\n.text-15 {\\n    font-size: 15px;\\n}\\n.font-mono {\\n    font-family: monaco,courier,monospace;\\n}\\n.text-gray-600 {\\n    --text-opacity: 1;\\n    color: #999;\\n    color: rgba(153,153,153,var(--text-opacity));\\n}\\n.leading-1\\\\.3 {\\n    line-height: 1.3;\\n}\\n.text-3xl {\\n    font-size: 1.875rem;\\n}\\n\\n.mb-8 {\\n    margin-bottom: 2rem;\\n}\\n\\n.w-1\\\\/2 {\\n    width: 50%;\\n}\\n\\n.mt-6 {\\n    margin-top: 1.5rem;\\n}\\n\\n.mb-4 {\\n    margin-bottom: 1rem;\\n}\\n\\n\\n.font-normal {\\n    font-weight: 400;\\n}\\n\\n#what-happened-section p {\\n    font-size: 15px;\\n    line-height: 1.5;\\n}\\n\\n</style>\\n\\n</head>\\n<body>\\n  <div id=\\"cf-wrapper\\">\\n    <div id=\\"cf-error-details\\" class=\\"p-0\\">\\n      <header class=\\"mx-auto pt-10 lg:pt-6 lg:px-8 w-240 lg:w-full mb-15 antialiased\\">\\n         <h1 class=\\"inline-block md:block mr-2 md:mb-2 font-light text-60 md:text-3xl text-black-dark leading-tight\\">\\n           <span data-translate=\\"error\\">Error</span>\\n           <span>504</span>\\n         </h1>\\n         <span class=\\"inline-block md:block heading-ray-id font-mono text-15 lg:text-sm lg:leading-relaxed\\">您的IP: {client_ip} &bull;</span>\\n         <span class=\\"inline-block md:block heading-ray-id font-mono text-15 lg:text-sm lg:leading-relaxed\\">节点IP: {node_ip}</span>\\n        <h2 class=\\"text-gray-600 leading-1.3 text-3xl lg:text-2xl font-light\\">回源请求超时</h2>\\n      </header>\\n\\n      <section class=\\"w-240 lg:w-full mx-auto mb-8 lg:px-8\\">\\n          <div id=\\"what-happened-section\\" class=\\"w-1/2 md:w-full\\">\\n            <h2 class=\\"text-3xl leading-tight font-normal mb-4 text-black-dark antialiased\\" data-translate=\\"what_happened\\">什么问题?</h2>\\n            <p>CDN节点请求源服务器时，等待时间过长。</p>\\n            \\n          </div>\\n\\n          \\n          <div id=\\"resolution-copy-section\\" class=\\"w-1/2 mt-6 text-15 leading-normal\\">\\n            <h2 class=\\"text-3xl leading-tight font-normal mb-4 text-black-dark antialiased\\" data-translate=\\"what_can_i_do\\">如何解决?</h2>\\n            <p>如果您是网站用户，请稍候重试，或者联系管理员。</p>\\n            <p>如果您是网站管理员，请检查您的源服务器防火墙是否拉黑了CDN的节点，检查CDN节点与源服务器之间的链路是否畅通。</p>\\n          </div>\\n          \\n      </section>\\n\\n      <div class=\\"cf-error-footer cf-wrapper w-240 lg:w-full py-10 sm:py-4 sm:px-8 mx-auto text-center sm:text-left border-solid border-0 border-t border-gray-300\\">\\n\\n</div><!-- /.error-footer -->\\n\\n\\n    </div><!-- /#cf-error-details -->\\n  </div><!-- /#cf-wrapper -->\\n\\n\\n</body>\\n</html>\\n\\n';

set @p512 = '\\n<!DOCTYPE html>\\n<!--[if lt IE 7]> <html class=\\"no-js ie6 oldie\\" lang=\\"en-US\\"> <![endif]-->\\n<!--[if IE 7]>    <html class=\\"no-js ie7 oldie\\" lang=\\"en-US\\"> <![endif]-->\\n<!--[if IE 8]>    <html class=\\"no-js ie8 oldie\\" lang=\\"en-US\\"> <![endif]-->\\n<!--[if gt IE 8]><!--> <html class=\\"no-js\\" lang=\\"en-US\\"> <!--<![endif]-->\\n<head>\\n<title>套餐到期</title>\\n<meta charset=\\"UTF-8\\" />\\n<meta http-equiv=\\"Content-Type\\" content=\\"text/html; charset=UTF-8\\" />\\n<meta http-equiv=\\"X-UA-Compatible\\" content=\\"IE=Edge,chrome=1\\" />\\n<meta name=\\"robots\\" content=\\"noindex, nofollow\\" />\\n<meta name=\\"viewport\\" content=\\"width=device-width,initial-scale=1\\" />\\n<style>\\n*, body, html {\\n    margin: 0;\\n    padding: 0;\\n}\\n\\nbody, html {\\n    --text-opacity: 1;\\n    color: #404040;\\n    color: rgba(64,64,64,var(--text-opacity));\\n    -webkit-font-smoothing: antialiased;\\n    -moz-osx-font-smoothing: grayscale;\\n    font-family: system-ui,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica Neue,Arial,Noto Sans,sans-serif,Apple Color Emoji,Segoe UI Emoji,Segoe UI Symbol,Noto Color Emoji;\\n    font-size: 16px;\\n}\\n* {\\n    box-sizing: border-box;\\n}\\nhtml[Attributes Style] {\\n    -webkit-locale: \\"en-US\\";\\n}\\n.p-0 {\\n    padding: 0;\\n}\\n\\n\\n.w-240 {\\n    width: 60rem;\\n}\\n\\n.antialiased {\\n    -webkit-font-smoothing: antialiased;\\n    -moz-osx-font-smoothing: grayscale;\\n}\\n.pt-10 {\\n    padding-top: 2.5rem;\\n}\\n.mb-15 {\\n    margin-bottom: 3.75rem;\\n}\\n.mx-auto {\\n    margin-left: auto;\\n    margin-right: auto;\\n}\\n\\n.text-black-dark {\\n    --text-opacity: 1;\\n    color: #404040;\\n    color: rgba(64,64,64,var(--text-opacity));\\n}\\n\\n.mr-2 {\\n    margin-right: .5rem;\\n}\\n.leading-tight {\\n    line-height: 1.25;\\n}\\n.text-60 {\\n    font-size: 60px;\\n}\\n.font-light {\\n    font-weight: 300;\\n}\\n.inline-block {\\n    display: inline-block;\\n}\\n\\n.text-15 {\\n    font-size: 15px;\\n}\\n.font-mono {\\n    font-family: monaco,courier,monospace;\\n}\\n.text-gray-600 {\\n    --text-opacity: 1;\\n    color: #999;\\n    color: rgba(153,153,153,var(--text-opacity));\\n}\\n.leading-1\\\\.3 {\\n    line-height: 1.3;\\n}\\n.text-3xl {\\n    font-size: 1.875rem;\\n}\\n\\n.mb-8 {\\n    margin-bottom: 2rem;\\n}\\n\\n.w-1\\\\/2 {\\n    width: 50%;\\n}\\n\\n.mt-6 {\\n    margin-top: 1.5rem;\\n}\\n\\n.mb-4 {\\n    margin-bottom: 1rem;\\n}\\n\\n\\n.font-normal {\\n    font-weight: 400;\\n}\\n\\n#what-happened-section p {\\n    font-size: 15px;\\n    line-height: 1.5;\\n}\\n\\n</style>\\n\\n</head>\\n<body>\\n  <div id=\\"cf-wrapper\\">\\n    <div id=\\"cf-error-details\\" class=\\"p-0\\">\\n      <header class=\\"mx-auto pt-10 lg:pt-6 lg:px-8 w-240 lg:w-full mb-15 antialiased\\">\\n         <h1 class=\\"inline-block md:block mr-2 md:mb-2 font-light text-60 md:text-3xl text-black-dark leading-tight\\">\\n           <span data-translate=\\"error\\">Error</span>\\n           <span>512</span>\\n         </h1>\\n         <span class=\\"inline-block md:block heading-ray-id font-mono text-15 lg:text-sm lg:leading-relaxed\\">您的IP: {client_ip} &bull;</span>\\n         <span class=\\"inline-block md:block heading-ray-id font-mono text-15 lg:text-sm lg:leading-relaxed\\">节点IP: {node_ip}</span>\\n        <h2 class=\\"text-gray-600 leading-1.3 text-3xl lg:text-2xl font-light\\">套餐到期</h2>\\n      </header>\\n\\n      <section class=\\"w-240 lg:w-full mx-auto mb-8 lg:px-8\\">\\n          <div id=\\"what-happened-section\\" class=\\"w-1/2 md:w-full\\">\\n            <h2 class=\\"text-3xl leading-tight font-normal mb-4 text-black-dark antialiased\\" data-translate=\\"what_happened\\">什么问题?</h2>\\n            <p>您网站使用的套餐已到期。</p>\\n            \\n          </div>\\n\\n          \\n          <div id=\\"resolution-copy-section\\" class=\\"w-1/2 mt-6 text-15 leading-normal\\">\\n            <h2 class=\\"text-3xl leading-tight font-normal mb-4 text-black-dark antialiased\\" data-translate=\\"what_can_i_do\\">如何解决?</h2>\\n            <p>请登录CDN后台续费套餐恢复。</p>\\n          </div>\\n          \\n      </section>\\n\\n      <div class=\\"cf-error-footer cf-wrapper w-240 lg:w-full py-10 sm:py-4 sm:px-8 mx-auto text-center sm:text-left border-solid border-0 border-t border-gray-300\\">\\n\\n</div><!-- /.error-footer -->\\n\\n\\n    </div><!-- /#cf-error-details -->\\n  </div><!-- /#cf-wrapper -->\\n\\n\\n</body>\\n</html>\\n\\n';

set @p513 = '\\n<!DOCTYPE html>\\n<!--[if lt IE 7]> <html class=\\"no-js ie6 oldie\\" lang=\\"en-US\\"> <![endif]-->\\n<!--[if IE 7]>    <html class=\\"no-js ie7 oldie\\" lang=\\"en-US\\"> <![endif]-->\\n<!--[if IE 8]>    <html class=\\"no-js ie8 oldie\\" lang=\\"en-US\\"> <![endif]-->\\n<!--[if gt IE 8]><!--> <html class=\\"no-js\\" lang=\\"en-US\\"> <!--<![endif]-->\\n<head>\\n<title>流量超限</title>\\n<meta charset=\\"UTF-8\\" />\\n<meta http-equiv=\\"Content-Type\\" content=\\"text/html; charset=UTF-8\\" />\\n<meta http-equiv=\\"X-UA-Compatible\\" content=\\"IE=Edge,chrome=1\\" />\\n<meta name=\\"robots\\" content=\\"noindex, nofollow\\" />\\n<meta name=\\"viewport\\" content=\\"width=device-width,initial-scale=1\\" />\\n<style>\\n*, body, html {\\n    margin: 0;\\n    padding: 0;\\n}\\n\\nbody, html {\\n    --text-opacity: 1;\\n    color: #404040;\\n    color: rgba(64,64,64,var(--text-opacity));\\n    -webkit-font-smoothing: antialiased;\\n    -moz-osx-font-smoothing: grayscale;\\n    font-family: system-ui,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica Neue,Arial,Noto Sans,sans-serif,Apple Color Emoji,Segoe UI Emoji,Segoe UI Symbol,Noto Color Emoji;\\n    font-size: 16px;\\n}\\n* {\\n    box-sizing: border-box;\\n}\\nhtml[Attributes Style] {\\n    -webkit-locale: \\"en-US\\";\\n}\\n.p-0 {\\n    padding: 0;\\n}\\n\\n\\n.w-240 {\\n    width: 60rem;\\n}\\n\\n.antialiased {\\n    -webkit-font-smoothing: antialiased;\\n    -moz-osx-font-smoothing: grayscale;\\n}\\n.pt-10 {\\n    padding-top: 2.5rem;\\n}\\n.mb-15 {\\n    margin-bottom: 3.75rem;\\n}\\n.mx-auto {\\n    margin-left: auto;\\n    margin-right: auto;\\n}\\n\\n.text-black-dark {\\n    --text-opacity: 1;\\n    color: #404040;\\n    color: rgba(64,64,64,var(--text-opacity));\\n}\\n\\n.mr-2 {\\n    margin-right: .5rem;\\n}\\n.leading-tight {\\n    line-height: 1.25;\\n}\\n.text-60 {\\n    font-size: 60px;\\n}\\n.font-light {\\n    font-weight: 300;\\n}\\n.inline-block {\\n    display: inline-block;\\n}\\n\\n.text-15 {\\n    font-size: 15px;\\n}\\n.font-mono {\\n    font-family: monaco,courier,monospace;\\n}\\n.text-gray-600 {\\n    --text-opacity: 1;\\n    color: #999;\\n    color: rgba(153,153,153,var(--text-opacity));\\n}\\n.leading-1\\\\.3 {\\n    line-height: 1.3;\\n}\\n.text-3xl {\\n    font-size: 1.875rem;\\n}\\n\\n.mb-8 {\\n    margin-bottom: 2rem;\\n}\\n\\n.w-1\\\\/2 {\\n    width: 50%;\\n}\\n\\n.mt-6 {\\n    margin-top: 1.5rem;\\n}\\n\\n.mb-4 {\\n    margin-bottom: 1rem;\\n}\\n\\n\\n.font-normal {\\n    font-weight: 400;\\n}\\n\\n#what-happened-section p {\\n    font-size: 15px;\\n    line-height: 1.5;\\n}\\n\\n</style>\\n\\n</head>\\n<body>\\n  <div id=\\"cf-wrapper\\">\\n    <div id=\\"cf-error-details\\" class=\\"p-0\\">\\n      <header class=\\"mx-auto pt-10 lg:pt-6 lg:px-8 w-240 lg:w-full mb-15 antialiased\\">\\n         <h1 class=\\"inline-block md:block mr-2 md:mb-2 font-light text-60 md:text-3xl text-black-dark leading-tight\\">\\n           <span data-translate=\\"error\\">Error</span>\\n           <span>513</span>\\n         </h1>\\n         <span class=\\"inline-block md:block heading-ray-id font-mono text-15 lg:text-sm lg:leading-relaxed\\">您的IP: {client_ip} &bull;</span>\\n         <span class=\\"inline-block md:block heading-ray-id font-mono text-15 lg:text-sm lg:leading-relaxed\\">节点IP: {node_ip}</span>\\n        <h2 class=\\"text-gray-600 leading-1.3 text-3xl lg:text-2xl font-light\\">流量超限</h2>\\n      </header>\\n\\n      <section class=\\"w-240 lg:w-full mx-auto mb-8 lg:px-8\\">\\n          <div id=\\"what-happened-section\\" class=\\"w-1/2 md:w-full\\">\\n            <h2 class=\\"text-3xl leading-tight font-normal mb-4 text-black-dark antialiased\\" data-translate=\\"what_happened\\">什么问题?</h2>\\n            <p>您网站使用的套餐流量已用完。</p>\\n            \\n          </div>\\n\\n          \\n          <div id=\\"resolution-copy-section\\" class=\\"w-1/2 mt-6 text-15 leading-normal\\">\\n            <h2 class=\\"text-3xl leading-tight font-normal mb-4 text-black-dark antialiased\\" data-translate=\\"what_can_i_do\\">如何解决?</h2>\\n            <p>请登录CDN后台升级流量恢复。</p>\\n          </div>\\n          \\n      </section>\\n\\n      <div class=\\"cf-error-footer cf-wrapper w-240 lg:w-full py-10 sm:py-4 sm:px-8 mx-auto text-center sm:text-left border-solid border-0 border-t border-gray-300\\">\\n\\n</div><!-- /.error-footer -->\\n\\n\\n    </div><!-- /#cf-error-details -->\\n  </div><!-- /#cf-wrapper -->\\n\\n\\n</body>\\n</html>\\n\\n';

set @p514 = '\\n<!DOCTYPE html>\\n<!--[if lt IE 7]> <html class=\\"no-js ie6 oldie\\" lang=\\"en-US\\"> <![endif]-->\\n<!--[if IE 7]>    <html class=\\"no-js ie7 oldie\\" lang=\\"en-US\\"> <![endif]-->\\n<!--[if IE 8]>    <html class=\\"no-js ie8 oldie\\" lang=\\"en-US\\"> <![endif]-->\\n<!--[if gt IE 8]><!--> <html class=\\"no-js\\" lang=\\"en-US\\"> <!--<![endif]-->\\n<head>\\n<title>网站被锁定</title>\\n<meta charset=\\"UTF-8\\" />\\n<meta http-equiv=\\"Content-Type\\" content=\\"text/html; charset=UTF-8\\" />\\n<meta http-equiv=\\"X-UA-Compatible\\" content=\\"IE=Edge,chrome=1\\" />\\n<meta name=\\"robots\\" content=\\"noindex, nofollow\\" />\\n<meta name=\\"viewport\\" content=\\"width=device-width,initial-scale=1\\" />\\n<style>\\n*, body, html {\\n    margin: 0;\\n    padding: 0;\\n}\\n\\nbody, html {\\n    --text-opacity: 1;\\n    color: #404040;\\n    color: rgba(64,64,64,var(--text-opacity));\\n    -webkit-font-smoothing: antialiased;\\n    -moz-osx-font-smoothing: grayscale;\\n    font-family: system-ui,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica Neue,Arial,Noto Sans,sans-serif,Apple Color Emoji,Segoe UI Emoji,Segoe UI Symbol,Noto Color Emoji;\\n    font-size: 16px;\\n}\\n* {\\n    box-sizing: border-box;\\n}\\nhtml[Attributes Style] {\\n    -webkit-locale: \\"en-US\\";\\n}\\n.p-0 {\\n    padding: 0;\\n}\\n\\n\\n.w-240 {\\n    width: 60rem;\\n}\\n\\n.antialiased {\\n    -webkit-font-smoothing: antialiased;\\n    -moz-osx-font-smoothing: grayscale;\\n}\\n.pt-10 {\\n    padding-top: 2.5rem;\\n}\\n.mb-15 {\\n    margin-bottom: 3.75rem;\\n}\\n.mx-auto {\\n    margin-left: auto;\\n    margin-right: auto;\\n}\\n\\n.text-black-dark {\\n    --text-opacity: 1;\\n    color: #404040;\\n    color: rgba(64,64,64,var(--text-opacity));\\n}\\n\\n.mr-2 {\\n    margin-right: .5rem;\\n}\\n.leading-tight {\\n    line-height: 1.25;\\n}\\n.text-60 {\\n    font-size: 60px;\\n}\\n.font-light {\\n    font-weight: 300;\\n}\\n.inline-block {\\n    display: inline-block;\\n}\\n\\n.text-15 {\\n    font-size: 15px;\\n}\\n.font-mono {\\n    font-family: monaco,courier,monospace;\\n}\\n.text-gray-600 {\\n    --text-opacity: 1;\\n    color: #999;\\n    color: rgba(153,153,153,var(--text-opacity));\\n}\\n.leading-1\\\\.3 {\\n    line-height: 1.3;\\n}\\n.text-3xl {\\n    font-size: 1.875rem;\\n}\\n\\n.mb-8 {\\n    margin-bottom: 2rem;\\n}\\n\\n.w-1\\\\/2 {\\n    width: 50%;\\n}\\n\\n.mt-6 {\\n    margin-top: 1.5rem;\\n}\\n\\n.mb-4 {\\n    margin-bottom: 1rem;\\n}\\n\\n\\n.font-normal {\\n    font-weight: 400;\\n}\\n\\n#what-happened-section p {\\n    font-size: 15px;\\n    line-height: 1.5;\\n}\\n\\n</style>\\n\\n</head>\\n<body>\\n  <div id=\\"cf-wrapper\\">\\n    <div id=\\"cf-error-details\\" class=\\"p-0\\">\\n      <header class=\\"mx-auto pt-10 lg:pt-6 lg:px-8 w-240 lg:w-full mb-15 antialiased\\">\\n         <h1 class=\\"inline-block md:block mr-2 md:mb-2 font-light text-60 md:text-3xl text-black-dark leading-tight\\">\\n           <span data-translate=\\"error\\">Error</span>\\n           <span>514</span>\\n         </h1>\\n         <span class=\\"inline-block md:block heading-ray-id font-mono text-15 lg:text-sm lg:leading-relaxed\\">您的IP: {client_ip} &bull;</span>\\n         <span class=\\"inline-block md:block heading-ray-id font-mono text-15 lg:text-sm lg:leading-relaxed\\">节点IP: {node_ip}</span>\\n        <h2 class=\\"text-gray-600 leading-1.3 text-3xl lg:text-2xl font-light\\">网站被锁定</h2>\\n      </header>\\n\\n      <section class=\\"w-240 lg:w-full mx-auto mb-8 lg:px-8\\">\\n          <div id=\\"what-happened-section\\" class=\\"w-1/2 md:w-full\\">\\n            <h2 class=\\"text-3xl leading-tight font-normal mb-4 text-black-dark antialiased\\" data-translate=\\"what_happened\\">什么问题?</h2>\\n            <p>您的网站已被管理员锁定。</p>\\n            \\n          </div>\\n\\n          \\n          <div id=\\"resolution-copy-section\\" class=\\"w-1/2 mt-6 text-15 leading-normal\\">\\n            <h2 class=\\"text-3xl leading-tight font-normal mb-4 text-black-dark antialiased\\" data-translate=\\"what_can_i_do\\">如何解决?</h2>\\n            <p>请联系管理员。</p>\\n          </div>\\n          \\n      </section>\\n\\n      <div class=\\"cf-error-footer cf-wrapper w-240 lg:w-full py-10 sm:py-4 sm:px-8 mx-auto text-center sm:text-left border-solid border-0 border-t border-gray-300\\">\\n\\n</div><!-- /.error-footer -->\\n\\n\\n    </div><!-- /#cf-error-details -->\\n  </div><!-- /#cf-wrapper -->\\n\\n\\n</body>\\n</html>\\n\\n';

set @p515 = '\\n<!DOCTYPE html>\\n<!--[if lt IE 7]> <html class=\\"no-js ie6 oldie\\" lang=\\"en-US\\"> <![endif]-->\\n<!--[if IE 7]>    <html class=\\"no-js ie7 oldie\\" lang=\\"en-US\\"> <![endif]-->\\n<!--[if IE 8]>    <html class=\\"no-js ie8 oldie\\" lang=\\"en-US\\"> <![endif]-->\\n<!--[if gt IE 8]><!--> <html class=\\"no-js\\" lang=\\"en-US\\"> <!--<![endif]-->\\n<head>\\n<title>套餐连接数超限</title>\\n<meta charset=\\"UTF-8\\" />\\n<meta http-equiv=\\"Content-Type\\" content=\\"text/html; charset=UTF-8\\" />\\n<meta http-equiv=\\"X-UA-Compatible\\" content=\\"IE=Edge,chrome=1\\" />\\n<meta name=\\"robots\\" content=\\"noindex, nofollow\\" />\\n<meta name=\\"viewport\\" content=\\"width=device-width,initial-scale=1\\" />\\n<style>\\n*, body, html {\\n    margin: 0;\\n    padding: 0;\\n}\\n\\nbody, html {\\n    --text-opacity: 1;\\n    color: #404040;\\n    color: rgba(64,64,64,var(--text-opacity));\\n    -webkit-font-smoothing: antialiased;\\n    -moz-osx-font-smoothing: grayscale;\\n    font-family: system-ui,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica Neue,Arial,Noto Sans,sans-serif,Apple Color Emoji,Segoe UI Emoji,Segoe UI Symbol,Noto Color Emoji;\\n    font-size: 16px;\\n}\\n* {\\n    box-sizing: border-box;\\n}\\nhtml[Attributes Style] {\\n    -webkit-locale: \\"en-US\\";\\n}\\n.p-0 {\\n    padding: 0;\\n}\\n\\n\\n.w-240 {\\n    width: 60rem;\\n}\\n\\n.antialiased {\\n    -webkit-font-smoothing: antialiased;\\n    -moz-osx-font-smoothing: grayscale;\\n}\\n.pt-10 {\\n    padding-top: 2.5rem;\\n}\\n.mb-15 {\\n    margin-bottom: 3.75rem;\\n}\\n.mx-auto {\\n    margin-left: auto;\\n    margin-right: auto;\\n}\\n\\n.text-black-dark {\\n    --text-opacity: 1;\\n    color: #404040;\\n    color: rgba(64,64,64,var(--text-opacity));\\n}\\n\\n.mr-2 {\\n    margin-right: .5rem;\\n}\\n.leading-tight {\\n    line-height: 1.25;\\n}\\n.text-60 {\\n    font-size: 60px;\\n}\\n.font-light {\\n    font-weight: 300;\\n}\\n.inline-block {\\n    display: inline-block;\\n}\\n\\n.text-15 {\\n    font-size: 15px;\\n}\\n.font-mono {\\n    font-family: monaco,courier,monospace;\\n}\\n.text-gray-600 {\\n    --text-opacity: 1;\\n    color: #999;\\n    color: rgba(153,153,153,var(--text-opacity));\\n}\\n.leading-1\\\\.3 {\\n    line-height: 1.3;\\n}\\n.text-3xl {\\n    font-size: 1.875rem;\\n}\\n\\n.mb-8 {\\n    margin-bottom: 2rem;\\n}\\n\\n.w-1\\\\/2 {\\n    width: 50%;\\n}\\n\\n.mt-6 {\\n    margin-top: 1.5rem;\\n}\\n\\n.mb-4 {\\n    margin-bottom: 1rem;\\n}\\n\\n\\n.font-normal {\\n    font-weight: 400;\\n}\\n\\n#what-happened-section p {\\n    font-size: 15px;\\n    line-height: 1.5;\\n}\\n\\n</style>\\n\\n</head>\\n<body>\\n  <div id=\\"cf-wrapper\\">\\n    <div id=\\"cf-error-details\\" class=\\"p-0\\">\\n      <header class=\\"mx-auto pt-10 lg:pt-6 lg:px-8 w-240 lg:w-full mb-15 antialiased\\">\\n         <h1 class=\\"inline-block md:block mr-2 md:mb-2 font-light text-60 md:text-3xl text-black-dark leading-tight\\">\\n           <span data-translate=\\"error\\">Error</span>\\n           <span>515</span>\\n         </h1>\\n         <span class=\\"inline-block md:block heading-ray-id font-mono text-15 lg:text-sm lg:leading-relaxed\\">您的IP: {client_ip} &bull;</span>\\n         <span class=\\"inline-block md:block heading-ray-id font-mono text-15 lg:text-sm lg:leading-relaxed\\">节点IP: {node_ip}</span>\\n        <h2 class=\\"text-gray-600 leading-1.3 text-3xl lg:text-2xl font-light\\">套餐连接数超限</h2>\\n      </header>\\n\\n      <section class=\\"w-240 lg:w-full mx-auto mb-8 lg:px-8\\">\\n          <div id=\\"what-happened-section\\" class=\\"w-1/2 md:w-full\\">\\n            <h2 class=\\"text-3xl leading-tight font-normal mb-4 text-black-dark antialiased\\" data-translate=\\"what_happened\\">什么问题?</h2>\\n            <p>您的套餐连接数超限。</p>\\n            \\n          </div>\\n\\n          \\n          <div id=\\"resolution-copy-section\\" class=\\"w-1/2 mt-6 text-15 leading-normal\\">\\n            <h2 class=\\"text-3xl leading-tight font-normal mb-4 text-black-dark antialiased\\" data-translate=\\"what_can_i_do\\">如何解决?</h2>\\n            <p>请联系管理员。</p>\\n          </div>\\n          \\n      </section>\\n\\n      <div class=\\"cf-error-footer cf-wrapper w-240 lg:w-full py-10 sm:py-4 sm:px-8 mx-auto text-center sm:text-left border-solid border-0 border-t border-gray-300\\">\\n\\n</div><!-- /.error-footer -->\\n\\n\\n    </div><!-- /#cf-error-details -->\\n  </div><!-- /#cf-wrapper -->\\n\\n\\n</body>\\n</html>\\n\\n';

set @host_not_found = '\\n<!DOCTYPE html>\\n<!--[if lt IE 7]> <html class=\\"no-js ie6 oldie\\" lang=\\"en-US\\"> <![endif]-->\\n<!--[if IE 7]>    <html class=\\"no-js ie7 oldie\\" lang=\\"en-US\\"> <![endif]-->\\n<!--[if IE 8]>    <html class=\\"no-js ie8 oldie\\" lang=\\"en-US\\"> <![endif]-->\\n<!--[if gt IE 8]><!--> <html class=\\"no-js\\" lang=\\"en-US\\"> <!--<![endif]-->\\n<head>\\n<title>域名未配置</title>\\n<meta charset=\\"UTF-8\\" />\\n<meta http-equiv=\\"Content-Type\\" content=\\"text/html; charset=UTF-8\\" />\\n<meta http-equiv=\\"X-UA-Compatible\\" content=\\"IE=Edge,chrome=1\\" />\\n<meta name=\\"robots\\" content=\\"noindex, nofollow\\" />\\n<meta name=\\"viewport\\" content=\\"width=device-width,initial-scale=1\\" />\\n<style>\\n*, body, html {\\n    margin: 0;\\n    padding: 0;\\n}\\n\\nbody, html {\\n    --text-opacity: 1;\\n    color: #404040;\\n    color: rgba(64,64,64,var(--text-opacity));\\n    -webkit-font-smoothing: antialiased;\\n    -moz-osx-font-smoothing: grayscale;\\n    font-family: system-ui,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica Neue,Arial,Noto Sans,sans-serif,Apple Color Emoji,Segoe UI Emoji,Segoe UI Symbol,Noto Color Emoji;\\n    font-size: 16px;\\n}\\n* {\\n    box-sizing: border-box;\\n}\\nhtml[Attributes Style] {\\n    -webkit-locale: \\"en-US\\";\\n}\\n.p-0 {\\n    padding: 0;\\n}\\n\\n\\n.w-240 {\\n    width: 60rem;\\n}\\n\\n.antialiased {\\n    -webkit-font-smoothing: antialiased;\\n    -moz-osx-font-smoothing: grayscale;\\n}\\n.pt-10 {\\n    padding-top: 2.5rem;\\n}\\n.mb-15 {\\n    margin-bottom: 3.75rem;\\n}\\n.mx-auto {\\n    margin-left: auto;\\n    margin-right: auto;\\n}\\n\\n.text-black-dark {\\n    --text-opacity: 1;\\n    color: #404040;\\n    color: rgba(64,64,64,var(--text-opacity));\\n}\\n\\n.mr-2 {\\n    margin-right: .5rem;\\n}\\n.leading-tight {\\n    line-height: 1.25;\\n}\\n.text-60 {\\n    font-size: 60px;\\n}\\n.font-light {\\n    font-weight: 300;\\n}\\n.inline-block {\\n    display: inline-block;\\n}\\n\\n.text-15 {\\n    font-size: 15px;\\n}\\n.font-mono {\\n    font-family: monaco,courier,monospace;\\n}\\n.text-gray-600 {\\n    --text-opacity: 1;\\n    color: #999;\\n    color: rgba(153,153,153,var(--text-opacity));\\n}\\n.leading-1\\\\.3 {\\n    line-height: 1.3;\\n}\\n.text-3xl {\\n    font-size: 1.875rem;\\n}\\n\\n.mb-8 {\\n    margin-bottom: 2rem;\\n}\\n\\n.w-1\\\\/2 {\\n    width: 50%;\\n}\\n\\n.mt-6 {\\n    margin-top: 1.5rem;\\n}\\n\\n.mb-4 {\\n    margin-bottom: 1rem;\\n}\\n\\n\\n.font-normal {\\n    font-weight: 400;\\n}\\n\\n#what-happened-section p {\\n    font-size: 15px;\\n    line-height: 1.5;\\n}\\n\\n</style>\\n\\n</head>\\n<body>\\n  <div id=\\"cf-wrapper\\">\\n    <div id=\\"cf-error-details\\" class=\\"p-0\\">\\n      <header class=\\"mx-auto pt-10 lg:pt-6 lg:px-8 w-240 lg:w-full mb-15 antialiased\\">\\n         <h1 class=\\"inline-block md:block mr-2 md:mb-2 font-light text-60 md:text-3xl text-black-dark leading-tight\\">\\n           <span data-translate=\\"error\\">Error</span>\\n           <span>530</span>\\n         </h1>\\n         <span class=\\"inline-block md:block heading-ray-id font-mono text-15 lg:text-sm lg:leading-relaxed\\">您的IP: {client_ip} &bull;</span>\\n         <span class=\\"inline-block md:block heading-ray-id font-mono text-15 lg:text-sm lg:leading-relaxed\\">节点IP: {node_ip}</span>\\n        <h2 class=\\"text-gray-600 leading-1.3 text-3xl lg:text-2xl font-light\\">域名未配置</h2>\\n      </header>\\n\\n      <section class=\\"w-240 lg:w-full mx-auto mb-8 lg:px-8\\">\\n          <div id=\\"what-happened-section\\" class=\\"w-1/2 md:w-full\\">\\n            <h2 class=\\"text-3xl leading-tight font-normal mb-4 text-black-dark antialiased\\" data-translate=\\"what_happened\\">什么问题?</h2>\\n            <p>您的域名指向了CDN节点，但配置未生效或者未在CDN配置此域名。</p>\\n            \\n          </div>\\n\\n          \\n          <div id=\\"resolution-copy-section\\" class=\\"w-1/2 mt-6 text-15 leading-normal\\">\\n            <h2 class=\\"text-3xl leading-tight font-normal mb-4 text-black-dark antialiased\\" data-translate=\\"what_can_i_do\\">如何解决?</h2>\\n            <p>请到CDN后台添加此域名，或联系管理员处理。</p>\\n          </div>\\n          \\n      </section>\\n\\n      <div class=\\"cf-error-footer cf-wrapper w-240 lg:w-full py-10 sm:py-4 sm:px-8 mx-auto text-center sm:text-left border-solid border-0 border-t border-gray-300\\">\\n\\n</div><!-- /.error-footer -->\\n\\n\\n    </div><!-- /#cf-error-details -->\\n  </div><!-- /#cf-wrapper -->\\n\\n\\n</body>\\n</html>\\n\\n';

set @access_ip_not_allow = '\\n<!DOCTYPE html>\\n<!--[if lt IE 7]> <html class=\\"no-js ie6 oldie\\" lang=\\"en-US\\"> <![endif]-->\\n<!--[if IE 7]>    <html class=\\"no-js ie7 oldie\\" lang=\\"en-US\\"> <![endif]-->\\n<!--[if IE 8]>    <html class=\\"no-js ie8 oldie\\" lang=\\"en-US\\"> <![endif]-->\\n<!--[if gt IE 8]><!--> <html class=\\"no-js\\" lang=\\"en-US\\"> <!--<![endif]-->\\n<head>\\n<title>请使用域名访问</title>\\n<meta charset=\\"UTF-8\\" />\\n<meta http-equiv=\\"Content-Type\\" content=\\"text/html; charset=UTF-8\\" />\\n<meta http-equiv=\\"X-UA-Compatible\\" content=\\"IE=Edge,chrome=1\\" />\\n<meta name=\\"robots\\" content=\\"noindex, nofollow\\" />\\n<meta name=\\"viewport\\" content=\\"width=device-width,initial-scale=1\\" />\\n<style>\\n*, body, html {\\n    margin: 0;\\n    padding: 0;\\n}\\n\\nbody, html {\\n    --text-opacity: 1;\\n    color: #404040;\\n    color: rgba(64,64,64,var(--text-opacity));\\n    -webkit-font-smoothing: antialiased;\\n    -moz-osx-font-smoothing: grayscale;\\n    font-family: system-ui,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica Neue,Arial,Noto Sans,sans-serif,Apple Color Emoji,Segoe UI Emoji,Segoe UI Symbol,Noto Color Emoji;\\n    font-size: 16px;\\n}\\n* {\\n    box-sizing: border-box;\\n}\\nhtml[Attributes Style] {\\n    -webkit-locale: \\"en-US\\";\\n}\\n.p-0 {\\n    padding: 0;\\n}\\n\\n\\n.w-240 {\\n    width: 60rem;\\n}\\n\\n.antialiased {\\n    -webkit-font-smoothing: antialiased;\\n    -moz-osx-font-smoothing: grayscale;\\n}\\n.pt-10 {\\n    padding-top: 2.5rem;\\n}\\n.mb-15 {\\n    margin-bottom: 3.75rem;\\n}\\n.mx-auto {\\n    margin-left: auto;\\n    margin-right: auto;\\n}\\n\\n.text-black-dark {\\n    --text-opacity: 1;\\n    color: #404040;\\n    color: rgba(64,64,64,var(--text-opacity));\\n}\\n\\n.mr-2 {\\n    margin-right: .5rem;\\n}\\n.leading-tight {\\n    line-height: 1.25;\\n}\\n.text-60 {\\n    font-size: 60px;\\n}\\n.font-light {\\n    font-weight: 300;\\n}\\n.inline-block {\\n    display: inline-block;\\n}\\n\\n.text-15 {\\n    font-size: 15px;\\n}\\n.font-mono {\\n    font-family: monaco,courier,monospace;\\n}\\n.text-gray-600 {\\n    --text-opacity: 1;\\n    color: #999;\\n    color: rgba(153,153,153,var(--text-opacity));\\n}\\n.leading-1\\\\.3 {\\n    line-height: 1.3;\\n}\\n.text-3xl {\\n    font-size: 1.875rem;\\n}\\n\\n.mb-8 {\\n    margin-bottom: 2rem;\\n}\\n\\n.w-1\\\\/2 {\\n    width: 50%;\\n}\\n\\n.mt-6 {\\n    margin-top: 1.5rem;\\n}\\n\\n.mb-4 {\\n    margin-bottom: 1rem;\\n}\\n\\n\\n.font-normal {\\n    font-weight: 400;\\n}\\n\\n#what-happened-section p {\\n    font-size: 15px;\\n    line-height: 1.5;\\n}\\n\\n</style>\\n\\n</head>\\n<body>\\n  <div id=\\"cf-wrapper\\">\\n    <div id=\\"cf-error-details\\" class=\\"p-0\\">\\n      <header class=\\"mx-auto pt-10 lg:pt-6 lg:px-8 w-240 lg:w-full mb-15 antialiased\\">\\n         <h1 class=\\"inline-block md:block mr-2 md:mb-2 font-light text-60 md:text-3xl text-black-dark leading-tight\\">\\n           <span data-translate=\\"error\\">Error</span>\\n           <span>1003</span>\\n         </h1>\\n        <h2 class=\\"text-gray-600 leading-1.3 text-3xl lg:text-2xl font-light\\">请使用域名访问</h2>\\n      </header>\\n\\n      <section class=\\"w-240 lg:w-full mx-auto mb-8 lg:px-8\\">\\n          <div id=\\"what-happened-section\\" class=\\"w-1/2 md:w-full\\">\\n            <h2 class=\\"text-3xl leading-tight font-normal mb-4 text-black-dark antialiased\\" data-translate=\\"what_happened\\">什么问题?</h2>\\n            <p>当前是直接访问的节点IP。</p>\\n            \\n          </div>\\n\\n          \\n          <div id=\\"resolution-copy-section\\" class=\\"w-1/2 mt-6 text-15 leading-normal\\">\\n            <h2 class=\\"text-3xl leading-tight font-normal mb-4 text-black-dark antialiased\\" data-translate=\\"what_can_i_do\\">如何解决?</h2>\\n            <p>请使用域名访问。</p>\\n          </div>\\n          \\n      </section>\\n\\n      <div class=\\"cf-error-footer cf-wrapper w-240 lg:w-full py-10 sm:py-4 sm:px-8 mx-auto text-center sm:text-left border-solid border-0 border-t border-gray-300\\">\\n\\n</div><!-- /.error-footer -->\\n\\n\\n    </div><!-- /#cf-error-details -->\\n  </div><!-- /#cf-wrapper -->\\n\\n\\n</body>\\n</html>\\n\\n';


insert into config values ('error-page',concat('{"p456":"',@p456,'","p400":"',@p400,'","p403":"',@p403,'","p502":"',@p502,'","p504":"',@p504,'","p512":"',@p512,'","p513":"',@p513,'","p514":"',@p514,'","p515":"',@p515,'","host_not_found":"',@host_not_found,'","access_ip_not_allow":"',@access_ip_not_allow,'"}'),'error_page','0','global', now(),now(),1,null);   

# user package config
insert into config values ('user-package-config','','user_package_config','0','global', now(),now(),1,null);


# site default config
insert into config values ('http_listen-port','80','site_default_config','0','global', now(),now(),1,null); 
insert into config values ('https_listen-port','443','site_default_config','0','global', now(),now(),1,null);     
insert into config values ('https_listen-hsts','0','site_default_config','0','global', now(),now(),1,null); 
insert into config values ('https_listen-http2','0','site_default_config','0','global', now(),now(),1,null); 
insert into config values ('https_listen-http3','0','site_default_config','0','global', now(),now(),1,null); 


insert into config values ('https_listen-force_ssl_enable','0','site_default_config','0','global', now(),now(),1,null); 
insert into config values ('https_listen-ssl_protocols','TLSv1 TLSv1.1 TLSv1.2 TLSv1.3','site_default_config','0','global', now(),now(),1,null); 
insert into config values ('https_listen-ssl_ciphers','ECDHE-ECDSA-AES128-GCM-SHA256:ECDHE-RSA-AES128-GCM-SHA256:ECDHE-ECDSA-AES256-GCM-SHA384:ECDHE-RSA-AES256-GCM-SHA384:ECDHE-ECDSA-CHACHA20-POLY1305:ECDHE-RSA-CHACHA20-POLY1305:DHE-RSA-AES128-GCM-SHA256:DHE-RSA-AES256-GCM-SHA384:DHE-RSA-CHACHA20-POLY1305:ECDHE-ECDSA-AES128-SHA256:ECDHE-RSA-AES128-SHA256:ECDHE-ECDSA-AES128-SHA:ECDHE-RSA-AES128-SHA:ECDHE-ECDSA-AES256-SHA384:ECDHE-RSA-AES256-SHA384:ECDHE-ECDSA-AES256-SHA:ECDHE-RSA-AES256-SHA:DHE-RSA-AES128-SHA256:DHE-RSA-AES256-SHA256:AES128-GCM-SHA256:AES256-GCM-SHA384:AES128-SHA256:AES256-SHA256:AES128-SHA:AES256-SHA:DES-CBC3-SHA','site_default_config','0','global', now(),now(),1,null);
insert into config values ('https_listen-ssl_prefer_server_ciphers','on','site_default_config','0','global', now(),now(),1,null);
insert into config values ('https_listen-ocsp_stapling','1','site_default_config','0','global', now(),now(),1,null); 

insert into config values ('balance_way','rr','site_default_config','0','global', now(),now(),1,null); 
insert into config values ('cc_default_rule','10002','site_default_config','0','global', now(),now(),1,null); 
insert into config values ('gzip_enable','1','site_default_config','0','global', now(),now(),1,null); 
insert into config values ('gzip_types','text/plain text/css text/xml text/javascript application/javascript application/x-javascript application/json','site_default_config','0','global', now(),now(),1,null); 
insert into config values ('websocket_enable','0','site_default_config','0','global', now(),now(),1,null);    
insert into config values ('backend_protocol','http','site_default_config','0','global', now(),now(),1,null);    
insert into config values ('backend_http_port','80','site_default_config','0','global', now(),now(),1,null);
insert into config values ('backend_https_port','443','site_default_config','0','global', now(),now(),1,null);
insert into config values ('proxy_timeout','60','site_default_config','0','global', now(),now(),1,null);
insert into config values ('range','0','site_default_config','0','global', now(),now(),1,null);
insert into config values ('proxy_cache','[]','site_default_config','0','global', now(),now(),1,null);
insert into config values ('proxy_http_version','1.0','site_default_config','0','global', now(),now(),1,null);
insert into config values ('proxy_ssl_protocols','TLSv1 TLSv1.1 TLSv1.2','site_default_config','0','global', now(),now(),1,null); 
insert into config values ('ups_keepalive','1','site_default_config','0','global', now(),now(),1,null); 
insert into config values ('ups_keepalive_conn','32','site_default_config','0','global', now(),now(),1,null); 
insert into config values ('ups_keepalive_timeout','50','site_default_config','0','global', now(),now(),1,null); 
insert into config values ('block_proxy','0','site_default_config','0','global', now(),now(),1,null); 
insert into config values ('req_header','[]','site_default_config','0','global', now(),now(),1,null);
insert into config values ('recv_real_time','0','site_default_config','0','global', now(),now(),1,null); 
insert into config values ('send_real_time','0','site_default_config','0','global', now(),now(),1,null); 
insert into config values ('spider_allow','allow','site_default_config','0','global', now(),now(),1,null); 
insert into config values ('proxy_connect_timeout','10','site_default_config','0','global', now(),now(),1,null);
insert into config values ('log_req_header','1','site_default_config','0','global', now(),now(),1,null);
insert into config values ('log_resp_header','0','site_default_config','0','global', now(),now(),1,null);
insert into config values ('log_req_body','0','site_default_config','0','global', now(),now(),1,null);
insert into config values ('log_req_body_max_size','16','site_default_config','0','global', now(),now(),1,null);


# stream default config
insert into config values ('listen_protocol','tcp','stream_default_config','0','global', now(),now(),1,null); 
insert into config values ('balance_way','rr','stream_default_config','0','global', now(),now(),1,null); 
insert into config values ('proxy_protocol','0','stream_default_config','0','global', now(),now(),1,null); 

# cert default config
insert into config values ('cert_default_type','lets','cert_default_config','0','global', now(),now(),1,null); 


# system config
insert into config values ('keep-job-days','30','system','0','global', now(),now(),1,null); 
insert into config values ('keep-login-log-days','30','system','0','global', now(),now(),1,null); 
insert into config values ('keep-op-log-days','365','system','0','global', now(),now(),1,null); 
insert into config values ('keep-task-log-days','7','system','0','global', now(),now(),1,null); 
insert into config values ('keep-access-log-days','7','system','0','global', now(),now(),1,null); 
insert into config values ('keep-node-log-days','7','system','0','global', now(),now(),1,null); 
insert into config values ('keep-traffic-history-days','90','system','0','global', now(),now(),1,null); 
insert into config values ('keep-node-traffic-log-days','45','system','0','global', now(),now(),1,null); 
insert into config values ('keep-blackip-history-days','7','system','0','global', now(),now(),1,null); 
insert into config values ('login-fail-time-forbidden','30','system','0','global', now(),now(),1,null);
insert into config values ('login-fail-time-captcha','3','system','0','global', now(),now(),1,null); 

insert into config values ('backup_rate','2h','system','0','global', now(),now(),1,null); 
insert into config values ('backup_keep_days','7','system','0','global', now(),now(),1,null); 
insert into config values ('backup_dir','/data/backup/cdn/','system','0','global', now(),now(),1,null); 

insert into config values ('max_site_stream_sync_one_time','1000','system','0','global', now(),now(),1,null); 
insert into config values ('login_session_valid_time','86400','system','0','global', now(),now(),1,null); 
insert into config values ('dns_config','{}','system','0','global', now(),now(),1,null); 
insert into config values ('admin_domain','','system','0','global', now(),now(),1,null); 
insert into config values ('user_domain','','system','0','global', now(),now(),1,null); 
insert into config values ('allow_register','0','system','0','global', now(),now(),1,null); 
insert into config values ('smtp','{}','system','0','global', now(),now(),1,null); 
insert into config values ('register_success_templ','{"title":"cdn用户注册成功","data":"<p>尊敬的{{username}}:</p>\\n<p>您好！感谢您注册cdn。</p>\\n<p>您的注册邮箱{{email}}，用户名{{username}}，密码{{password}}，请妥善保管！</p>"}','system','0','global', now(),now(),1,null); 
insert into config values ('forget_password_templ','{"title":"cdn用户密码重置","data":"<p>尊敬的{{username}}:</p>\\n<p>您好！\\b您已重置密码，新的密码为{{password}}</p>\\n"}','system','0','global', now(),now(),1,null); 
insert into config values ('email_captcha_templ','{"title":"cdn用户验证码","data":"<p>尊敬的用户:</p>\\n<p>您好！您的验证码为{{captcha}}，请在注册页面输入此验证码继续注册</p>\\n"}','system','0','global', now(),now(),1,null); 
insert into config values ('register_require','{"username":{"need":1},"email":{"need":1,"verify":1},"phone":{"need":0,"verify":0},"qq":{"need":0}}','system','0','global', now(),now(),1,null); 
insert into config values ('user_agreement','{"title":"用户协议、法律声明和隐私政策","data":"这里填写协议内容"}','system','0','global', now(),now(),1,null); 
insert into config values ('sms_config','{}','system','0','global', now(),now(),1,null); 
insert into config values ('phone_captcha_templ','【cdn】您的验证码为{{captcha}}，在5分钟内有效。','system','0','global', now(),now(),1,null); 
insert into config values ('alipay_id_auth','{}','system','0','global', now(),now(),1,null); 
insert into config values ('dns_rs_protect','','system','0','global', now(),now(),1,null); 

insert into config values ('node_health_check','1','system','0','global', now(),now(),1,null); 
insert into config values ('node_max_failed','2','system','0','global', now(),now(),1,null); 
insert into config values ('record_repair','0','system','0','global', now(),now(),1,null); 
insert into config values ('record_sync','1','system','0','global', now(),now(),1,null);

insert into config values ('package_expire_close_site','1','system','0','global', now(),now(),1,null); 
insert into config values ('traffic_excceed_close_site','1','system','0','global', now(),now(),1,null); 
insert into config values ('package_allow_upgrade','1','system','0','global', now(),now(),1,null); 
insert into config values ('package_allow_downgrade','0','system','0','global', now(),now(),1,null); 

insert into config values ('system_info','{"footer_copyright":"Copyright © 2025 Cdn All Rights Reserved","footer_link":"官网|http://123.com\\n社区|http://123.com\\n联系我们|http://123.com","user_console_title":"cdn用户控制台","admin_console_title":"cdn管理员控制台","sys_name":"cdn 4.0"}','system','0','global', now(),now(),1,null);
insert into config values ('auth_code','','system','0','global', now(),now(),1,null);
insert into config values ('maintain','{"enable":0,"msg":"维护中,请稍候重试!"}','system','0','global', now(),now(),1,null);
insert into config values ('master_client_ip_header','X-Real-IP','system','0','global', now(),now(),1,null);
insert into config values ('recharge','{"limit_type":"all", "wxpay":{"state":false,"subtype":"native", "app_id":"","mch_id":"","mch_key":"","notify_url":""},"alipay":{"state":false,"subtype":"pc", "app_id":"","app_key":"","public_key":"","notify_url":""},"transfer":{"state":false,"data":""},"default-pay":""}','system','0','global', now(),now(),1,null);
insert into config values ('auto_upgrade_agent','1','system','0','global', now(),now(),1,null);
# 从线路组移除节点时，延后删除节点上配置文件
insert into config values ('delete_config_delayed','','system','0','global', now(),now(),1,null);
insert into config values ('record-repair-enable','1','system','0','global',now(),now(),1,null);

insert into config values ("notification-period","8-22","system","0", "global",now(),now(),1,null);
insert into config values ("traffic-exceed-notify",' {"email":true,"phone":true,"state":true,"notify-times":"2","interval":"24","phone-templ":"【cdn】尊敬的{{username}}，您的套餐流量（ID: {{package_id}}，名称:{{package_name}}）已用尽，系统已暂停您的服务。您可随时升级恢复服务。","email-templ":"cdn套餐流量用尽提醒！\\n<p>尊敬的{{username}}:</p>\\n<p>您的套餐流量（ID: {{package_id}}，名称:{{package_name}}）已用尽，系统已暂停您的服务。您可随时升级恢复服务。</p>"}',"system","0", "global",now(),now(),1,null);
insert into config values ("traffic-exceeding-notify",'{"email":true,"phone":true,"state":true,"notify-times":"2","less":"10","interval":"24","phone-templ":"【cdn】尊敬的{{username}}，您的套餐流量（ID: {{package_id}}，名称:{{package_name}}）仅剩余{{traffic_remain}}GB，为避免影响您的服务，请及时升级。","email-templ":"cdn套餐流量不足提醒！\\n<p>尊敬的{{username}}:</p>\\n<p>您的套餐流量（ID: {{package_id}}，名称:{{package_name}}）仅剩余{{traffic_remain}}GB，为避免影响您的服务，请及时升级。</p>"}',"system","0", "global",now(),now(),1,null);
insert into config values ("package-expire-notify",'{"email":true,"phone":true,"state":true,"notify-times":"2","interval":"24","phone-templ":"【cdn】尊敬的{{username}}，您的套餐（ID: {{package_id}}，名称:{{package_name}}）已过期，系统已暂停您的服务。您可随时续费恢复服务。","email-templ":"cdn套餐过期提醒！\\n<p>尊敬的{{username}}:</p>\\n<p>您的套餐（ID: {{package_id}}，名称:{{package_name}}）已过期，系统已暂停您的服务。您可随时续费恢复服务。</p>"}',"system","0", "global",now(),now(),1,null);
insert into config values ("package-expiring-notify",'{"email":true,"phone":true,"state":true,"notify-times":"2","less":"7","interval":"24","phone-templ":"【cdn】尊敬的{{username}}，您的套餐（ID: {{package_id}}，名称:{{package_name}}）即期过期，仅剩余{{remain_days}}天，为避免影响您的服务，请及时续费。","email-templ":"cdn套餐即将过期提醒！\\n<p>尊敬的{{username}}:</p>\\n<p>您的套餐（ID: {{package_id}}，名称:{{package_name}}）即期过期，仅剩余{{remain_days}}天，为避免影响您的服务，请及时续费。</p>"}',"system","0", "global",now(),now(),1,null);
insert into config values ("cert-expire-notify",'{"email":true,"phone":true,"state":true,"notify-times":"2","interval":"24","phone-templ":"【cdn】尊敬的{{username}}，您的证书（ID: {{cert_id}}，名称:{{cert_name}}，域名:{{domain}} ）已过期，为避免影响业务，请尽快处理。","email-templ":"cdn证书过期提醒！\\n<p>尊敬的{{username}}:</p>\\n<p>您的证书（ID: {{cert_id}}，名称:{{cert_name}}，域名:{{domain}} ）已过期，为避免影响业务，请尽快处理。</p>"}',"system","0", "global",now(),now(),1,null);
insert into config values ("cert-expiring-notify",'{"email":true,"phone":true,"state":true,"notify-times":"3","less":"7","interval":"24","phone-templ":"【cdn】尊敬的{{username}}，您的证书（ID: {{cert_id}}，名称:{{cert_name}}，域名:{{domain}} ）即期过期，仅剩余{{remain_days}}天，为避免影响您的业务，请及时处理。","email-templ":"cdn证书即将过期提醒！\\n<p>尊敬的{{username}}:</p>\\n<p>您的证书（ID: {{cert_id}}，名称:{{cert_name}}，域名:{{domain}} ）即期过期，仅剩余{{remain_days}}天，为避免影响您的业务，请及时处理。</p>"}',"system","0", "global",now(),now(),1,null);

insert into config values ('sync-site-config-scope','line_group','system','0','global',now(),now(),1,null);
insert into config values ('node_monitor_config','{"global_check_on":true,"check_protocol":"tcp","check_timeout":"5","check_port":"80","check_host":"","check_path":"/","check_node_group":"1","check_action":"pause","notification_period":"8-22", "notify_method":"email sms","notify_msg_type":"节点IP解析 带宽监控 备用IP 备用默认解析 备用线路组","email":"","phone":"","bw_exceed_times":2, "monitor_api":"", "interval":30,"failed_times":3,"failed_rate":"90","ip_disable_templ":"【cdn】节点ID（{{node_id}}），IP（{{ip}}）不可用，已禁用","ip_disable_templ_id":"","ip_enable_templ":"【cdn】节点ID（{{node_id}}），IP（{{ip}}）恢复正常，已启用","ip_enable_templ_id":"","bandwidth_exceed_templ":"【cdn】节点ID（{{node_id}}），IP（{{ip}}）带宽超限，已禁用","bandwidth_exceed_templ_id":"","bandwidth_restore_templ":"【cdn】节点ID（{{node_id}}），IP（{{ip}}）带宽恢复正常，已启用","bandwidth_restore_templ_id":"","backup_ip_disable_templ":"【cdn】主IP恢复，取消使用备用IP（{{ip}}），线路组ID（{{node_group_id}}），节点ID（{{node_id}}），线路ID（{{line_id}}）","backup_ip_disable_templ_id":"","backup_ip_enable_templ":"【cdn】主IP不可用，启用备用IP（{{ip}}），线路组ID（{{node_group_id}}），节点ID（{{node_id}}），线路ID（{{line_id}}）","backup_ip_enable_templ_id":"","backup_default_line_disable_templ":"【cdn】当前线路组默认解析恢复，备用默认解析恢复为原来的线路，IP（{{ip}}），线路组ID（{{node_group_id}}），节点ID（{{node_id}}），线路ID（{{line_id}}）","backup_default_line_disable_templ_id":"","backup_default_line_enable_templ":"【cdn】当前线路组没有默认解析，启用备用默认解析，IP（{{ip}}），线路组ID（{{node_group_id}}），节点ID（{{node_id}}），线路ID（{{line_id}}）","backup_default_line_enable_templ_id":"","backup_node_group_disable_templ":"【cdn】主线路组（{{node_group_id}}）IP恢复可用，恢复使用主线路组","backup_node_group_disable_templ_id":"","backup_node_group_enable_templ":"【cdn】主线路组（{{node_group_id}}）无可用IP，启用备用线路组）","backup_node_group_enable_templ_id":""}','system','0','global', now(),now(),1,null); 
insert into config values ('https_cert','-----BEGIN CERTIFICATE-----\nMIIFljCCBH6gAwIBAgIQBL/rK+7F4CpsSmlMHSvE6TANBgkqhkiG9w0BAQsFADBy\nMQswCQYDVQQGEwJDTjElMCMGA1UEChMcVHJ1c3RBc2lhIFRlY2hub2xvZ2llcywg\nSW5jLjEdMBsGA1UECxMURG9tYWluIFZhbGlkYXRlZCBTU0wxHTAbBgNVBAMTFFRy\ndXN0QXNpYSBUTFMgUlNBIENBMB4XDTE5MDgyOTAwMDAwMFoXDTIwMDgyODEyMDAw\nMFowFzEVMBMGA1UEAxMMdi54bW15YnV5LmNuMIIBIjANBgkqhkiG9w0BAQEFAAOC\nAQ8AMIIBCgKCAQEAvklonZm10SOgrFkH8ftzzLmcqRts+GwZthSpqC6iVuKrbJ8P\nwUpuW7NeK1bqzBN6Dfq+M2wvqwnjreUPD8+yrh1SM942wAEoMh2V4ozTZ3j1a99E\nzVxF1XB5Lj0mz49/0Xx0cUBnP9gCS3QZFixvxDLYcOKar43FC3nRxzA9kkyqB1t+\ndTCjnag7txFV38ta0rCGFMZBP4k8Uv36Lbjmy6vYSqqyV7nbwba9YhdfWQRdHU2k\nNxl3WB23V9jzH8vXvT8ZdLJhL78Xa1NE6riD7dMOWQ5PAafUBJVHS5QZpDwQ57s9\nV5izozmOkxtore8oh00JmDZRSIrVWhxUPc3gxwIDAQABo4ICgTCCAn0wHwYDVR0j\nBBgwFoAUf9OZ86BHDjEAVlYijrfMnt3KAYowHQYDVR0OBBYEFNC7hqpkdbYsSxAH\n8gwqcDRX87KpMBcGA1UdEQQQMA6CDHYueG1teWJ1eS5jbjAOBgNVHQ8BAf8EBAMC\nBaAwHQYDVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMEwGA1UdIARFMEMwNwYJ\nYIZIAYb9bAECMCowKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LmRpZ2ljZXJ0LmNv\nbS9DUFMwCAYGZ4EMAQIBMIGSBggrBgEFBQcBAQSBhTCBgjA0BggrBgEFBQcwAYYo\naHR0cDovL3N0YXR1c2UuZGlnaXRhbGNlcnR2YWxpZGF0aW9uLmNvbTBKBggrBgEF\nBQcwAoY+aHR0cDovL2NhY2VydHMuZGlnaXRhbGNlcnR2YWxpZGF0aW9uLmNvbS9U\ncnVzdEFzaWFUTFNSU0FDQS5jcnQwCQYDVR0TBAIwADCCAQMGCisGAQQB1nkCBAIE\ngfQEgfEA7wB1AKS5CZC0GFgUh7sTosxncAo8NZgE+RvfuON3zQ7IDdwQAAABbN1d\n8dIAAAQDAEYwRAIgKjX5TCYDTKSldG2mUsiG4WnxImZOsSaVkxU1+CLPBOcCIAQi\nusi7GvFs4xrtrhvOwTGFxGDXY+6S0SUz8zJmrKzcAHYAXqdz+d9WwOe1Nkh90Eng\nMnqRmgyEoRIShBh1loFxRVgAAAFs3V3xYgAABAMARzBFAiBtc5xBBPtKTdOFKva1\nJRaE8J5NGd92sSRPi/wxmfUeBAIhAOiLc4fRh9GW1SCc+JCkdqZ5siLUy3n6e87u\npMDtKJpbMA0GCSqGSIb3DQEBCwUAA4IBAQBz/ONP/OqmV4FZe3ealUfOwYk0Y2lr\noB2IrO5pLl+hUBIaoTxcxa8prfWL3658b+l+fe5q/oeA9y5mFaH6SBHFCDMnpJqq\n1dLQ3HtcdQI65uKXLmNDUpA/t1VGRexTqpAp2tpPyGcYf2MDMztpdwh/ap67pgfd\najY+++Pfl3uJW8SODFUiR9mnX20o6X1gPXAYI6Oo8NauM5/Uw/W5cDe8lqEa0T7J\nGxh9ytzM1LZbWTpdsnDcpV6yMRuJ7Z2Kkz74m5ljoDSU3Wj5xbLG8HSG3DwjEEd+\nj5Seof4jYe3eHrOqm/y0GumtFQ26RLcFq4092SipfO7BVFX0qfbmEzor\n-----END CERTIFICATE-----\n-----BEGIN CERTIFICATE-----\nMIIErjCCA5agAwIBAgIQBYAmfwbylVM0jhwYWl7uLjANBgkqhkiG9w0BAQsFADBh\nMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3\nd3cuZGlnaWNlcnQuY29tMSAwHgYDVQQDExdEaWdpQ2VydCBHbG9iYWwgUm9vdCBD\nQTAeFw0xNzEyMDgxMjI4MjZaFw0yNzEyMDgxMjI4MjZaMHIxCzAJBgNVBAYTAkNO\nMSUwIwYDVQQKExxUcnVzdEFzaWEgVGVjaG5vbG9naWVzLCBJbmMuMR0wGwYDVQQL\nExREb21haW4gVmFsaWRhdGVkIFNTTDEdMBsGA1UEAxMUVHJ1c3RBc2lhIFRMUyBS\nU0EgQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCgWa9X+ph+wAm8\nYh1Fk1MjKbQ5QwBOOKVaZR/OfCh+F6f93u7vZHGcUU/lvVGgUQnbzJhR1UV2epJa\ne+m7cxnXIKdD0/VS9btAgwJszGFvwoqXeaCqFoP71wPmXjjUwLT70+qvX4hdyYfO\nJcjeTz5QKtg8zQwxaK9x4JT9CoOmoVdVhEBAiD3DwR5fFgOHDwwGxdJWVBvktnoA\nzjdTLXDdbSVC5jZ0u8oq9BiTDv7jAlsB5F8aZgvSZDOQeFrwaOTbKWSEInEhnchK\nZTD1dz6aBlk1xGEI5PZWAnVAba/ofH33ktymaTDsE6xRDnW97pDkimCRak6CEbfe\n3dXw6OV5AgMBAAGjggFPMIIBSzAdBgNVHQ4EFgQUf9OZ86BHDjEAVlYijrfMnt3K\nAYowHwYDVR0jBBgwFoAUA95QNVbRTLtm8KPiGxvDl7I90VUwDgYDVR0PAQH/BAQD\nAgGGMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjASBgNVHRMBAf8ECDAG\nAQH/AgEAMDQGCCsGAQUFBwEBBCgwJjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3Au\nZGlnaWNlcnQuY29tMEIGA1UdHwQ7MDkwN6A1oDOGMWh0dHA6Ly9jcmwzLmRpZ2lj\nZXJ0LmNvbS9EaWdpQ2VydEdsb2JhbFJvb3RDQS5jcmwwTAYDVR0gBEUwQzA3Bglg\nhkgBhv1sAQIwKjAoBggrBgEFBQcCARYcaHR0cHM6Ly93d3cuZGlnaWNlcnQuY29t\nL0NQUzAIBgZngQwBAgEwDQYJKoZIhvcNAQELBQADggEBAK3dVOj5dlv4MzK2i233\nlDYvyJ3slFY2X2HKTYGte8nbK6i5/fsDImMYihAkp6VaNY/en8WZ5qcrQPVLuJrJ\nDSXT04NnMeZOQDUoj/NHAmdfCBB/h1bZ5OGK6Sf1h5Yx/5wR4f3TUoPgGlnU7EuP\nISLNdMRiDrXntcImDAiRvkh5GJuH4YCVE6XEntqaNIgGkRwxKSgnU3Id3iuFbW9F\nUQ9Qqtb1GX91AJ7i4153TikGgYCdwYkBURD8gSVe8OAco6IfZOYt/TEwii1Ivi1C\nqnuUlWpsF1LdQNIdfbW3TSe0BhQa7ifbVIfvPWHYOu3rkg1ZeMo6XRU9B4n5VyJY\nRmE=\n-----END CERTIFICATE-----\n','system','0','global', now(),now(),1,null); 
insert into config values ('https_key','-----BEGIN PRIVATE KEY-----\nMIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQC+SWidmbXRI6Cs\nWQfx+3PMuZypG2z4bBm2FKmoLqJW4qtsnw/BSm5bs14rVurME3oN+r4zbC+rCeOt\n5Q8Pz7KuHVIz3jbAASgyHZXijNNnePVr30TNXEXVcHkuPSbPj3/RfHRxQGc/2AJL\ndBkWLG/EMthw4pqvjcULedHHMD2STKoHW351MKOdqDu3EVXfy1rSsIYUxkE/iTxS\n/fotuObLq9hKqrJXudvBtr1iF19ZBF0dTaQ3GXdYHbdX2PMfy9e9Pxl0smEvvxdr\nU0TquIPt0w5ZDk8Bp9QElUdLlBmkPBDnuz1XmLOjOY6TG2it7yiHTQmYNlFIitVa\nHFQ9zeDHAgMBAAECggEAHQwPVwYondvJQks27hvwgd8QSIo3Y2FRDXKbBrbTsN1a\nG13ZOwGAgNQL0HmB+b68DNfqt+Z7DP9t9392Afe2cri8HHnT3rxueolPS4LWyelK\nLCTWwl3PCoq9nNmDNqpU8dFZ5GiB5QTgLiIeADyun62+oitylHuDiZcXdvITZrpf\nbKGe1d2O0tbz1razZTzDR4E50ZS7+ck/TUS+Ciyq76WFaFY+Mhd3TbQS21tHVHId\nBr3F7eoXrZvXZ9J/C/2pmCbiK6rPzTlR1sLDFN2wH2ARUICfVCSctampGRxSKZQW\nQrGMmGInaueqmQqHEBl02WHb6WPhXnIeicCSB1PGYQKBgQDnM6YIqsfJC6qMECL3\nglj1dseWRY3Y1HVQ49gkwk7MFqnx4ZQKdMI3T88+MnnoUK6YsJA9imX1nXaTCUsy\n4umRd+i608RyXLrtwuezU4ejKdAK47Y/SFGaF18pvsNiQWWb2FMyOSWqYFj8e1Mx\nicYnlZiGNzoiM4V/RsFU7tf/YQKBgQDSslBH3d99WddEiP2XawSYjnLfP+OLLTW6\nvdRhEj48st8utVHOAqoFEOGVikHxtwN5AhfHOy6cRMVWPYFUpdVMa9qqsz5J2mmp\nRi0GHNU3n297Wv0UHlkVUGP00VQcUTi7pCUh+ejxs1K6mYrbp/dRrJMQjrBPJU8K\n3zBWQmWZJwKBgF9dFmcMyktK3JXZMhMVWMwmqjx5hACj4Z/z2vuOiiH0VzTF7uJB\nNrrJ2Jm3CEGixeGFMnmv1E5zHK2Zb8MVhXHTG9Oz9ZuWVCQt+JQnKBNM89sKAeoo\nUkBU05PMc5rbjqWxnN9iYv7brti1paMRSQKa2cbCkN/6kF3nOWdm/QEBAoGAQNau\n7e7Rf/nNzUF7CMXePDRaFWnL1GCtUDJq0RSUIonJNM6HxiX7vGNdiG9rq77uSqbi\nOmV0CpL/R3LWAf6mjUYDnNRcLs4QBg+ae28UDnH6FLQDfdV5BJ4gpI5mm/BCzTvO\nUY5eqULOCq6FlOMzsOayuz2t9C0/DdFxRppYObECgYEAofQzjUVlXo9oI00L2d9l\nSl8MWSv/vMV+wlB4/eqw3zOhhCMWv78e/diREHJTWPcbitILE245BBrRHyESUwbu\nsVK/EcJODLumVfH5b8hGbobHAjBTaZ18+w0+Ei58Px3B2BBZCfiwEJBNk6b5KUan\n7+zsTxUmCSpgtqOlvMIwSoM=\n-----END PRIVATE KEY-----\n','system','0','global', now(),now(),1,null); 

insert into config values ("cc-switch-notify",'{"email":true,"phone":true,"state":true,"phone-templ":"【cdn】尊敬的{{username}}，您的域名:{{domain}}）当前QPS为{{curr_qps}}，已超过设置的{{qps_limit}}，疑似被攻击，现系统已自动切换到规则组{{rule_name}}来防御。","email-templ":"网站CC规则组自动切换提醒！\\n<p>尊敬的{{username}}:</p>\\n<p>您的域名:{{domain}}）当前QPS为{{curr_qps}}，已超过设置的{{qps_limit}}，疑似被攻击，现系统已自动切换到规则组{{rule_name}}来防御。</p>"}',"system","0", "global",now(),now(),1,null);
insert into config values ("bandwidth-exceed-notify",'{"email":true,"phone":true,"state":true,"phone-templ":"【cdn】尊敬的{{username}}，您的套餐（ID: {{package_id}}，名称:{{package_name}}）当前带宽为{{curr_bandwidth}}，已超过限制的{{bandwidth_limit}}，现系统已开启限速。","email-templ":"cdn套餐带宽超限提醒！\\n<p>尊敬的{{username}}:</p>\\n<p>您的套餐（ID: {{package_id}}，名称:{{package_name}}）当前带宽为{{curr_bandwidth}}，已超过限制的{{bandwidth_limit}}，现系统已开启限速。</p>"}',"system","0", "global",now(),now(),1,null);
insert into config values ("conn-exceed-notify",'{"email":true,"phone":true,"state":true,"phone-templ":"【cdn】尊敬的{{username}}，您的套餐（ID: {{package_id}}，名称:{{package_name}}）当前连接数为{{curr_conn}}，已超过限制的{{conn_limit}}，现系统已开启限速。","email-templ":"cdn套餐连接数超限提醒！\\n<p>尊敬的{{username}}:</p>\\n<p>您的套餐（ID: {{package_id}}，名称:{{package_name}}）当前连接数为{{curr_conn}}，已超过限制的{{conn_limit}}，现系统已开启限速。</p>"}',"system","0", "global",now(),now(),1,null);
insert into config values ('allow-enable-email-captcha-login','1','system','0','global',now(),now(),1,null);
insert into config values ('allow-enable-sms-captcha-login','0','system','0','global',now(),now(),1,null);
insert into config values ('node-config','{}','system','0','global',now(),now(),1,null);
insert into config values ('bind-master-host','','system','0','global',now(),now(),1,null);
insert into config values ('phone_captcha_templ_id','','system','0','global', now(),now(),1,null); 
insert into config values ('res_rank_size','100','system','0','global', now(),now(),1,null); 
insert into config values ('http_traffic_comp','300','system','0','global', now(),now(),1,null); 
insert into config values ('https_traffic_comp','5300','system','0','global', now(),now(),1,null); 
insert into config values ('captcha_type','{"email":"","phone":"native"}','system','0','global', now(),now(),1,null); 
insert into config values ('qcloud_captcha','{}','system','0','global', now(),now(),1,null); 
insert into config values ('http_proxy','','system','0','global', now(),now(),1,null);
insert into config values ('geetest_captcha','{}','system','0','global', now(),now(),1,null); 
insert into config values ('company_auth','{}','system','0','global', now(),now(),1,null);
insert into config values ('tcp_coefficient','1.1','system','0','global', now(),now(),1,null); 
insert into config values ("account-auth2-notify",'{"email":true,"phone":true,"state":true,"phone-templ":"【cdn】尊敬的{{username}}，您的账号存在异常，权限已暂时关闭。请登录CDN后台完成二次实名认证，以恢复正常使用。  ","email-templ":"请尽快完成CDN平台二次实名认证！\\n<p>尊敬的{{username}}:</p>\\n<p>您的账号存在异常，权限已暂时关闭。请登录CDN后台完成二次实名认证，以恢复正常使用。</p>"}',"system","0", "global",now(),now(),1,null);

# internal cc rule
insert into cc_match values (3, null, '匹配所有资源', '内置匹配器', '{}',now(),now(),1,1,null,1);
insert into cc_match values (4, null, '匹配静态资源', '内置匹配器', '[{"item":"req_uri","op":"contain","value":".js\\n.css\\n.png\\n.jpg\\n.jpeg\\n.gif"}]',now(),now(),1,1,null,1);
insert into cc_match values (5, null, '匹配内置资源', '内置匹配器', '[{"item":"uri","op":"contain","value":"/_guard/click.js\\n/_guard/slide.js\\n/_guard/captcha.png\\n/_guard/verify-captcha\\n/_guard/encrypt.js\\nfavicon.ico"}]',now(),now(),1,1,null,1);
insert into cc_match values (10020, null, null, null, null,null,null,null,null,null,null);

insert into cc_filter VALUES (1,NULL,'302跳转60-5','内置过滤器','302_challenge',60,5,0,'{}',now(),now(),1,1,NULL,1);
insert into cc_filter VALUES (2,NULL,'滑动过滤60-5','内置过滤器','slide_filter',60,5,0,'{}',now(),now(),1,1,NULL,1);
insert into cc_filter VALUES (3,NULL,'验证码60-5','内置过滤器','captcha_filter',60,5,0,'{}',now(),now(),1,1,NULL,1);
insert into cc_filter VALUES (4,NULL,'内置请求保护60-20-15','内置过滤器','req_rate',60,20,15,'{}',now(),now(),1,1,NULL,1);
insert into cc_filter VALUES (5,NULL,'请求速率5-20-10','内置过滤器','req_rate',5,20,10,'{}',now(),now(),1,1,NULL,1);
insert into cc_filter VALUES (6,NULL,'请求速率5-30-20','内置过滤器','req_rate',5,30,20,'{}',now(),now(),1,1,NULL,1);
insert into cc_filter VALUES (7,NULL,'请求速率5-100-10','内置过滤器','req_rate',5,100,10,'{}',now(),now(),1,1,NULL,1);
insert into cc_filter VALUES (8,NULL,'浏览器识别60-5','内置过滤器','browser_verify_auto',60,5,0,'{}',now(),now(),1,1,NULL,1);
insert into cc_filter VALUES (9,NULL,'请求速率5-300-50','内置过滤器','req_rate',5,300,50,'{}',now(),now(),1,1,NULL,1);
insert into cc_filter VALUES (10,NULL,'请求速率5-200-50','内置过滤器','req_rate',5,200,50,'{}',now(),now(),1,1,NULL,1);
insert into cc_filter VALUES (11,NULL,'临时白名单专用1','内置过滤器','req_rate',5,300,50,'{}',now(),now(),1,1,NULL,1);
insert into cc_filter VALUES (12,NULL,'临时白名单专用2','内置过滤器','req_rate',5,200,50,'{}',now(),now(),1,1,NULL,1);
insert into cc_filter VALUES (10000,NULL,'点击过滤60-5','内置过滤器','click_filter',60,5,0,'{}',now(),now(),1,1,NULL,1);
insert into cc_filter VALUES (10001,NULL,'5秒盾60-5','内置过滤器','delay_jump_filter',60,5,0,'{}',now(),now(),1,1,NULL,1);
insert into cc_filter VALUES (10002,NULL,'旋转图片60-5','内置过滤器','rotate_filter',60,5,0,'{}',now(),now(),1,1,NULL,1);
insert into cc_filter VALUES (10003,NULL,'点击过滤(简单)60-5','内置过滤器','easy_click_filter',60,5,0,'{}',now(),now(),1,1,NULL,1);
insert into cc_filter VALUES (10004,NULL,'滑动过滤(简单)60-5','内置过滤器','easy_slide_filter',60,5,0,'{}',now(),now(),1,1,NULL,1);
insert into cc_filter VALUES (10020,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);

insert into cc_rule VALUES (1,3,NULL,'JS验证','内置规则','[{"mode": "break", "matcher": "3", "action": "block", "state": true, "filter1": "8", "filter2_name": "", "filter2": "", "matcher_name": "匹配所有资源", "filter1_name": "浏览器识别60-5"}]','',now(),now(),1,1,1,NULL,1);
insert into cc_rule VALUES (2,6,NULL,'滑块验证','内置规则','[{"mode": "break", "matcher": "3", "action": "block", "state": true, "filter1": "2", "filter2_name": "", "filter2": "", "matcher_name": "匹配所有资源", "filter1_name": "滑动过滤60-5"}]','',now(),now(),1,1,1,NULL,1);
insert into cc_rule VALUES (3,100,NULL,'临时白名单','内置规则','[{"mode": "break", "matcher": "3", "matcher_name": "匹配所有资源", "state": true, "filter1": "11", "filter2_name": "", "filter2": "", "action": "block", "filter1_name": "临时白名单专用1"}]','',now(),now(),1,1,0,NULL,1);
insert into cc_rule VALUES (4,7,NULL,'验证码','内置规则','[{"mode": "break", "matcher": "3", "action": "block", "state": true, "filter1": "3", "filter2_name": "", "filter2": "", "matcher_name": "匹配所有资源", "filter1_name": "验证码60-5"}]','',now(),now(),1,1,1,NULL,1);
insert into cc_rule VALUES (6,2,NULL,'宽松','内置规则','[{"mode": "break", "matcher": "3", "action": "block", "state": true, "filter1": "9", "filter2_name": "", "filter2": "", "matcher_name": "匹配所有资源", "filter1_name": "请求速率5-300-50"}]','',now(),now(),1,1,1,NULL,1);
insert into cc_rule VALUES (10000,5,NULL,'点击验证','内置规则','[{"mode": "break", "matcher": "3", "action": "block", "state": true, "filter1": "10000", "filter2_name": "", "filter2": "", "matcher_name": "匹配所有资源", "filter1_name": "点击过滤60-5"}]','',now(),now(),1,1,1,NULL,1);
insert into cc_rule VALUES (10001,4,NULL,'5秒盾','内置规则','[{"mode": "break", "matcher": "3", "action": "block", "state": true, "filter1": "10001", "filter2_name": "", "filter2": "", "matcher_name": "匹配所有资源", "filter1_name": "5秒盾60-5"}]','',now(),now(),1,1,1,NULL,1);
insert into cc_rule VALUES (10002,1,NULL,'关闭','内置规则','[]','',now(),now(),1,1,1,NULL,1);
insert into cc_rule VALUES (10003,8,NULL,'旋转图片','内置规则','[{"mode": "break", "matcher": "3", "action": "block", "state": true, "filter1": "10002", "filter2_name": "", "filter2": "", "matcher_name": "匹配所有资源", "filter1_name": "旋转图片60-5"}]','',now(),now(),1,1,1,NULL,1);
insert into cc_rule VALUES (10004,9,NULL,'点击验证(简单)','内置规则','[{"mode": "break", "matcher": "3", "action": "block", "state": true, "filter1": "10003", "filter2_name": "", "filter2": "", "matcher_name": "匹配所有资源", "filter1_name": "点击过滤(简单)60-5"}]','',now(),now(),1,1,1,NULL,1);
insert into cc_rule VALUES (10005,10,NULL,'滑块验证(简单)','内置规则','[{"mode": "break", "matcher": "3", "action": "block", "state": true, "filter1": "10004", "filter2_name": "", "filter2": "", "matcher_name": "匹配所有资源", "filter1_name": "滑动过滤(简单)60-5"}]','',now(),now(),1,1,1,NULL,1);

insert into cc_rule VALUES (10020,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);

insert into package_group values (1,'默认','',100,1,now(),now());
insert into region values (1,'默认','',"80", 100,now(),now());

# lock
insert into `tlock` values ("user");
insert into `tlock` values ("dns");
insert into `tlock` values ("region");
insert into `tlock` values ("node");
insert into `tlock` values ("node_line");
insert into `tlock` values ("line");
insert into `tlock` values ("node_group");
insert into `tlock` values ("dnsapi");
insert into `tlock` values ("cert");
insert into `tlock` values ("acl");
insert into `tlock` values ("cc_rule");
insert into `tlock` values ("cc_match");
insert into `tlock` values ("cc_filter");
insert into `tlock` values ("package");
insert into `tlock` values ("package_up");
insert into `tlock` values ("user_package");
insert into `tlock` values ("user_package_up");
insert into `tlock` values ("config");
insert into `tlock` values ("site");
insert into `tlock` values ("record");
insert into `tlock` values ("site_group");
insert into `tlock` values ("merge_site_group");
insert into `tlock` values ("stream");
insert into `tlock` values ("stream_group");
insert into `tlock` values ("merge_stream_group");
insert into `tlock` values ("order");
insert into `tlock` values ("task");
insert into `tlock` values ("package_group");    
insert into `tlock` values ("merge_package_group");   
insert into `tlock` values ("message");   
insert into `tlock` values ("cname_domain");   

# user
insert into user values (1, 'admin@cdn.cn', 'admin', '',null,null,null,null,null,null,0,0,0,null,'none',null,null,0,null,null,null,0,0,now(),'$2b$12$UV5ttpNQizMfO.tiBk9ereZ53hDBW0.kak3qa/GRP6aVBfNMB1NsK',1,1);
insert into user values (2, 'jason@cdn.cn', 'jason', '',null,null,null,null,null,null,0,0,0,null,'none',null,null,0,null,null,null,0,0,now(),'$2b$12$UV5ttpNQizMfO.tiBk9ereZ53hDBW0.kak3qa/GRP6aVBfNMB1NsK',1,2);
insert into message_sub values (1,'package-expire',1,1);
insert into message_sub values (1,'traffic-exceed',1,1);

insert into message_sub values (1,'cc-switch',1,1);
insert into message_sub values (1,'bandwidth-exceed',1,1);
insert into message_sub values (1,'connection-exceed',1,1);
insert into message_sub values (1,'cert-expire',1,1);

insert into message_sub values (2,'package-expire',1,1);
insert into message_sub values (2,'traffic-exceed',1,1);

insert into message_sub values (2,'cc-switch',1,1);
insert into message_sub values (2,'bandwidth-exceed',1,1);
insert into message_sub values (2,'connection-exceed',1,1);
insert into message_sub values (2,'cert-expire',1,1);

# l2_cond
INSERT INTO `l2_cond` VALUES (1,'国外节点','','[{\"item\": \"node_country_code\", \"value2\": \"\", \"value\": \"cn\", \"op\": \"!=\"}]',now());
