#!/usr/bin/env python
# -*- coding: utf-8 -*-
import json

from alipay.aop.api.constant.ParamConstants import *


class AlipayOpenMiniActivityGiftQueryModel(object):

    def __init__(self):
        self._template_id = None
        self._voucher_jump_type = None

    @property
    def template_id(self):
        return self._template_id

    @template_id.setter
    def template_id(self, value):
        self._template_id = value
    @property
    def voucher_jump_type(self):
        return self._voucher_jump_type

    @voucher_jump_type.setter
    def voucher_jump_type(self, value):
        self._voucher_jump_type = value


    def to_alipay_dict(self):
        params = dict()
        if self.template_id:
            if hasattr(self.template_id, 'to_alipay_dict'):
                params['template_id'] = self.template_id.to_alipay_dict()
            else:
                params['template_id'] = self.template_id
        if self.voucher_jump_type:
            if hasattr(self.voucher_jump_type, 'to_alipay_dict'):
                params['voucher_jump_type'] = self.voucher_jump_type.to_alipay_dict()
            else:
                params['voucher_jump_type'] = self.voucher_jump_type
        return params

    @staticmethod
    def from_alipay_dict(d):
        if not d:
            return None
        o = AlipayOpenMiniActivityGiftQueryModel()
        if 'template_id' in d:
            o.template_id = d['template_id']
        if 'voucher_jump_type' in d:
            o.voucher_jump_type = d['voucher_jump_type']
        return o


