# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class LastDownsampleRequest(JDCloudRequest):
    """
    根据不同的聚合方式将metric的数据聚合为一个点。downAggrType：last(最后一个点)、max(最大值)、min(最小值)、avg(平均值)。该接口返回值为上报metric的原始值，没有做单位转换。metric介绍：<a href="https://docs.jdcloud.com/cn/monitoring/metrics">Metrics</a>
    """

    def __init__(self, parameters, header=None, version="v2"):
        super(LastDownsampleRequest, self).__init__(
            '/regions/{regionId}/ydMetrics/{metric}/lastDownsample', 'GET', header, version)
        self.parameters = parameters


class LastDownsampleParameters(object):

    def __init__(self,regionId, metric, serviceCode, resourceId, ):
        """
        :param regionId: 地域 Id
        :param metric: 监控项英文标识(id)
        :param serviceCode: 资源的类型，取值vm, lb, ip, database 等。可用的serviceCode请使用describeServices接口查询
        :param resourceId: 资源的uuid，支持多个resourceId批量查询，每个id用竖线分隔。 如：id1|id2|id3|id4
        """

        self.regionId = regionId
        self.metric = metric
        self.serviceCode = serviceCode
        self.dimension = None
        self.resourceId = resourceId
        self.tags = None
        self.startTime = None
        self.endTime = None
        self.timeInterval = None
        self.aggrType = None
        self.downAggrType = None

    def setDimension(self, dimension):
        """
        :param dimension: (Optional) 资源的维度。serviceCode下可用的dimension请使用describeServices接口查询
        """
        self.dimension = dimension

    def setTags(self, tags):
        """
        :param tags: (Optional) 自定义标签
        """
        self.tags = tags

    def setStartTime(self, startTime):
        """
        :param startTime: (Optional) 查询时间范围的开始时间， UTC时间，格式：2016-12-11T00:00:00+0800（早于30d时，将被重置为30d）（注意在url中+要转译为%2B故url中为2016-12-11T00:00:00%2B0800）
        """
        self.startTime = startTime

    def setEndTime(self, endTime):
        """
        :param endTime: (Optional) 查询时间范围的结束时间， UTC时间，格式：2016-12-11T00:00:00+0800（为空时，将由startTime与timeInterval计算得出）（注意在url中+要转译为%2B故url中为2016-12-11T00:00:00%2B0800）
        """
        self.endTime = endTime

    def setTimeInterval(self, timeInterval):
        """
        :param timeInterval: (Optional) 查询的时间间隔，最大不超过30天，支持分钟级别,小时级别，天级别，例如：1m、1h、1d
        """
        self.timeInterval = timeInterval

    def setAggrType(self, aggrType):
        """
        :param aggrType: (Optional) 聚合方式：max avg min等,用于不同维度之间聚合
        """
        self.aggrType = aggrType

    def setDownAggrType(self, downAggrType):
        """
        :param downAggrType: (Optional) 聚合方式：max avg min等,用于将维度内一个周期数据聚合为一个点的聚合方式,默认last
        """
        self.downAggrType = downAggrType

