# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class ModifyNatGatewayRequest(JDCloudRequest):
    """
    修改NAT网关接口，修改网关规格或带宽需要先停止网关
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(ModifyNatGatewayRequest, self).__init__(
            '/regions/{regionId}/natGateways/{natGatewayId}', 'PATCH', header, version)
        self.parameters = parameters


class ModifyNatGatewayParameters(object):

    def __init__(self,regionId, natGatewayId, ):
        """
        :param regionId: Region ID
        :param natGatewayId: natGateway ID
        """

        self.regionId = regionId
        self.natGatewayId = natGatewayId
        self.natGatewayName = None
        self.description = None
        self.natGatewaySpec = None

    def setNatGatewayName(self, natGatewayName):
        """
        :param natGatewayName: (Optional) NAT网关名称
        """
        self.natGatewayName = natGatewayName

    def setDescription(self, description):
        """
        :param description: (Optional) 描述,允许输入UTF-8编码下的全部字符，不超过256字符
        """
        self.description = description

    def setNatGatewaySpec(self, natGatewaySpec):
        """
        :param natGatewaySpec: (Optional) NAT网关规格，取值small（100万并发连接数）,medium(300万并发连接数),large（1000万并发连接数）
        """
        self.natGatewaySpec = natGatewaySpec

