# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DescribeNatGatewaysRequest(JDCloudRequest):
    """
    查询NAT网关列表接口
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(DescribeNatGatewaysRequest, self).__init__(
            '/regions/{regionId}/natGateways/', 'GET', header, version)
        self.parameters = parameters


class DescribeNatGatewaysParameters(object):

    def __init__(self,regionId, ):
        """
        :param regionId: Region ID
        """

        self.regionId = regionId
        self.pageNumber = None
        self.pageSize = None
        self.filters = None
        self.tags = None

    def setPageNumber(self, pageNumber):
        """
        :param pageNumber: (Optional) 页码, 默认为1, 取值范围：[1,∞), 页码超过总页数时, 显示最后一页
        """
        self.pageNumber = pageNumber

    def setPageSize(self, pageSize):
        """
        :param pageSize: (Optional) 分页大小，默认为20，取值范围：[10,100]
        """
        self.pageSize = pageSize

    def setFilters(self, filters):
        """
        :param filters: (Optional) natGatewayIds - NAT网关ID列表，支持多个
natGatewayNames - NAT网关名称列表，支持多个
natGatewayPublicIp - NAT网关公网IP，支持单个，即将废弃，请使用elasticIpAddress
elasticIpAddress - 公网IP，支持单个
natGatewayPrivateIp - NAT网关私网IP，支持单个
vpcId - NAT网关所属VPC ID，支持单个
subnetId - NAT网关所属子网ID，支持单个

        """
        self.filters = filters

    def setTags(self, tags):
        """
        :param tags: (Optional) Tag筛选条件
        """
        self.tags = tags

