# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DeleteNatGatewayRequest(JDCloudRequest):
    """
    删除NAT网关接口，NAT网关需要先停止再删除
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(DeleteNatGatewayRequest, self).__init__(
            '/regions/{regionId}/natGateways/{natGatewayId}', 'DELETE', header, version)
        self.parameters = parameters


class DeleteNatGatewayParameters(object):

    def __init__(self,regionId, natGatewayId, ):
        """
        :param regionId: Region ID
        :param natGatewayId: natGateway ID
        """

        self.regionId = regionId
        self.natGatewayId = natGatewayId
        self.deleteElasticIp = None

    def setDeleteElasticIp(self, deleteElasticIp):
        """
        :param deleteElasticIp: (Optional) 是否打包删除公网IP，取值范围：true、false，默认false。true表示删除NAT网关时打包删除其绑定的所有公网IP；false表示删除NAT网关时不删除其绑定的所有公网IP。包年包月公网IP不支持打包删除
        """
        self.deleteElasticIp = deleteElasticIp

