# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CreateNatGatewayRequest(JDCloudRequest):
    """
    创建NAT网关接口
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(CreateNatGatewayRequest, self).__init__(
            '/regions/{regionId}/natGateways/', 'POST', header, version)
        self.parameters = parameters


class CreateNatGatewayParameters(object):

    def __init__(self,regionId, natGatewayName, vpcId, subnetId, ):
        """
        :param regionId: Region ID
        :param natGatewayName: NAT网关名称
        :param vpcId: 私有网络ID
        :param subnetId: 子网ID
        """

        self.regionId = regionId
        self.natGatewayName = natGatewayName
        self.natGatewaySpec = None
        self.vpcId = vpcId
        self.subnetId = subnetId
        self.azIpSpecs = None
        self.azs = None
        self.elasticIpIds = None
        self.elasticIpCount = None
        self.elasticIpSpec = None
        self.natGatewayCharge = None
        self.description = None

    def setNatGatewaySpec(self, natGatewaySpec):
        """
        :param natGatewaySpec: (Optional) NAT网关规格，取值small（100万并发连接数），medium（300万并发连接数），large（1000万并发连接数），默认small
        """
        self.natGatewaySpec = natGatewaySpec

    def setAzIpSpecs(self, azIpSpecs):
        """
        :param azIpSpecs: (Optional) NAT网关的可用区属性，即将废弃
        """
        self.azIpSpecs = azIpSpecs

    def setAzs(self, azs):
        """
        :param azs: (Optional) NAT网关可用区
        """
        self.azs = azs

    def setElasticIpIds(self, elasticIpIds):
        """
        :param elasticIpIds: (Optional) 选择已有公网IP列表。选择已有和新购公网IP可以同时配置，也可以配置其一
        """
        self.elasticIpIds = elasticIpIds

    def setElasticIpCount(self, elasticIpCount):
        """
        :param elasticIpCount: (Optional) 新购公网IP数量
        """
        self.elasticIpCount = elasticIpCount

    def setElasticIpSpec(self, elasticIpSpec):
        """
        :param elasticIpSpec: (Optional) 新购公网IP配置。NAT网关仅支持打包创建标准公网IP，不支持边缘公网IP。且标准公网IP仅支持按配置、按用量两种计费模式。
        """
        self.elasticIpSpec = elasticIpSpec

    def setNatGatewayCharge(self, natGatewayCharge):
        """
        :param natGatewayCharge: (Optional) 计费配置，仅支持按配置，默认按配置
        """
        self.natGatewayCharge = natGatewayCharge

    def setDescription(self, description):
        """
        :param description: (Optional) 描述,​ 允许输入UTF-8编码下的全部字符，不超过256字符
        """
        self.description = description

