# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class AssociateElasticIpsRequest(JDCloudRequest):
    """
    NAT网关绑定已有公网IP接口，NAT网关支持绑定一个或多个公网IP。当NAT网关绑定多个公网IP时，同一内网服务器的业务流量出公网将随机选取其中一个公网IP。由于每个内网服务器的业务流量大小不同，可能出现NAT多公网IP流量不均的情况。建议将多公网IP加入同一个共享带宽包，避免因业务流量达到单公网IP带宽上限，影响业务转发。
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(AssociateElasticIpsRequest, self).__init__(
            '/regions/{regionId}/natGateways/{natGatewayId}:associateElasticIps', 'POST', header, version)
        self.parameters = parameters


class AssociateElasticIpsParameters(object):

    def __init__(self,regionId, natGatewayId, elasticIpIds):
        """
        :param regionId: Region ID
        :param natGatewayId: natGateway ID
        :param elasticIpIds: 公网IP列表
        """

        self.regionId = regionId
        self.natGatewayId = natGatewayId
        self.elasticIpIds = elasticIpIds

