# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class ModifyInstancePlacementRequest(JDCloudRequest):
    """
    
存量主机加入高可用组。

存量主机加入高可用组，或者主机从一个高可用组移动到另一个高可用组

## 接口说明
- 不支持专属宿主机上的实例调整高可用组。
- 除GPU、vGPU（以P开头）外的一代机暂不支持调整高可用组。
- 与该高可用组关联实例模板的VPC不同的不支持调整高可用组。
- 与该高可用组可用区不匹配的实例不支持调整高可用组。
- 本地系统盘机型不支持强制均衡。
- 仅支持实例状态为已停止的实例强制均衡调整高可用组。
- 若不强制均衡，仅支持实例状态为运行中或已停止的实例调整高可用组。
- 若强制均衡，带本地数据盘的实例需确认清除本地盘数据。

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(ModifyInstancePlacementRequest, self).__init__(
            '/regions/{regionId}/instances/{instanceId}:modifyInstancePlacement', 'POST', header, version)
        self.parameters = parameters


class ModifyInstancePlacementParameters(object):

    def __init__(self,regionId, instanceId, ):
        """
        :param regionId: 地域ID。
        :param instanceId: 云主机ID。
        """

        self.regionId = regionId
        self.instanceId = instanceId
        self.agId = None
        self.balance = None
        self.clearLocalDisk = None
        self.isManaged = None

    def setAgId(self, agId):
        """
        :param agId: (Optional) 高可用组Id，必填项。
可查询 [DescribeAgs](https://docs.jdcloud.com/cn/availability-group/api/describeags) 接口获得高可用组信息。

        """
        self.agId = agId

    def setBalance(self, balance):
        """
        :param balance: (Optional) 是否强制均衡，默认 false

        """
        self.balance = balance

    def setClearLocalDisk(self, clearLocalDisk):
        """
        :param clearLocalDisk: (Optional) 是否确认清除本地盘数据，默认 false

        """
        self.clearLocalDisk = clearLocalDisk

    def setIsManaged(self, isManaged):
        """
        :param isManaged: (Optional) 是否托管实例的生命周期，默认为false；若为包年包月实例，可加入但不支持托管；该字段仅AG开启AS时生效。托管实例将在缩容或健康检查失败时被删除，非托管实例仅移出伸缩组

        """
        self.isManaged = isManaged

