# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class RestoreDatabaseFromOSSRequest(JDCloudRequest):
    """
    从上传到OSS的备份文件中恢复单个数据库<br>- 仅支持SQL Server
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(RestoreDatabaseFromOSSRequest, self).__init__(
            '/regions/{regionId}/instances/{instanceId}/databases/{dbName}:restoreDatabaseFromOSS', 'POST', header, version)
        self.parameters = parameters


class RestoreDatabaseFromOSSParameters(object):

    def __init__(self,regionId, instanceId, dbName, ossURL):
        """
        :param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)
        :param instanceId: RDS 实例ID，唯一标识一个RDS实例
        :param dbName: 库名称
        :param ossURL: 用户上传到对象存储OSS上的备份文件的路径。<br>例如用户备份上传的bucket为db_backup，文件为test_server/db1.bak，那么ossULR为db_backup/test_server/db1.bak。<br>**授权说明**：需要授予账户ID：785455908940，对这个bucket的读取权限，具体步骤可以查看[文档](https://docs.jdcloud.com/cn/object-storage-service/set-bucket-policy-2)。
        """

        self.regionId = regionId
        self.instanceId = instanceId
        self.dbName = dbName
        self.ossURL = ossURL

