# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class ModifyInstanceSpecRequest(JDCloudRequest):
    """
    实例扩容，支持升级实例的CPU，内存及磁盘。
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(ModifyInstanceSpecRequest, self).__init__(
            '/regions/{regionId}/instances/{instanceId}:modifyInstanceSpec', 'POST', header, version)
        self.parameters = parameters


class ModifyInstanceSpecParameters(object):

    def __init__(self,regionId, instanceId, newInstanceClass, newInstanceStorageGB, ):
        """
        :param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)
        :param instanceId: RDS 实例ID，唯一标识一个RDS实例
        :param newInstanceClass: 扩容后实例规格
        :param newInstanceStorageGB: 扩容后实例磁盘大小
        """

        self.regionId = regionId
        self.instanceId = instanceId
        self.newInstanceClass = newInstanceClass
        self.newInstanceStorageGB = newInstanceStorageGB
        self.newInstanceStorageType = None
        self.storageEncrypted = None
        self.subnetId = None
        self.effectiveTime = None
        self.postponeTime = None

    def setNewInstanceStorageType(self, newInstanceStorageType):
        """
        :param newInstanceStorageType: (Optional) 存储类型，如果不指定，默认会采用实例原存储类型.
        """
        self.newInstanceStorageType = newInstanceStorageType

    def setStorageEncrypted(self, storageEncrypted):
        """
        :param storageEncrypted: (Optional) 实例数据加密(存储类型为云硬盘才支持数据加密). false：不加密; true：加密. 如果实例从本地盘变为云硬盘，缺省为false. 如果实例本来就是使用云硬盘的，缺省和源实例保持一致
        """
        self.storageEncrypted = storageEncrypted

    def setSubnetId(self, subnetId):
        """
        :param subnetId: (Optional) 变配后的子网ID
        """
        self.subnetId = subnetId

    def setEffectiveTime(self, effectiveTime):
        """
        :param effectiveTime: (Optional) 生效时间，取值：<br>immediate：立即生效<br>maintainTime：在可维护时间段内生效。<br>postpone：延后生效。
        """
        self.effectiveTime = effectiveTime

    def setPostponeTime(self, postponeTime):
        """
        :param postponeTime: (Optional) 延后生效的时间，单位为分钟。effectiveTime为postpone时必传，取值1-1440分钟
        """
        self.postponeTime = postponeTime

