# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class ModifyInstanceMaintainTimeRequest(JDCloudRequest):
    """
    修改实例的可维护时间。实例可维护时间段一般设置为业务的低峰时间段。京东云会在您设置的可维护时间段内进行实例维护，保证对业务的影响降到最低。
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(ModifyInstanceMaintainTimeRequest, self).__init__(
            '/regions/{regionId}/instances/{instanceId}:modifyInstanceMaintainTime', 'POST', header, version)
        self.parameters = parameters


class ModifyInstanceMaintainTimeParameters(object):

    def __init__(self,regionId, instanceId, ):
        """
        :param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)
        :param instanceId: RDS 实例ID，唯一标识一个RDS实例
        """

        self.regionId = regionId
        self.instanceId = instanceId
        self.maintainTime = None
        self.maintainPeriod = None

    def setMaintainTime(self, maintainTime):
        """
        :param maintainTime: (Optional) 实例的可维护时间段。格式：HH:mm-HH:mm，取值为一个小时整点
        """
        self.maintainTime = maintainTime

    def setMaintainPeriod(self, maintainPeriod):
        """
        :param maintainPeriod: (Optional) 选择维护周期，可选择一周中的某一天或多天
        """
        self.maintainPeriod = maintainPeriod

