# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CreateParameterGroupRequest(JDCloudRequest):
    """
    创建一个参数组<br>- 仅支持MySQL，Percona，MariaDB，PostgreSQL
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(CreateParameterGroupRequest, self).__init__(
            '/regions/{regionId}/parameterGroups', 'POST', header, version)
        self.parameters = parameters


class CreateParameterGroupParameters(object):

    def __init__(self,regionId, engine, engineVersion, parameterGroupName, ):
        """
        :param regionId: Region ID
        :param engine: 实例引擎类型，参见[枚举参数定义](../Enum-Definitions/Enum-Definitions.md)
        :param engineVersion: 实例引擎版本，参见[枚举参数定义](../Enum-Definitions/Enum-Definitions.md)
        :param parameterGroupName: 参数组的名字
        """

        self.regionId = regionId
        self.engine = engine
        self.engineVersion = engineVersion
        self.parameterGroupName = parameterGroupName
        self.description = None

    def setDescription(self, description):
        """
        :param description: (Optional) 参数组的描述
        """
        self.description = description

