# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CreateBackupRequest(JDCloudRequest):
    """
    创建一个RDS实例全量备份，可以对整个实例或者部分数据库（仅SQL Server支持）进行全量备份。同一时间点，只能有一个正在运行的备份任务
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(CreateBackupRequest, self).__init__(
            '/regions/{regionId}/backups', 'POST', header, version)
        self.parameters = parameters


class CreateBackupParameters(object):

    def __init__(self,regionId, ):
        """
        :param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)
        """

        self.regionId = regionId
        self.instanceId = None
        self.backupSpec = None

    def setInstanceId(self, instanceId):
        """
        :param instanceId: (Optional) RDS实例ID，唯一标识一个实例
        """
        self.instanceId = instanceId

    def setBackupSpec(self, backupSpec):
        """
        :param backupSpec: (Optional) 备份规格
        """
        self.backupSpec = backupSpec

