# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.


class ClusterSpec(object):

    def __init__(self, name, password, version, masterNodeCount, masterSystemDiskType, masterSystemDiskVolume, masterDiskType, masterDiskVolume, masterInstanceType, slaveNodeCount, slaveSystemDiskType, slaveSystemDiskVolume, slaveDiskType, slaveDiskVolume, coreInstanceType, jssFlag, dataCenter, softwareList, haFlag, vpcId, vpcSubnetId, az, payType=None, masterSystemDiskIops=None, masterDiskIops=None, slaveSystemDiskIops=None, slaveDiskIops=None, createOuterIpFlag=None, createSecurityGroupFlag=None, securityGroupId=None):
        """
        :param name:  集群名称(不能少于6字符不能超过20字符，除下划线外不能包含特殊符号)
        :param password:  集群root用户密码(须包含大小写字母、数字及特殊字符其中三类，且不能少于8字符不能超过30字符)
        :param version:  集群版本，默认版本为JMR2.0.0
        :param payType: (Optional) 集群计费类型，支持按配置和包年包月计费
        :param masterNodeCount:  主节点数量
        :param masterSystemDiskType:  Master系统硬盘类型：ssd.gp1,ssd.io1和hdd.std1
        :param masterSystemDiskVolume:  Master系统硬盘大小，单位GB
        :param masterSystemDiskIops: (Optional) Master系统硬盘iops，只有在硬盘类型是ssd.gp1,ssd.io1时，才需要有iops，200起步，步长为10
        :param masterDiskType:  Master数据盘类型：ssd.gp1,ssd.io1和hdd.std1
        :param masterDiskVolume:  Master数据盘大小，单位GB
        :param masterDiskIops: (Optional) Master数据盘ipos，只有在硬盘类型是ssd.gp1,ssd.io1时，才需要有iops，200起步，步长为10
        :param masterInstanceType:  master节点规格
        :param slaveNodeCount:  Slave节点数量
        :param slaveSystemDiskType:  Slave系统硬盘类型：ssd.gp1,ssd.io1和hdd.std1
        :param slaveSystemDiskVolume:  Slave系统硬盘大小，单位GB
        :param slaveSystemDiskIops: (Optional) Slave系统硬盘iops，只有在硬盘类型是ssd.gp1,ssd.io1时，才需要有iops，200起步，步长为10
        :param slaveDiskType:  Slave数据盘类型：ssd.gp1,ssd.io1和hdd.std1
        :param slaveDiskVolume:  Slave数据盘大小，单位GB
        :param slaveDiskIops: (Optional) Slave数据盘ipos，只有在硬盘类型是ssd.gp1,ssd.io1时，才需要有iops，200起步，步长为10
        :param coreInstanceType:  slave节点规格
        :param jssFlag:  关联JSS
        :param dataCenter:  数据中心，即regionId
        :param softwareList:  软件列表
        :param haFlag:  集群是否为高可用，默认为高可用集群
        :param vpcId:  Vpc网络ID
        :param vpcSubnetId:  Vpc子网ID
        :param az:  数据中心的可用区
        :param createOuterIpFlag: (Optional) 是否创建公网IP
        :param createSecurityGroupFlag: (Optional) 是否创建安全组
        :param securityGroupId: (Optional) 安全组ID
        """

        self.name = name
        self.password = password
        self.version = version
        self.payType = payType
        self.masterNodeCount = masterNodeCount
        self.masterSystemDiskType = masterSystemDiskType
        self.masterSystemDiskVolume = masterSystemDiskVolume
        self.masterSystemDiskIops = masterSystemDiskIops
        self.masterDiskType = masterDiskType
        self.masterDiskVolume = masterDiskVolume
        self.masterDiskIops = masterDiskIops
        self.masterInstanceType = masterInstanceType
        self.slaveNodeCount = slaveNodeCount
        self.slaveSystemDiskType = slaveSystemDiskType
        self.slaveSystemDiskVolume = slaveSystemDiskVolume
        self.slaveSystemDiskIops = slaveSystemDiskIops
        self.slaveDiskType = slaveDiskType
        self.slaveDiskVolume = slaveDiskVolume
        self.slaveDiskIops = slaveDiskIops
        self.coreInstanceType = coreInstanceType
        self.jssFlag = jssFlag
        self.dataCenter = dataCenter
        self.softwareList = softwareList
        self.haFlag = haFlag
        self.vpcId = vpcId
        self.vpcSubnetId = vpcSubnetId
        self.az = az
        self.createOuterIpFlag = createOuterIpFlag
        self.createSecurityGroupFlag = createSecurityGroupFlag
        self.securityGroupId = securityGroupId
