# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.


class WebRuleSpec(object):

    def __init__(self, domain, protocol, originType, algorithm, webSocketStatus, serviceIp=None, serviceIps=None, port=None, httpsPort=None, originAddr=None, onlineAddr=None, originDomain=None, forceJump=None, customPortStatus=None, httpOrigin=None, geoRsRoute=None, enableKeepalive=None, httpVersion=None, sslProtocols=None, suiteLevel=None, userSuiteLevel=None, enableHealthCheck=None, proxyConnectTimeout=None, enableUnderscores=None):
        """
        :param serviceIp: (Optional) 高防 IP, serviceIps 为空时生效
        :param serviceIps: (Optional) 高防 IP 列表, 不为空时忽略 serviceIp, 传多个时后台会在高防IP封禁后随机切换其他未封禁的IP
        :param domain:  子域名
        :param protocol:  协议: http, https 至少一个为 true
        :param port: (Optional) HTTP 协议的端口号, 如80, 81; 如果 protocol.http 为 true, 至少配置一个端口
        :param httpsPort: (Optional) HTTPS 协议的端口号, 如443, 8443; 如果 protocol.https 为 true, 至少配置一个端口
        :param originType:  回源类型：A 或者 CNAME
        :param originAddr: (Optional) originType 为 A 时, 需要设置该字段
        :param onlineAddr: (Optional) 备用的回源地址列表, 可以配置为一个域名或者多个 ip 地址
        :param originDomain: (Optional) 回源域名, originType 为 CNAME 时需要指定该字段
        :param algorithm:  转发规则. <br>- wrr: 带权重的轮询<br>- rr:  不带权重的轮询<br>- sh:  源地址hash
        :param forceJump: (Optional) 是否开启 HTTPS 强制跳转, protocol.http 和 protocol.https 都为 true 时此参数生效. <br>- 0: 不开启强制跳转. <br>- 1: 开启强制跳转
        :param customPortStatus: (Optional) 是否为自定义端口号. 0: 默认<br>- 1: 自定义
        :param httpOrigin: (Optional) 是否开启 HTTP 回源, protocol.https 为 true 时此参数生效. <br>- 0: 不开启. <br>- 1: 开启
        :param webSocketStatus:  是否开启 WebSocket.<br>- 0: 不开启<br>- 1: 开启
        :param geoRsRoute: (Optional) 按区域分流回源配置
        :param enableKeepalive: (Optional) 是否开启回源长连接, protocol 选项开启 https 时生效, 可取值<br>- on: 开启<br>- off: 关闭
        :param httpVersion: (Optional) http 版本, protocol 选项开启 https 时生效, 可取值 http1 或 http2
        :param sslProtocols: (Optional) SSL协议类型, protocol 选项开启 https 时生效, 可取值SSLv2,SSLv3,TLSv1.0,TLSv1.1,TLSv1.2
        :param suiteLevel: (Optional) 加密套件等级, protocol 选项开启 https 时生效, 可取值<br>- low: 低级<br>- middle: 中级<br>- high：高级<br>- custom：自定义
        :param userSuiteLevel: (Optional) 自定义加密套件等级, suiteLevel 为 custom 是有效
        :param enableHealthCheck: (Optional) 健康检查开关, 0: 关闭, 1: 开启
        :param proxyConnectTimeout: (Optional) 回源连接超时时长, 单位 秒
        :param enableUnderscores: (Optional) 请求头支持下划线, 0: 关闭, 1: 开启
        """

        self.serviceIp = serviceIp
        self.serviceIps = serviceIps
        self.domain = domain
        self.protocol = protocol
        self.port = port
        self.httpsPort = httpsPort
        self.originType = originType
        self.originAddr = originAddr
        self.onlineAddr = onlineAddr
        self.originDomain = originDomain
        self.algorithm = algorithm
        self.forceJump = forceJump
        self.customPortStatus = customPortStatus
        self.httpOrigin = httpOrigin
        self.webSocketStatus = webSocketStatus
        self.geoRsRoute = geoRsRoute
        self.enableKeepalive = enableKeepalive
        self.httpVersion = httpVersion
        self.sslProtocols = sslProtocols
        self.suiteLevel = suiteLevel
        self.userSuiteLevel = userSuiteLevel
        self.enableHealthCheck = enableHealthCheck
        self.proxyConnectTimeout = proxyConnectTimeout
        self.enableUnderscores = enableUnderscores
