# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.


class TriggerSpec(object):

    def __init__(self, triggerName, triggerType, triggerConfig, sourceJrn, description=None, enable=None):
        """
        :param triggerName:  触发器名称，不可为空，只支持中文、数字、大小写字母、英文下划线“_”及中划线“-”，且不能超过32字符。
        :param triggerType:  触发器类型,目前仅支持oss类型触发器。
        :param triggerConfig:  触发器详细配置。示例 {"events": ["oss:ObjectCreated:*"], "filter": {"key": {"prefix": "source", "suffix": ".zip"}}}，
代表源bucket中发生上传以source开头，以.zip结尾的文件时，会触发函数执行。强烈建议配置filter参数以避免循环调用。
具体支持的事件类型见[OSS设置事件通知](https://docs.jdcloud.com/cn/object-storage-service/event-notifications-1)。

        :param description: (Optional) 描述信息，默认为空；允许输入UTF-8编码下的全部字符，不超过256字符。
        :param sourceJrn:  触发器事件源，使用京东云资源标识(jrn)表示，例如jrn:oss:cn-north-1::example来表示在cn-north-1区域下名为example的bucket。
详情可以参考[基于IAM Policy的权限控制](https://docs.jdcloud.com/cn/object-storage-service/access-control-base-on-iam-policy)，
创建oss类型的触发器时，会使用函数计算服务的服务相关角色在对应的bucket中创建事件通知。

        :param enable: (Optional) 触发器是否启用,默认为启用。
        """

        self.triggerName = triggerName
        self.triggerType = triggerType
        self.triggerConfig = triggerConfig
        self.description = description
        self.sourceJrn = sourceJrn
        self.enable = enable
