# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class UpdateTriggerRequest(JDCloudRequest):
    """
    修改触发器配置

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(UpdateTriggerRequest, self).__init__(
            '/regions/{regionId}/services/{serviceName}/functions/{functionName}/triggers/{triggerName}', 'PATCH', header, version)
        self.parameters = parameters


class UpdateTriggerParameters(object):

    def __init__(self,regionId, serviceName, functionName, triggerName, ):
        """
        :param regionId: 地域ID。
        :param serviceName: 服务名称。
        :param functionName: 函数名称。
        :param triggerName: 触发器名称。
        """

        self.regionId = regionId
        self.serviceName = serviceName
        self.functionName = functionName
        self.triggerName = triggerName
        self.description = None
        self.triggerConfig = None
        self.enable = None

    def setDescription(self, description):
        """
        :param description: (Optional) 修改后的描述
        """
        self.description = description

    def setTriggerConfig(self, triggerConfig):
        """
        :param triggerConfig: (Optional) 修改后的配置
        """
        self.triggerConfig = triggerConfig

    def setEnable(self, enable):
        """
        :param enable: (Optional) 是否启用或禁用触发器，默认为不更改触发器状态
        """
        self.enable = enable

