# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class UpdateFunctionRequest(JDCloudRequest):
    """
    修改 function

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(UpdateFunctionRequest, self).__init__(
            '/regions/{regionId}/services/{serviceName}/functions/{functionName}', 'PATCH', header, version)
        self.parameters = parameters


class UpdateFunctionParameters(object):

    def __init__(self,regionId, serviceName, functionName, ):
        """
        :param regionId: Region ID
        :param serviceName: Service Name
        :param functionName: Function Name
        """

        self.regionId = regionId
        self.serviceName = serviceName
        self.functionName = functionName
        self.code = None
        self.timeout = None
        self.runtime = None
        self.handler = None
        self.description = None
        self.envs = None
        self.cpu = None
        self.memorySize = None
        self.diskSize = None

    def setCode(self, code):
        """
        :param code: (Optional) 修改后的代码
        """
        self.code = code

    def setTimeout(self, timeout):
        """
        :param timeout: (Optional) 修改后的超时时间
        """
        self.timeout = timeout

    def setRuntime(self, runtime):
        """
        :param runtime: (Optional) 修改后的运行时语言
        """
        self.runtime = runtime

    def setHandler(self, handler):
        """
        :param handler: (Optional) 修改后的函数执行入口
        """
        self.handler = handler

    def setDescription(self, description):
        """
        :param description: (Optional) 修改后的描述
        """
        self.description = description

    def setEnvs(self, envs):
        """
        :param envs: (Optional) 修改后的环境变量
        """
        self.envs = envs

    def setCpu(self, cpu):
        """
        :param cpu: (Optional) 修改后的cpu
        """
        self.cpu = cpu

    def setMemorySize(self, memorySize):
        """
        :param memorySize: (Optional) 修改后的内存
        """
        self.memorySize = memorySize

    def setDiskSize(self, diskSize):
        """
        :param diskSize: (Optional) 修改后的磁盘
        """
        self.diskSize = diskSize

