# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CreateTriggerRequest(JDCloudRequest):
    """
    创建触发器。
目前支持的触发器类型有：
- oss

## 注意事项
- 一个函数下最多同时存在10个触发器。
- oss类型触发器会在对应的bucket中添加一个事件通知，若该bucket中已存在相同事件类型的事件通知，触发器可能无法生效。
- 创建多个相同类型的oss触发器，当对应的事件发生时，只有一个触发器会被调用。
- 若人为修改或删除了bucket中的事件通知，可能导致oss触发器失效。

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(CreateTriggerRequest, self).__init__(
            '/regions/{regionId}/services/{serviceName}/functions/{functionName}/triggers', 'POST', header, version)
        self.parameters = parameters


class CreateTriggerParameters(object):

    def __init__(self,regionId, serviceName, functionName, triggerSpec):
        """
        :param regionId: 地域ID。
        :param serviceName: 服务名称。
        :param functionName: 函数名称。
        :param triggerSpec: 触发器创建参数
        """

        self.regionId = regionId
        self.serviceName = serviceName
        self.functionName = functionName
        self.triggerSpec = triggerSpec

