# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CreateTransmissionTaskRequest(JDCloudRequest):
    """
    创建数据传输任务
    """

    def __init__(self, parameters, header=None, version="v2"):
        super(CreateTransmissionTaskRequest, self).__init__(
            '/regions/{regionId}/dts', 'POST', header, version)
        self.parameters = parameters


class CreateTransmissionTaskParameters(object):

    def __init__(self,regionId, vpc, subnet, instanceClass, chargeSpec):
        """
        :param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》]
        :param vpc: 数据传输实例所属VPC。
        :param subnet: 数据传输实例所属子网。
        :param instanceClass: 数据传输实例规格，支持：dts.m1.medium、dts.m1.large、dts.m1.xlarge
        :param chargeSpec: 计费方式，数据传输支持包年包月、按配置计费。
        """

        self.regionId = regionId
        self.transmissionMethod = None
        self.topology = None
        self.vpc = vpc
        self.subnet = subnet
        self.availableZone = None
        self.instanceClass = instanceClass
        self.chargeSpec = chargeSpec

    def setTransmissionMethod(self, transmissionMethod):
        """
        :param transmissionMethod: (Optional) 实例类型，取值为：Sync：同步、Subscribe：订阅、Migration：迁移、DisasterRecovery 灾备，默认取值为：Sync
        """
        self.transmissionMethod = transmissionMethod

    def setTopology(self, topology):
        """
        :param topology: (Optional) 数据传输拓扑，支持：oneway - 单向数据传输、bidirectional - 双向数据传输，默认取值为：oneway
        """
        self.topology = topology

    def setAvailableZone(self, availableZone):
        """
        :param availableZone: (Optional) 数据传输实例所属可用区，可选
        """
        self.availableZone = availableZone

