# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class ConfigureTransmissionTaskRequest(JDCloudRequest):
    """
    配置数据传输任务
    """

    def __init__(self, parameters, header=None, version="v2"):
        super(ConfigureTransmissionTaskRequest, self).__init__(
            '/regions/{regionId}/dts/{taskId}/configure', 'POST', header, version)
        self.parameters = parameters


class ConfigureTransmissionTaskParameters(object):

    def __init__(self,regionId, taskId, transmissionObject, taskName, source, destination, ):
        """
        :param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》]
        :param taskId: DTS数据传输任务ID
        :param transmissionObject: 待传输的对象
        :param taskName: 任务名称，名称只支持中文、数字、大小写字母及英文下划线“_”及中划线“-”，不超过32字符
        :param source: 源端连接信息
        :param destination: 目标端连接信息
        """

        self.regionId = regionId
        self.taskId = taskId
        self.transmissionMode = None
        self.destExecutionStrategy = None
        self.options = None
        self.transmissionObject = transmissionObject
        self.taskName = taskName
        self.source = source
        self.destination = destination
        self.checkPoint = None
        self.customOptions = None

    def setTransmissionMode(self, transmissionMode):
        """
        :param transmissionMode: (Optional) 传输任务模式：可选值：structureInitialization、dataInitialization、dataSynchronization，分别对应结构初始化，全量数据初始化，增量数据传输
        """
        self.transmissionMode = transmissionMode

    def setDestExecutionStrategy(self, destExecutionStrategy):
        """
        :param destExecutionStrategy: (Optional) 目标端执行策略，对于目标MySQL，支持：覆盖写入 mysql-replace-engine，冲突检测 conflict-detect-engine
        """
        self.destExecutionStrategy = destExecutionStrategy

    def setOptions(self, options):
        """
        :param options: (Optional) 任务设置
        """
        self.options = options

    def setCheckPoint(self, checkPoint):
        """
        :param checkPoint: (Optional) 增量数据传输的启动位点
        """
        self.checkPoint = checkPoint

    def setCustomOptions(self, customOptions):
        """
        :param customOptions: (Optional) 任务自定义设置
        """
        self.customOptions = customOptions

