# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.


class ConnectionSpec(object):

    def __init__(self, connectionName, type, partnerCode=None, description=None, idcAddress=None, contactName=None, phoneNumber=None, chargeDuration=None, autoPay=None, location=None):
        """
        :param connectionName:  连接的名称,只允许输入中文、数字、大小写字母、英文下划线“_”及中划线“-”，不允许为空且不超过32字符。
        :param partnerCode: (Optional) 合作伙伴编码;只在创建合作伙伴连接时生效，通过调用[describePartners](../Partner/describePartners.md)接口获取
        :param type:  创建专线类型；jcloud_hosted:托管连接; jcloud_partner:合作伙伴连接; jcloud:自助连接
        :param description: (Optional) 专线的描述，允许输入UTF-8编码下的全部字符，不超过256字符。
        :param idcAddress: (Optional) 客户idc地址，允许输入UTF-8编码下的全部字符，不超过256字符。
        :param contactName: (Optional) 联系人名称，只允许输入中文、数字、大小写字母、英文下划线“_”及中划线“-”，不允许为空且不超过32字符。
        :param phoneNumber: (Optional) 联系人手机号码，11位数字且需要13、14、15、16、17、18、19开头
        :param chargeDuration: (Optional) 合作伙伴连接的时长，取值范围：1,3,6,12,24,36，单位月，默认值为6
        :param autoPay: (Optional) 初装费订单自动支付设置,取值范围：true,false,值为true时自动支付
        :param location: (Optional) 专线接入点信息,type为jcloud或jcloud_hosted时必传
        """

        self.connectionName = connectionName
        self.partnerCode = partnerCode
        self.type = type
        self.description = description
        self.idcAddress = idcAddress
        self.contactName = contactName
        self.phoneNumber = phoneNumber
        self.chargeDuration = chargeDuration
        self.autoPay = autoPay
        self.location = location
