# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class InvokeCommandRequest(JDCloudRequest):
    """
    
执行用户保存的自定义命令。

详细操作说明请参考帮助文档：[用户自定义命令概述](https://docs.jdcloud.com/cn/virtual-machines/assistant-overview)

## 接口说明
- 该接口用于执行用户保存的自定义命令。

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(InvokeCommandRequest, self).__init__(
            '/regions/{regionId}/invokeCommand', 'POST', header, version)
        self.parameters = parameters


class InvokeCommandParameters(object):

    def __init__(self,regionId, commandId, instances, ):
        """
        :param regionId: 地域ID。
        :param commandId: 命令Id

        :param instances: 运行该命令的云主机，最多云主机数50

        """

        self.regionId = regionId
        self.commandId = commandId
        self.instances = instances
        self.timeout = None
        self.username = None
        self.workdir = None
        self.windowsPassword = None
        self.enableParameter = None
        self.parameters = None

    def setTimeout(self, timeout):
        """
        :param timeout: (Optional) 超时时间，取值范围：[10, 86400], 超过该时间后，尚未执行完的命令会置为失败。默认60s

        """
        self.timeout = timeout

    def setUsername(self, username):
        """
        :param username: (Optional) 用户名，执行该命令时的用户身份。在linux上默认是root，windows上默认是administrator。长度小于256

        """
        self.username = username

    def setWorkdir(self, workdir):
        """
        :param workdir: (Optional) 命令执行路径，在linux上默认为用户的home目录：/root, 在windows上默认为：C:\Windows\system32

        """
        self.workdir = workdir

    def setWindowsPassword(self, windowsPassword):
        """
        :param windowsPassword: (Optional) 和用户名相匹配的密码，仅适用于windows系统

        """
        self.windowsPassword = windowsPassword

    def setEnableParameter(self, enableParameter):
        """
        :param enableParameter: (Optional) 脚本中是否启用参数，true：启用，false：不启用。

        """
        self.enableParameter = enableParameter

    def setParameters(self, parameters):
        """
        :param parameters: (Optional) 用户自定义参数和对应的参数值，数量不超过20。

        """
        self.parameters = parameters

