# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DescribeInvocationsRequest(JDCloudRequest):
    """
    
查询命令调用。

详细操作说明请参考帮助文档：[用户自定义命令概述](https://docs.jdcloud.com/cn/virtual-machines/assistant-overview)

## 接口说明
- 该接口用于查询命令调用。

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(DescribeInvocationsRequest, self).__init__(
            '/regions/{regionId}/describeInvocations', 'POST', header, version)
        self.parameters = parameters


class DescribeInvocationsParameters(object):

    def __init__(self,regionId, ):
        """
        :param regionId: 地域ID。
        """

        self.regionId = regionId
        self.pageNumber = None
        self.pageSize = None
        self.invokeIds = None
        self.commandIds = None
        self.status = None
        self.commandNames = None
        self.commandTypes = None
        self.userNames = None

    def setPageNumber(self, pageNumber):
        """
        :param pageNumber: (Optional) 页数，默认是第一页，取值1

        """
        self.pageNumber = pageNumber

    def setPageSize(self, pageSize):
        """
        :param pageSize: (Optional) 每页大小，默认20, 最大100

        """
        self.pageSize = pageSize

    def setInvokeIds(self, invokeIds):
        """
        :param invokeIds: (Optional) 命令执行Id

        """
        self.invokeIds = invokeIds

    def setCommandIds(self, commandIds):
        """
        :param commandIds: (Optional) 命令Id

        """
        self.commandIds = commandIds

    def setStatus(self, status):
        """
        :param status: (Optional) 命令执行状态

        """
        self.status = status

    def setCommandNames(self, commandNames):
        """
        :param commandNames: (Optional) 命令名字

        """
        self.commandNames = commandNames

    def setCommandTypes(self, commandTypes):
        """
        :param commandTypes: (Optional) 命令类型， shell or powershell

        """
        self.commandTypes = commandTypes

    def setUserNames(self, userNames):
        """
        :param userNames: (Optional) 命令执行用户

        """
        self.userNames = userNames

