# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DescribeCommandsRequest(JDCloudRequest):
    """
    
查询用户自定义命令。

详细操作说明请参考帮助文档：[用户自定义命令概述](https://docs.jdcloud.com/cn/virtual-machines/assistant-overview)

## 接口说明
- 该接口用于查询用户保存的自定义命令。

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(DescribeCommandsRequest, self).__init__(
            '/regions/{regionId}/describeCommands', 'POST', header, version)
        self.parameters = parameters


class DescribeCommandsParameters(object):

    def __init__(self,regionId, ):
        """
        :param regionId: 地域ID。
        """

        self.regionId = regionId
        self.pageNumber = None
        self.pageSize = None
        self.commandIds = None
        self.commandNames = None
        self.commandTypes = None
        self.sourceType = None
        self.usernames = None

    def setPageNumber(self, pageNumber):
        """
        :param pageNumber: (Optional) 页数，默认是第一页，取值为 1

        """
        self.pageNumber = pageNumber

    def setPageSize(self, pageSize):
        """
        :param pageSize: (Optional) 每页命令数，默认为20，最大为100

        """
        self.pageSize = pageSize

    def setCommandIds(self, commandIds):
        """
        :param commandIds: (Optional) 命令Id

        """
        self.commandIds = commandIds

    def setCommandNames(self, commandNames):
        """
        :param commandNames: (Optional) 命令名称，长度为1\~128个字符，只允许中文、数字、大小写字母、英文下划线（\_）、连字符（-）及点（.）。

        """
        self.commandNames = commandNames

    def setCommandTypes(self, commandTypes):
        """
        :param commandTypes: (Optional) 命令类型，可选值：shell和powershell，默认shell

        """
        self.commandTypes = commandTypes

    def setSourceType(self, sourceType):
        """
        :param sourceType: (Optional) 命令来源，可选值：jdcloud（官方）和self，默认self

        """
        self.sourceType = sourceType

    def setUsernames(self, usernames):
        """
        :param usernames: (Optional) 用户名，执行该命令时的用户身份。在linux上默认是root，windows上默认是administrator。长度小于256

        """
        self.usernames = usernames

