# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class EnableAutoScalingRequest(JDCloudRequest):
    """
    开启弹性伸缩功能
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(EnableAutoScalingRequest, self).__init__(
            '/regions/{regionId}/autoScaling/{agId}', 'POST', header, version)
        self.parameters = parameters


class EnableAutoScalingParameters(object):

    def __init__(self,regionId, agId, ):
        """
        :param regionId: 地域
        :param agId: 高可用组 ID
        """

        self.regionId = regionId
        self.agId = agId
        self.isManaged = None
        self.autoscalingSpec = None

    def setIsManaged(self, isManaged):
        """
        :param isManaged: (Optional) 高可用中实例是否托管给弹性伸缩组，托管后缩容时可以删除该实例，默认false
        """
        self.isManaged = isManaged

    def setAutoscalingSpec(self, autoscalingSpec):
        """
        :param autoscalingSpec: (Optional) 伸缩组详细信息，如果高可用组已开启过伸缩功能，该参数将被忽略
        """
        self.autoscalingSpec = autoscalingSpec

