# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CreateAsRuleRequest(JDCloudRequest):
    """
    创建伸缩规则
- 所有参数取值为字符串类型的都严格区分大小写
- 伸缩功能关闭的情况下，不支持调用此接口
- 目标跟踪规则创建后会自动生成两个告警任务，分别用于扩容和缩容
- 步进规则必须绑定一个告警任务

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(CreateAsRuleRequest, self).__init__(
            '/regions/{regionId}/asRules', 'POST', header, version)
        self.parameters = parameters


class CreateAsRuleParameters(object):

    def __init__(self,regionId, agId, name, asRuleType, ):
        """
        :param regionId: 地域ID
        :param agId: 高可用组ID
        :param name: 伸缩规则名称，长度为1~32个字符，只允许中文、数字、大小写字母、英文下划线（_）、连字符（-）
        :param asRuleType: 伸缩规则类型，取值范围：[`Simple`,`Target`,`Step`]
- `Simple`：简单规则，直接设置调整方式和调整值
- `Target`：目标跟踪规则，根据监控项和目标值计算需要扩缩容的实例数量，尽量将监控项的指标值维持在目标值和目标值的90%之间
- `Step`：步进规则，根据阈值和指标值提供分步扩展方式

        """

        self.regionId = regionId
        self.agId = agId
        self.name = name
        self.description = None
        self.asRuleType = asRuleType
        self.simpleAsRuleSpec = None
        self.targetAsRuleSpec = None
        self.stepAsRuleSpec = None

    def setDescription(self, description):
        """
        :param description: (Optional) 伸缩规则描述，最大长度为256个字符
        """
        self.description = description

    def setSimpleAsRuleSpec(self, simpleAsRuleSpec):
        """
        :param simpleAsRuleSpec: (Optional) 简单规则相关参数，当`asRuleType`为`Simple`时必填
        """
        self.simpleAsRuleSpec = simpleAsRuleSpec

    def setTargetAsRuleSpec(self, targetAsRuleSpec):
        """
        :param targetAsRuleSpec: (Optional) 目标跟踪规则相关参数，当`asRuleType`为`Target`时必填
        """
        self.targetAsRuleSpec = targetAsRuleSpec

    def setStepAsRuleSpec(self, stepAsRuleSpec):
        """
        :param stepAsRuleSpec: (Optional) 步进规则相关参数，当`asRuleType`为`Step`时必填
        """
        self.stepAsRuleSpec = stepAsRuleSpec

